/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache.localcache;

import com.gigaspaces.internal.client.cache.AbstractSpaceCache;
import com.gigaspaces.internal.client.cache.AbstractSpaceCacheContainer;
import com.gigaspaces.internal.client.cache.localcache.LocalCache;
import com.gigaspaces.internal.client.cache.localcache.LocalCacheConfig;
import com.gigaspaces.internal.client.cache.localcache.actions.LocalCacheImplActionManager;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.actions.AbstractSpaceProxyActionManager;
import com.gigaspaces.time.SystemTime;
import java.util.logging.Logger;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.server.ServerTransaction;

public class LocalCacheContainer
extends AbstractSpaceCacheContainer {
    private final LocalCacheConfig _cacheConfig;

    public LocalCacheContainer(IDirectSpaceProxy remoteProxy, LocalCacheConfig cacheConfig) {
        super(remoteProxy, cacheConfig);
        this._cacheConfig = cacheConfig;
    }

    public IDirectSpaceProxy getNotificationsDirectProxy() {
        return this.getRemoteSpace();
    }

    @Override
    public LocalCacheConfig getCacheConfig() {
        return this._cacheConfig;
    }

    @Override
    protected AbstractSpaceCache createSpaceCache() {
        return new LocalCache(this);
    }

    protected AbstractSpaceProxyActionManager<LocalCacheContainer> createActionManager() {
        return new LocalCacheImplActionManager(this);
    }

    public LocalCache assertCacheConnectedOrConnecting() {
        return (LocalCache)super.assertCacheConnected();
    }

    @Override
    protected Logger initLogger() {
        return Logger.getLogger("com.gigaspaces.localcache");
    }

    public String getCacheTypeName() {
        return "LocalCache";
    }

    public boolean isLocalCacheCacheContainer() {
        return true;
    }

    public static final class GCEntry {
        public final long _ttl;
        public final ServerTransaction _xtn;
        private final long _insertionTime;

        public GCEntry(Transaction xtn) {
            this(0L, xtn);
        }

        public GCEntry(long ttl, Transaction xtn) {
            this._ttl = ttl;
            this._xtn = (ServerTransaction)xtn;
            this._insertionTime = SystemTime.timeMillis();
        }

        public long getInsertionTime() {
            return this._insertionTime;
        }
    }
}

