/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache.localcache;

import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.events.batching.BatchRemoteEvent;
import com.gigaspaces.events.batching.BatchRemoteEventListener;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.cache.localcache.LocalCache;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.UnknownEventException;

public class LocalCacheListener
implements BatchRemoteEventListener {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.localcache");
    private final LocalCache _localCache;

    public LocalCacheListener(LocalCache localCache) {
        this._localCache = localCache;
    }

    public void notify(RemoteEvent event) throws UnknownEventException, RemoteException {
        this.consumeEvent((EntryArrivedRemoteEvent)event);
    }

    public void notifyBatch(BatchRemoteEvent event) throws UnknownEventException, RemoteException {
        for (RemoteEvent remoteEvent : event.getEvents()) {
            this.consumeEvent((EntryArrivedRemoteEvent)remoteEvent);
        }
    }

    private void consumeEvent(EntryArrivedRemoteEvent event) {
        block8: {
            String uid = null;
            try {
                OperationID operationId = event.getOperationID();
                long clientId = operationId.getClientID();
                if (this._localCache.getLocalProxy().getClientID() == clientId) {
                    return;
                }
                NotifyActionType eventType = event.getNotifyActionType();
                uid = event.getEntryPacket().getUID();
                switch (eventType.getModifier()) {
                    case 4: {
                        this._localCache.removeFromCache(uid, null, true);
                        break;
                    }
                    case 2: {
                        if (this._localCache.getUpdateMode() == 2) {
                            this.updateUid(event.getEntryPacket());
                            break;
                        }
                        this._localCache.removeFromCache(uid, null, false);
                    }
                }
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block8;
                _logger.log(Level.SEVERE, "LocalCache received an event [type=" + event.getNotifyActionType().toString() + "] that entry [" + uid + "] has been modified, but failed to process it.", e);
            }
        }
    }

    private void updateUid(IEntryPacket ep) throws Exception {
        Object entry = this._localCache.getRemoteProxy().readByUid(ep.getUID(), null, this._localCache.getRemoteProxy().getReadModifiers(), QueryResultTypeInternal.NOT_SET, true);
        if (entry == null) {
            this._localCache.removeFromCache(ep.getUID(), null, false);
        } else {
            long lease = Math.min(this._localCache.getMaxTimeToLive(), ep.getTTL());
            this._localCache.updateCache(ep, entry, null, lease, 8, 0L);
        }
    }
}

