/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache.localcache.actions;

import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.async.internal.AbstractFuture;
import com.gigaspaces.async.internal.DefaultAsyncResult;
import com.gigaspaces.internal.client.cache.localcache.LocalCache;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.ReadTakeAsyncProxyActionInfo;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.utils.concurrent.ContextClassLoaderRunnable;
import com.gigaspaces.lrmi.LRMIRuntime;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.client.EntryVersionConflictException;
import java.rmi.RemoteException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

public class LocalCacheImplAsyncOperationsFuture<T>
extends AbstractFuture<T> {
    private final LocalCache _cache;
    private final ReadTakeAsyncProxyActionInfo _actionInfo;
    private final AsyncFuture<T> _internalFuture;
    private final ClassLoader _contextClassLoader;
    private final long _remoteReadTime;
    private volatile AsyncFutureListener<T> listener;
    private volatile AsyncResult<T> finalResult = null;
    private final AtomicBoolean triggeredEvent = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalCacheImplAsyncOperationsFuture(LocalCache cache, ReadTakeAsyncProxyActionInfo actionInfo) throws RemoteException {
        this._cache = cache;
        this._actionInfo = actionInfo;
        this.listener = actionInfo.listener;
        this._contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            this._lock.lock();
            this._remoteReadTime = SystemTime.timeMillis();
            AbstractProjectionTemplate projectionTemplate = null;
            if (this._actionInfo.isTake) {
                this._internalFuture = this._cache.getRemoteProxy().asyncTake((Object)this._actionInfo.queryPacket, this._actionInfo.txn, this._actionInfo.timeout, this._actionInfo.modifiers, null);
            } else {
                projectionTemplate = actionInfo.clearProjectionTemplate();
                this._internalFuture = this._cache.getRemoteProxy().asyncRead((Object)this._actionInfo.queryPacket, this._actionInfo.txn, this._actionInfo.timeout, this._actionInfo.modifiers, null);
            }
            this._internalFuture.setListener((AsyncFutureListener)new LocalCacheAsyncFutureListener(projectionTemplate));
        }
        finally {
            this._lock.unlock();
        }
    }

    public void setListener(final AsyncFutureListener<T> listener) {
        this.listener = listener;
        if (this.isDone() && listener != null) {
            LRMIRuntime.getRuntime().getThreadPool().execute((Runnable)new ContextClassLoaderRunnable(this._contextClassLoader){

                protected void execute() {
                    LocalCacheImplAsyncOperationsFuture.this.sendEvent(listener);
                }
            });
        }
    }

    private void sendEvent(AsyncFutureListener<T> localListener) {
        if (this.triggeredEvent.compareAndSet(false, true) && localListener != null) {
            localListener.onResult(this.finalResult);
        }
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        try {
            this._lock.lock();
            boolean bl = this._internalFuture.cancel(mayInterruptIfRunning);
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    protected T getResult() throws ExecutionException {
        if (this.finalResult.getException() != null) {
            throw new ExecutionException(this.finalResult.getException());
        }
        return (T)this.finalResult.getResult();
    }

    public boolean isCancelled() {
        try {
            this._lock.lock();
            boolean bl = this._internalFuture.isCancelled();
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    public boolean isDone() {
        try {
            this._lock.lock();
            boolean bl = this.finalResult != null;
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    public void setResult(Object result) {
        try {
            this._lock.lock();
            this.finalResult = result instanceof Exception ? new DefaultAsyncResult(null, (Exception)result) : new DefaultAsyncResult(result, null);
            this._resultCondition.signalAll();
            AsyncFutureListener<T> localListener = this.listener;
            if (localListener != null) {
                this.sendEvent(localListener);
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    private class LocalCacheAsyncFutureListener
    implements AsyncFutureListener<T> {
        private final AbstractProjectionTemplate _projectionTemplate;

        public LocalCacheAsyncFutureListener(AbstractProjectionTemplate projectionTemplate) {
            this._projectionTemplate = projectionTemplate;
        }

        public void onResult(AsyncResult<T> asyncResult) {
            Exception exception = asyncResult.getException();
            if (exception != null) {
                if (exception instanceof EntryVersionConflictException) {
                    LocalCacheImplAsyncOperationsFuture.this._cache.removeFromCache(((LocalCacheImplAsyncOperationsFuture)LocalCacheImplAsyncOperationsFuture.this)._actionInfo.queryPacket.getUID(), null, false);
                }
                LocalCacheImplAsyncOperationsFuture.this.setResult(exception);
            } else {
                try {
                    Object result = asyncResult.getResult();
                    if (result != null) {
                        IEntryPacket resultPacket = (IEntryPacket)result;
                        if (((LocalCacheImplAsyncOperationsFuture)LocalCacheImplAsyncOperationsFuture.this)._actionInfo.isTake || ((LocalCacheImplAsyncOperationsFuture)LocalCacheImplAsyncOperationsFuture.this)._actionInfo.txn != null) {
                            LocalCacheImplAsyncOperationsFuture.this._cache.removeFromCache(resultPacket.getUID(), ((LocalCacheImplAsyncOperationsFuture)LocalCacheImplAsyncOperationsFuture.this)._actionInfo.txn, true);
                        } else {
                            LocalCacheImplAsyncOperationsFuture.this._cache.addToCache(resultPacket, 4096, LocalCacheImplAsyncOperationsFuture.this._remoteReadTime);
                        }
                        result = LocalCacheImplAsyncOperationsFuture.this._actionInfo.convertQueryResult((ISpaceProxy)LocalCacheImplAsyncOperationsFuture.this._cache.getLocalProxy(), resultPacket, this._projectionTemplate);
                    }
                    LocalCacheImplAsyncOperationsFuture.this.setResult(result);
                }
                catch (RemoteException e) {
                    LocalCacheImplAsyncOperationsFuture.this.setResult(e);
                }
            }
        }
    }
}

