/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache.localcache.actions;

import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.client.ChangeException;
import com.gigaspaces.client.ChangeModifiers;
import com.gigaspaces.client.ChangeResult;
import com.gigaspaces.client.ChangeSetInternalUtils;
import com.gigaspaces.client.ChangedEntryDetails;
import com.gigaspaces.internal.client.cache.localcache.LocalCache;
import com.gigaspaces.internal.client.cache.localcache.LocalCacheContainer;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.ChangeProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actions.ChangeProxyAction;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.j_spaces.core.client.ClientUIDHandler;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.concurrent.Future;
import net.jini.core.transaction.TransactionException;

public class LocalCacheImplChangeAction
extends ChangeProxyAction<LocalCacheContainer> {
    public ChangeResult<?> change(LocalCacheContainer spaceProxy, ChangeProxyActionInfo actionInfo) throws RemoteException, TransactionException {
        ChangeResult changeResult;
        block8: {
            LocalCache cache = spaceProxy.assertCacheConnectedOrConnecting();
            if (cache == null) {
                return spaceProxy.getRemoteSpace().change((Object)actionInfo.queryPacket, ChangeSetInternalUtils.fromParameters((Collection)actionInfo.mutators, (long)actionInfo.lease), actionInfo.txn, actionInfo.timeout, ChangeSetInternalUtils.modifierFromCode((int)actionInfo.modifiers));
            }
            Collection changedEntriesResults = null;
            try {
                ChangeResult result = spaceProxy.getRemoteSpace().change((Object)actionInfo.queryPacket, ChangeSetInternalUtils.fromParameters((Collection)actionInfo.mutators, (long)actionInfo.lease), actionInfo.txn, actionInfo.timeout, ChangeSetInternalUtils.modifierFromCode((int)actionInfo.modifiers).add(ChangeModifiers.RETURN_DETAILED_RESULTS));
                changedEntriesResults = result.getResults();
                changeResult = result;
                if (changedEntriesResults == null) break block8;
            }
            catch (ChangeException e) {
                try {
                    changedEntriesResults = e.getSuccesfullChanges();
                    throw e;
                }
                catch (Throwable throwable) {
                    if (changedEntriesResults != null) {
                        for (ChangedEntryDetails result : changedEntriesResults) {
                            ITypeDesc typeDesc = spaceProxy.getDirectProxy().getTypeManager().getTypeDescByName(result.getTypeName());
                            String uid = typeDesc.isAutoGenerateId() ? (String)result.getId() : ClientUIDHandler.createUIDFromName((Object)result.getId(), (String)result.getTypeName());
                            cache.removeFromCache(uid, actionInfo.txn, actionInfo.txn != null);
                        }
                    }
                    throw throwable;
                }
            }
            for (ChangedEntryDetails result : changedEntriesResults) {
                ITypeDesc typeDesc = spaceProxy.getDirectProxy().getTypeManager().getTypeDescByName(result.getTypeName());
                String uid = typeDesc.isAutoGenerateId() ? (String)result.getId() : ClientUIDHandler.createUIDFromName((Object)result.getId(), (String)result.getTypeName());
                cache.removeFromCache(uid, actionInfo.txn, actionInfo.txn != null);
            }
        }
        return changeResult;
    }

    public <T> Future<ChangeResult<T>> asyncChange(LocalCacheContainer spaceProxy, final ChangeProxyActionInfo actionInfo, AsyncFutureListener listener) throws RemoteException {
        final LocalCache cache = spaceProxy.assertCacheConnectedOrConnecting();
        if (cache == null) {
            return spaceProxy.getRemoteSpace().asyncChange((Object)actionInfo.queryPacket, ChangeSetInternalUtils.fromParameters((Collection)actionInfo.mutators, (long)actionInfo.lease), actionInfo.txn, actionInfo.timeout, ChangeSetInternalUtils.modifierFromCode((int)actionInfo.modifiers), listener);
        }
        return spaceProxy.getRemoteSpace().asyncChange((Object)actionInfo.queryPacket, ChangeSetInternalUtils.fromParameters((Collection)actionInfo.mutators, (long)actionInfo.lease), actionInfo.txn, actionInfo.timeout, ChangeSetInternalUtils.modifierFromCode((int)actionInfo.modifiers).add(ChangeModifiers.RETURN_DETAILED_RESULTS), new AsyncFutureListener<ChangeResult<T>>(){

            public void onResult(AsyncResult<ChangeResult<T>> result) {
                Collection changedEntriesResults = ((ChangeResult)result.getResult()).getResults();
                if (result.getException() != null && result.getException() instanceof ChangeException) {
                    changedEntriesResults = ((ChangeException)result.getException()).getSuccesfullChanges();
                }
                if (changedEntriesResults != null) {
                    for (Object changedEntry : changedEntriesResults) {
                        ChangedEntryDetails typedChangedEntry = (ChangedEntryDetails)changedEntry;
                        String uid = ClientUIDHandler.createUIDFromName((Object)typedChangedEntry.getId(), (String)typedChangedEntry.getTypeName());
                        cache.removeFromCache(uid, actionInfo.txn, actionInfo.txn != null);
                    }
                }
            }
        });
    }
}

