/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache.localcache.actions;

import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.async.internal.DefaultAsyncResult;
import com.gigaspaces.internal.client.cache.localcache.LocalCache;
import com.gigaspaces.internal.client.cache.localcache.LocalCacheContainer;
import com.gigaspaces.internal.client.cache.localcache.actions.LocalCacheImplAsyncOperationsFuture;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.ReadTakeAsyncProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.ReadTakeProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actions.ReadTakeProxyAction;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.utils.concurrent.ContextClassLoaderRunnable;
import com.gigaspaces.lrmi.LRMIRuntime;
import com.gigaspaces.time.SystemTime;
import java.rmi.RemoteException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.TransactionException;

public class LocalCacheImplReadTakeAction
extends ReadTakeProxyAction<LocalCacheContainer> {
    public Object read(LocalCacheContainer spaceProxy, ReadTakeProxyActionInfo actionInfo) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        spaceProxy.verifyProjectionsAreSupported(actionInfo.queryPacket.getProjectionTemplate());
        AbstractProjectionTemplate projectionTemplate = actionInfo.clearProjectionTemplate();
        IEntryPacket result = this.readInternal(spaceProxy, actionInfo);
        return actionInfo.convertQueryResult((ISpaceProxy)spaceProxy, result, projectionTemplate);
    }

    private IEntryPacket readInternal(LocalCacheContainer spaceProxy, ReadTakeProxyActionInfo actionInfo) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        LocalCache cache = spaceProxy.assertCacheConnectedOrConnecting();
        if (cache == null) {
            return (IEntryPacket)spaceProxy.getRemoteSpace().read((Object)actionInfo.queryPacket, actionInfo.txn, actionInfo.timeout, actionInfo.modifiers, actionInfo.ifExists);
        }
        if (actionInfo.txn == null) {
            try {
                IEntryPacket result = (IEntryPacket)cache.getLocalProxy().read((Object)actionInfo.queryPacket, null, 0L, actionInfo.modifiers, actionInfo.ifExists);
                if (result != null) {
                    return result;
                }
            }
            catch (Exception result) {
                // empty catch block
            }
        }
        long remoteReadTime = SystemTime.timeMillis();
        IEntryPacket result = (IEntryPacket)cache.getRemoteProxy().read((Object)actionInfo.queryPacket, actionInfo.txn, actionInfo.timeout, actionInfo.modifiers, actionInfo.ifExists);
        if (result != null) {
            if (actionInfo.txn == null || actionInfo.modifiers == 8192) {
                cache.addToCache(result, 4096, remoteReadTime);
            } else {
                cache.removeFromCache(result.getUID(), actionInfo.txn, actionInfo.txn != null);
            }
        }
        return result;
    }

    public Object take(LocalCacheContainer spaceProxy, ReadTakeProxyActionInfo actionInfo) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        spaceProxy.verifyProjectionsAreSupported(actionInfo.queryPacket.getProjectionTemplate());
        return actionInfo.convertQueryResult((ISpaceProxy)spaceProxy, this.takeInternal(spaceProxy, actionInfo), null);
    }

    private IEntryPacket takeInternal(LocalCacheContainer spaceProxy, ReadTakeProxyActionInfo actionInfo) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        LocalCache cache = spaceProxy.assertCacheConnectedOrConnecting();
        if (cache == null) {
            return (IEntryPacket)spaceProxy.getRemoteSpace().take((Object)actionInfo.queryPacket, actionInfo.txn, actionInfo.timeout, actionInfo.modifiers, actionInfo.ifExists);
        }
        IEntryPacket result = (IEntryPacket)cache.getRemoteProxy().take((Object)actionInfo.queryPacket, actionInfo.txn, actionInfo.timeout, actionInfo.modifiers, actionInfo.ifExists);
        if (result != null) {
            cache.removeFromCache(result.getUID(), null, true);
        }
        return result;
    }

    public AsyncFuture<?> asyncRead(LocalCacheContainer spaceProxy, ReadTakeAsyncProxyActionInfo actionInfo) throws RemoteException, UnusableEntryException {
        spaceProxy.verifyProjectionsAreSupported(actionInfo.queryPacket.getProjectionTemplate());
        LocalCache cache = spaceProxy.assertCacheConnectedOrConnecting();
        if (cache == null) {
            return spaceProxy.getRemoteSpace().asyncRead((Object)actionInfo.queryPacket, actionInfo.txn, actionInfo.timeout, actionInfo.modifiers, actionInfo.listener);
        }
        if (actionInfo.txn == null) {
            try {
                Object localCacheResult = cache.getLocalProxy().read((Object)actionInfo.queryPacket, null, 0L);
                if (localCacheResult != null) {
                    return new FinalizedResultAsyncFutureAdapter<Object>(localCacheResult, actionInfo.listener);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new LocalCacheImplAsyncOperationsFuture(cache, actionInfo);
    }

    public AsyncFuture<?> asyncTake(LocalCacheContainer spaceProxy, ReadTakeAsyncProxyActionInfo actionInfo) throws RemoteException, UnusableEntryException {
        spaceProxy.verifyProjectionsAreSupported(actionInfo.queryPacket.getProjectionTemplate());
        LocalCache cache = spaceProxy.assertCacheConnectedOrConnecting();
        if (cache == null) {
            return spaceProxy.getRemoteSpace().asyncTake((Object)actionInfo.queryPacket, actionInfo.txn, actionInfo.timeout, actionInfo.modifiers, actionInfo.listener);
        }
        return new LocalCacheImplAsyncOperationsFuture(cache, actionInfo);
    }

    private static class FinalizedResultAsyncFutureAdapter<T>
    implements AsyncFuture<T> {
        private T result;
        private AsyncFutureListener<T> listener;
        private AtomicBoolean triggeredEvent = new AtomicBoolean(false);

        public FinalizedResultAsyncFutureAdapter(T result, AsyncFutureListener<T> listener) {
            this.result = result;
            if (listener != null) {
                this.setListener(listener);
            }
        }

        public void setListener(AsyncFutureListener<T> listener) {
            this.listener = listener;
            LRMIRuntime.getRuntime().getThreadPool().execute((Runnable)new ContextClassLoaderRunnable(){

                protected void execute() {
                    this.sendEvent();
                }
            });
        }

        protected void sendEvent() {
            if (this.triggeredEvent.compareAndSet(false, true) && this.listener != null) {
                this.listener.onResult((AsyncResult)new DefaultAsyncResult(this.result, null));
            }
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        public T get() throws InterruptedException, ExecutionException {
            return this.result;
        }

        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
            return this.result;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isDone() {
            return true;
        }
    }
}

