/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache.localcache.actions;

import com.gigaspaces.client.ReadTakeByIdResult;
import com.gigaspaces.client.ReadTakeByIdsException;
import com.gigaspaces.client.TakeByIdsException;
import com.gigaspaces.internal.client.cache.localcache.LocalCache;
import com.gigaspaces.internal.client.cache.localcache.LocalCacheContainer;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.ReadTakeByIdsProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actions.ReadTakeByIdsProxyAction;
import com.gigaspaces.internal.client.spaceproxy.metadata.ISpaceProxyTypeManager;
import com.gigaspaces.internal.server.storage.EntryDataType;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.time.SystemTime;
import java.lang.reflect.Array;
import java.rmi.RemoteException;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.TransactionException;

public class LocalCacheImplReadTakeByIdsAction
extends ReadTakeByIdsProxyAction<LocalCacheContainer> {
    public Object[] readByIds(LocalCacheContainer spaceProxy, ReadTakeByIdsProxyActionInfo actionInfo, boolean returnPackets) throws RemoteException, TransactionException, UnusableEntryException, InterruptedException {
        spaceProxy.verifyProjectionsAreSupported(actionInfo.queryPacket.getProjectionTemplate());
        LocalCache cache = spaceProxy.assertCacheConnectedOrConnecting();
        if (cache == null) {
            return spaceProxy.getRemoteSpace().readByIds(actionInfo, returnPackets);
        }
        Object[] localResults = null;
        if (actionInfo.txn == null) {
            localResults = this.readFromLocalCache(cache, actionInfo);
        }
        long remoteReadTime = SystemTime.timeMillis();
        AbstractProjectionTemplate projectionTemplate = actionInfo.clearProjectionTemplate();
        try {
            IEntryPacket[] remoteResults = this.readFromRemoteSpace(cache.getRemoteProxy(), actionInfo, localResults);
            return this.convertAndMergeResults(cache, actionInfo, localResults, remoteResults, remoteReadTime, returnPackets, projectionTemplate);
        }
        catch (ReadTakeByIdsException e) {
            throw this.convertAndMergeResults(cache, actionInfo, e, localResults, remoteReadTime, returnPackets, projectionTemplate);
        }
    }

    private Object[] readFromLocalCache(LocalCache cache, ReadTakeByIdsProxyActionInfo actionInfo) {
        try {
            if (cache.getCacheEntryDataType() == EntryDataType.USER_TYPE) {
                Class resultClass = cache.getRemoteProxy().getTypeManager().getResultClass((ITemplatePacket)actionInfo.queryPacket);
                Object[] results = (Object[])Array.newInstance(resultClass, actionInfo.ids.length);
                for (int i = 0; i < actionInfo.ids.length; ++i) {
                    results[i] = cache.getLocalSpaceImpl().getEngine().directLocalReadById(actionInfo.ids[i], actionInfo.className, actionInfo.queryPacket.getQueryResultType());
                }
                return results;
            }
            return cache.getLocalSpaceImpl().readByIds((ITemplatePacket)actionInfo.queryPacket, actionInfo.txn, false, null, actionInfo.modifiers);
        }
        catch (Exception e) {
            return null;
        }
    }

    private IEntryPacket[] readFromRemoteSpace(IDirectSpaceProxy remoteProxy, ReadTakeByIdsProxyActionInfo actionInfo, Object[] localResults) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        int numOfLocalResults = 0;
        if (localResults != null) {
            for (Object result : localResults) {
                if (result == null) continue;
                ++numOfLocalResults;
            }
        }
        if (numOfLocalResults == actionInfo.ids.length) {
            return null;
        }
        Object[] remoteIds = actionInfo.ids;
        Object[] remoteRoutings = actionInfo.routings;
        if (numOfLocalResults != 0) {
            int numOfMissingResults = actionInfo.ids.length - numOfLocalResults;
            remoteIds = new Object[numOfMissingResults];
            remoteRoutings = actionInfo.routings != null && actionInfo.routings != actionInfo.ids ? new Object[numOfMissingResults] : null;
            int index = 0;
            for (int i = 0; i < localResults.length; ++i) {
                if (localResults[i] != null) continue;
                remoteIds[index] = actionInfo.ids[i];
                if (remoteRoutings != null) {
                    remoteRoutings[index] = actionInfo.routings[i];
                }
                ++index;
            }
        }
        if (actionInfo.routings != null) {
            return (IEntryPacket[])remoteProxy.readByIds(actionInfo.className, remoteIds, remoteRoutings, actionInfo.txn, actionInfo.modifiers, actionInfo.queryPacket.getQueryResultType(), true, null);
        }
        return (IEntryPacket[])remoteProxy.readByIds(actionInfo.className, remoteIds, actionInfo.routing, actionInfo.txn, actionInfo.modifiers, actionInfo.queryPacket.getQueryResultType(), true, null);
    }

    private Object[] convertAndMergeResults(LocalCache cache, ReadTakeByIdsProxyActionInfo actionInfo, Object[] localResults, IEntryPacket[] remoteResultsPackets, long remoteReadTime, boolean returnPackets, AbstractProjectionTemplate projectionTemplate) throws RemoteException {
        int i;
        if (remoteResultsPackets == null) {
            return localResults;
        }
        if (actionInfo.txn == null) {
            for (i = 0; i < remoteResultsPackets.length; ++i) {
                if (remoteResultsPackets[i] == null) continue;
                cache.addToCache(remoteResultsPackets[i], 4096, remoteReadTime);
            }
        } else {
            for (i = 0; i < remoteResultsPackets.length; ++i) {
                if (remoteResultsPackets[i] == null) continue;
                cache.removeFromCache(remoteResultsPackets[i].getUID(), actionInfo.txn, true);
            }
        }
        Object[] remoteResults = actionInfo.convertResults((ISpaceProxy)cache.getRemoteProxy(), remoteResultsPackets, returnPackets, projectionTemplate);
        if (localResults == null) {
            return remoteResults;
        }
        int index = 0;
        for (int i2 = 0; i2 < localResults.length; ++i2) {
            if (localResults[i2] != null) continue;
            localResults[i2] = remoteResults[index++];
        }
        return localResults;
    }

    private ReadTakeByIdsException convertAndMergeResults(LocalCache cache, ReadTakeByIdsProxyActionInfo actionInfo, ReadTakeByIdsException e, Object[] localResults, long remoteReadTime, boolean returnPackets, AbstractProjectionTemplate projectionTemplate) {
        ReadTakeByIdResult[] remoteResults = e.getResults();
        if (actionInfo.txn == null) {
            for (ReadTakeByIdResult remoteResult : remoteResults) {
                if (remoteResult.isError() || remoteResult.getObject() == null) continue;
                try {
                    cache.addToCache((IEntryPacket)remoteResult.getObject(), 4096, remoteReadTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            for (ReadTakeByIdResult remoteResult : remoteResults) {
                if (remoteResult.isError() || remoteResult.getObject() == null) continue;
                cache.removeFromCache(((IEntryPacket)remoteResult.getObject()).getUID(), actionInfo.txn, true);
            }
        }
        if (remoteResults.length == actionInfo.ids.length) {
            return actionInfo.convertResults((ISpaceProxy)cache.getRemoteProxy(), e, returnPackets, projectionTemplate);
        }
        ReadTakeByIdResult[] results = new ReadTakeByIdResult[localResults.length];
        int remoteResultIndex = 0;
        ISpaceProxyTypeManager typeManager = cache.getRemoteProxy().getTypeManager();
        for (int i = 0; i < localResults.length; ++i) {
            if (localResults[i] != null) {
                results[i] = new ReadTakeByIdResult(actionInfo.ids[i], localResults[i], null);
                continue;
            }
            ReadTakeByIdResult remoteResult = remoteResults[remoteResultIndex++];
            Object entry = typeManager.convertQueryResult((IEntryPacket)remoteResult.getObject(), (ITemplatePacket)actionInfo.queryPacket, returnPackets, projectionTemplate);
            results[i] = new ReadTakeByIdResult(remoteResult.getId(), entry, remoteResult.getError());
        }
        return ReadTakeByIdsException.newException((ReadTakeByIdResult[])results, (boolean)actionInfo.isTake);
    }

    public Object[] takeByIds(LocalCacheContainer spaceProxy, ReadTakeByIdsProxyActionInfo actionInfo, boolean returnPackets) throws RemoteException, TransactionException, UnusableEntryException, InterruptedException {
        spaceProxy.verifyProjectionsAreSupported(actionInfo.queryPacket.getProjectionTemplate());
        LocalCache cache = spaceProxy.assertCacheConnectedOrConnecting();
        if (cache == null) {
            return spaceProxy.getRemoteSpace().takeByIds(actionInfo, returnPackets);
        }
        try {
            IEntryPacket[] results;
            try {
                results = (IEntryPacket[])cache.getRemoteProxy().takeByIds(actionInfo, true);
            }
            catch (TakeByIdsException e) {
                ReadTakeByIdResult[] partialResults = e.getResults();
                for (int i = 0; i < partialResults.length; ++i) {
                    if (partialResults[i].isError() || partialResults[i].getObject() == null) continue;
                    cache.removeFromCache(((IEntryPacket)partialResults[i].getObject()).getUID(), actionInfo.txn, true);
                }
                throw e;
            }
            for (IEntryPacket result : results) {
                if (result == null) continue;
                cache.removeFromCache(result.getUID(), actionInfo.txn, true);
            }
            return actionInfo.convertResults((ISpaceProxy)spaceProxy, results, returnPackets, null);
        }
        catch (ReadTakeByIdsException e) {
            throw actionInfo.convertResults((ISpaceProxy)spaceProxy, e, returnPackets, null);
        }
    }
}

