/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache.localcache.actions;

import com.gigaspaces.internal.client.cache.localcache.LocalCache;
import com.gigaspaces.internal.client.cache.localcache.LocalCacheContainer;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.ReadTakeMultipleProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actions.ReadTakeMultipleProxyAction;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.multiple.query.QueryMultiplePartialFailureException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.TransactionException;

public class LocalCacheImplReadTakeMultipleAction
extends ReadTakeMultipleProxyAction<LocalCacheContainer> {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.localcache");
    private static final IEntryPacket[] _emptryResults = new IEntryPacket[0];

    public Object[] readMultiple(LocalCacheContainer spaceProxy, ReadTakeMultipleProxyActionInfo actionInfo) throws RemoteException, TransactionException, UnusableEntryException {
        spaceProxy.verifyProjectionsAreSupported(actionInfo.queryPacket.getProjectionTemplate());
        AbstractProjectionTemplate projectionTemplate = actionInfo.clearProjectionTemplate();
        try {
            IEntryPacket[] results = this.readMultipleImpl(spaceProxy, actionInfo);
            return actionInfo.convertQueryResults((ISpaceProxy)spaceProxy, results, projectionTemplate);
        }
        catch (QueryMultiplePartialFailureException e) {
            throw actionInfo.convertExceptionResults((ISpaceProxy)spaceProxy, e, projectionTemplate);
        }
    }

    private IEntryPacket[] readMultipleImpl(LocalCacheContainer spaceProxy, ReadTakeMultipleProxyActionInfo actionInfo) throws TransactionException, UnusableEntryException, RemoteException {
        int localResultsLength;
        int remainder;
        LocalCache cache = spaceProxy.assertCacheConnectedOrConnecting();
        if (cache == null) {
            return (IEntryPacket[])spaceProxy.getRemoteSpace().readMultiple((Object)actionInfo.queryPacket, actionInfo.txn, actionInfo.maxResults, actionInfo.modifiers, actionInfo.returnOnlyUids);
        }
        boolean isUidsQuery = actionInfo.queryPacket.getMultipleUIDs() != null;
        Object[] localResults = _emptryResults;
        if (actionInfo.txn == null && actionInfo.maxResults != Integer.MAX_VALUE) {
            try {
                localResults = (IEntryPacket[])cache.getLocalProxy().readMultiple((Object)actionInfo.queryPacket, null, actionInfo.maxResults);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((remainder = LocalCacheImplReadTakeMultipleAction.getRemainder(localResultsLength = LocalCacheImplReadTakeMultipleAction.getResultLength(localResults, actionInfo.returnOnlyUids), isUidsQuery, actionInfo.maxResults)) == 0) {
            return localResults;
        }
        boolean queryWasModified = LocalCacheImplReadTakeMultipleAction.removeLocalResultsFromQuery(actionInfo.queryPacket, localResults, localResultsLength, isUidsQuery, actionInfo.returnOnlyUids);
        long remoteReadTime = SystemTime.timeMillis();
        try {
            IEntryPacket[] remoteResults = (IEntryPacket[])cache.getRemoteProxy().readMultiple((Object)actionInfo.queryPacket, actionInfo.txn, remainder, actionInfo.modifiers, actionInfo.returnOnlyUids);
            return this.processResults(cache, actionInfo, queryWasModified, (IEntryPacket[])localResults, remoteResults, remoteReadTime);
        }
        catch (QueryMultiplePartialFailureException e) {
            IEntryPacket[] remoteResults = (IEntryPacket[])e.getResults();
            e.setResults((Object[])this.processResults(cache, actionInfo, queryWasModified, (IEntryPacket[])localResults, remoteResults, remoteReadTime));
            throw e;
        }
    }

    private static int getResultLength(Object[] results, boolean returnOnlyUids) {
        if (results.length == 0) {
            return 0;
        }
        if (returnOnlyUids) {
            return ((IEntryPacket)results[0]).getMultipleUIDs().length;
        }
        return results.length;
    }

    private static int getRemainder(int localResultsLength, boolean isUidsQuery, int maxEntries) {
        if (!isUidsQuery) {
            return localResultsLength >= maxEntries ? 0 : maxEntries;
        }
        return maxEntries - localResultsLength;
    }

    private static boolean removeLocalResultsFromQuery(ITemplatePacket queryPacket, Object[] localResults, int localResultsLength, boolean isUidsQuery, boolean returnOnlyUids) {
        if (!isUidsQuery) {
            return false;
        }
        if (localResultsLength == 0) {
            return false;
        }
        String[] originalUids = queryPacket.getMultipleUIDs();
        String[] remainingUids = new String[originalUids.length - localResultsLength];
        int updatedIndex = 0;
        for (String uid : originalUids) {
            boolean found = false;
            for (int i = 0; i < localResultsLength; ++i) {
                if (!uid.equals(LocalCacheImplReadTakeMultipleAction.getResultUid(localResults, i, returnOnlyUids))) continue;
                found = true;
                break;
            }
            if (found) continue;
            remainingUids[updatedIndex++] = uid;
        }
        queryPacket.setMultipleUIDs(remainingUids);
        return true;
    }

    private static String getResultUid(Object[] results, int index, boolean returnOnlyUids) {
        if (returnOnlyUids) {
            return ((IEntryPacket)results[0]).getMultipleUIDs()[index];
        }
        return ((IEntryPacket)results[index]).getUID();
    }

    private IEntryPacket[] processResults(LocalCache cache, ReadTakeMultipleProxyActionInfo actionInfo, boolean queryWasModified, IEntryPacket[] localResults, IEntryPacket[] remoteResults, long remoteReadTime) throws RemoteException {
        if (!actionInfo.returnOnlyUids) {
            if (actionInfo.txn == null) {
                for (IEntryPacket result : remoteResults) {
                    cache.addToCache(result, 4096, remoteReadTime);
                }
            } else {
                for (IEntryPacket result : remoteResults) {
                    cache.removeFromCache(result.getUID(), actionInfo.txn, true);
                }
            }
        }
        if (!queryWasModified) {
            return remoteResults;
        }
        if (actionInfo.returnOnlyUids) {
            IEntryPacket localPacket = localResults[0];
            String[] localUids = localPacket.getMultipleUIDs();
            String[] remoteUids = remoteResults[0].getMultipleUIDs();
            localPacket.setMultipleUIDs(LocalCacheImplReadTakeMultipleAction.merge(localUids, remoteUids, new String[localUids.length + remoteUids.length]));
            return localResults;
        }
        return LocalCacheImplReadTakeMultipleAction.merge(localResults, remoteResults, new IEntryPacket[localResults.length + remoteResults.length]);
    }

    private static <T> T[] merge(T[] a, T[] b, T[] target) {
        System.arraycopy(a, 0, target, 0, a.length);
        System.arraycopy(b, 0, target, a.length, b.length);
        return target;
    }

    public Object[] takeMultiple(LocalCacheContainer spaceProxy, ReadTakeMultipleProxyActionInfo actionInfo) throws RemoteException, TransactionException, UnusableEntryException {
        spaceProxy.verifyProjectionsAreSupported(actionInfo.queryPacket.getProjectionTemplate());
        try {
            IEntryPacket[] results = this.takeMultipleImpl(spaceProxy, actionInfo);
            return actionInfo.convertQueryResults((ISpaceProxy)spaceProxy, results, null);
        }
        catch (QueryMultiplePartialFailureException e) {
            throw actionInfo.convertExceptionResults((ISpaceProxy)spaceProxy, e, null);
        }
    }

    private IEntryPacket[] takeMultipleImpl(LocalCacheContainer spaceProxy, ReadTakeMultipleProxyActionInfo actionInfo) throws TransactionException, UnusableEntryException, RemoteException {
        IEntryPacket[] entries;
        LocalCache cache = spaceProxy.assertCacheConnectedOrConnecting();
        if (cache == null) {
            return (IEntryPacket[])spaceProxy.getRemoteSpace().takeMultiple((Object)actionInfo.queryPacket, actionInfo.txn, actionInfo.maxResults, actionInfo.modifiers);
        }
        try {
            entries = (IEntryPacket[])cache.getRemoteProxy().takeMultiple((Object)actionInfo.queryPacket, actionInfo.txn, actionInfo.maxResults, actionInfo.modifiers);
        }
        catch (QueryMultiplePartialFailureException e) {
            try {
                if (e.getResults() != null) {
                    for (Object entry : e.getResults()) {
                        cache.removeFromCache(((IEntryPacket)entry).getUID(), actionInfo.txn, true);
                    }
                }
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Failed to notify local cache take event", ex);
            }
            throw e;
        }
        for (IEntryPacket entry : entries) {
            cache.removeFromCache(entry.getUID(), actionInfo.txn, true);
        }
        return entries;
    }
}

