/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache.localcache.actions;

import com.gigaspaces.client.WriteMultipleException;
import com.gigaspaces.internal.client.cache.localcache.LocalCache;
import com.gigaspaces.internal.client.cache.localcache.LocalCacheContainer;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.WriteMultipleProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.WriteProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actions.WriteProxyAction;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.LeaseContext;
import com.j_spaces.core.client.Modifiers;
import com.j_spaces.core.client.UpdateModifiers;
import java.rmi.RemoteException;
import net.jini.core.transaction.TransactionException;

public class LocalCacheImplWriteAction
extends WriteProxyAction<LocalCacheContainer> {
    public LeaseContext<?> write(LocalCacheContainer spaceProxy, WriteProxyActionInfo actionInfo) throws RemoteException, TransactionException, InterruptedException {
        LocalCache cache = spaceProxy.assertCacheConnectedOrConnecting();
        if (cache == null) {
            return spaceProxy.getRemoteSpace().write(actionInfo.entry, actionInfo.txn, actionInfo.lease, actionInfo.timeout, actionInfo.modifiers);
        }
        long updateTime = SystemTime.timeMillis();
        LeaseContext lease = cache.getRemoteProxy().write((Object)actionInfo.entryPacket, actionInfo.txn, actionInfo.lease, actionInfo.timeout, actionInfo.modifiers);
        if (UpdateModifiers.isUpdate((int)actionInfo.modifiers)) {
            if (Modifiers.contains((int)actionInfo.modifiers, (int)2) || Modifiers.contains((int)actionInfo.modifiers, (int)1)) {
                cache.removeFromCache(actionInfo.entryPacket.getUID(), actionInfo.txn, actionInfo.txn != null);
            } else if (lease.getObject() != null || lease.getVersion() > 1) {
                cache.updateCache(actionInfo.entryPacket, actionInfo.txn, actionInfo.lease, actionInfo.modifiers, updateTime);
            }
        }
        return actionInfo.convertWriteResult(cache.getLocalProxy(), lease);
    }

    public LeaseContext<?>[] writeMultiple(LocalCacheContainer spaceProxy, WriteMultipleProxyActionInfo actionInfo) throws RemoteException, TransactionException, InterruptedException {
        LeaseContext[] leases;
        LocalCache cache = spaceProxy.assertCacheConnectedOrConnecting();
        if (cache == null) {
            return spaceProxy.getRemoteSpace().writeMultiple(actionInfo.entries, actionInfo.txn, actionInfo.lease, actionInfo.leases, actionInfo.timeout, actionInfo.modifiers);
        }
        long remoteWriteTime = SystemTime.timeMillis();
        try {
            leases = cache.getRemoteProxy().writeMultiple((Object[])actionInfo.entryPackets, actionInfo.txn, actionInfo.lease, actionInfo.leases, actionInfo.timeout, actionInfo.modifiers);
        }
        catch (WriteMultipleException e) {
            if (UpdateModifiers.isNoReturnValue((int)actionInfo.modifiers)) {
                this.removeEntries(cache, actionInfo);
            } else {
                WriteMultipleException.IWriteResult[] values = e.getResults();
                for (int i = 0; i < actionInfo.entryPackets.length; ++i) {
                    if (values[i].isError() || values[i].getLeaseContext().getVersion() <= 1) continue;
                    this.updateEntry(cache, actionInfo, i, remoteWriteTime);
                }
            }
            throw e;
        }
        if (UpdateModifiers.isUpdate((int)actionInfo.modifiers)) {
            if (UpdateModifiers.isNoReturnValue((int)actionInfo.modifiers) || Modifiers.contains((int)actionInfo.modifiers, (int)1)) {
                this.removeEntries(cache, actionInfo);
            } else {
                for (int i = 0; i < actionInfo.entryPackets.length; ++i) {
                    if (leases[i].getObject() == null) continue;
                    this.updateEntry(cache, actionInfo, i, remoteWriteTime);
                }
            }
        }
        return actionInfo.convertWriteResults(cache.getLocalProxy(), leases);
    }

    private void updateEntry(LocalCache cache, WriteMultipleProxyActionInfo actionInfo, int pos, long remoteWriteTime) {
        long lease = actionInfo.leases != null ? actionInfo.leases[pos] : actionInfo.lease;
        cache.updateCache(actionInfo.entryPackets[pos], actionInfo.txn, lease, actionInfo.modifiers, remoteWriteTime);
    }

    private void removeEntries(LocalCache cache, WriteMultipleProxyActionInfo actionInfo) {
        for (int i = 0; i < actionInfo.entryPackets.length; ++i) {
            String uid = actionInfo.entryPackets[i].getUID();
            cache.removeFromCache(uid, actionInfo.txn, actionInfo.txn != null);
        }
    }
}

