/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache.localview;

import com.gigaspaces.internal.client.cache.SpaceCacheConfig;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.j_spaces.core.client.SpaceURL;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class LocalViewConfig
extends SpaceCacheConfig {
    private List<Object> _viewQueries;
    private ITemplatePacket[] _viewTemplatePackets;
    private Long _synchronizationTimeout;

    public LocalViewConfig() {
    }

    public LocalViewConfig(SpaceURL remoteSpaceUrl, Properties customProperties, List<Object> viewTemplates) {
        super(remoteSpaceUrl, customProperties);
        this._viewQueries = viewTemplates;
    }

    @Override
    protected Logger initLogger() {
        return Logger.getLogger("com.gigaspaces.localview");
    }

    @Override
    public void initLocalSpaceConfig(SpaceConfigReader configReader) {
        super.initLocalSpaceConfig(configReader);
        configReader.setSpaceProperty("engine.cache_policy", Integer.toString(1));
        configReader.setSpaceProperty("lease_manager.disable_entries_leases", Boolean.TRUE.toString());
    }

    public List<Object> getViewQueries() {
        return this._viewQueries;
    }

    public void setViewQueries(List<Object> viewQueries) {
        this._viewQueries = viewQueries;
    }

    public ITemplatePacket[] getViewTemplatePackets() {
        return this._viewTemplatePackets;
    }

    public void setViewTemplatePackets(ITemplatePacket[] viewTemplatePackets) {
        this._viewTemplatePackets = viewTemplatePackets;
    }

    @Override
    public boolean supportsNotifications() {
        return true;
    }

    public long getInitialSynchronizationTimeout() {
        return this._synchronizationTimeout;
    }

    public void setInitialSynchronizationTimeout(Long synchronizationTimeout) {
        this._synchronizationTimeout = synchronizationTimeout;
    }

    @Override
    public boolean isActiveWhileDisconnected() {
        return false;
    }

    @Override
    protected void applyDefaultValues() {
        super.applyDefaultValues();
        if (this._synchronizationTimeout == null) {
            this._synchronizationTimeout = 300000L;
        }
    }
}

