/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache.localview;

import com.gigaspaces.client.localview.LocalViewConnectionState;
import com.gigaspaces.client.localview.LocalViewConnectionStateListener;
import com.gigaspaces.client.localview.LocalViewMonitor;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.internal.client.cache.AbstractSpaceCache;
import com.gigaspaces.internal.client.cache.AbstractSpaceCacheContainer;
import com.gigaspaces.internal.client.cache.SpaceCacheInitializationException;
import com.gigaspaces.internal.client.cache.SpaceCacheState;
import com.gigaspaces.internal.client.cache.localview.LocalViewConfig;
import com.gigaspaces.internal.client.cache.localview.actions.LocalViewImplActionManager;
import com.gigaspaces.internal.client.cache.localview.notification.NotificationLocalView;
import com.gigaspaces.internal.client.cache.localview.replication.ReplicationLocalView;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.actions.AbstractSpaceProxyActionManager;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.utils.collections.ConcurrentHashSet;
import com.j_spaces.core.client.EntrySnapshot;
import com.j_spaces.core.client.ReadModifiers;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class LocalViewContainer
extends AbstractSpaceCacheContainer
implements LocalViewMonitor {
    private static final boolean _disableReplicationLocalView = Boolean.getBoolean("com.gigaspaces.localView.disableReplicationLocalView");
    private static final boolean _disableTemplatesOverlapValidation = Boolean.getBoolean("com.gigaspaces.localView.disableValidation");
    private final LocalViewConfig _cacheConfig;
    private volatile boolean _isReplicationLocalView;
    private Object _stateLock;
    private volatile LocalViewConnectionState _localViewConnectionState;
    private Set<LocalViewConnectionStateListener> _listeners;

    public LocalViewContainer(IDirectSpaceProxy remoteProxy, LocalViewConfig cacheConfig) {
        super(remoteProxy, cacheConfig);
        this._cacheConfig = cacheConfig;
        this._stateLock = new Object();
        this._localViewConnectionState = LocalViewConnectionState.INACTIVE;
        this._listeners = new ConcurrentHashSet();
        int readModifiers = ReadModifiers.setIsolationLevelModifier((int)this.getReadModifiers(), (int)8192);
        this.setReadModifiers(readModifiers);
    }

    public IDirectSpaceProxy getNotificationsDirectProxy() {
        return this.getLocalSpace();
    }

    @Override
    public LocalViewConfig getCacheConfig() {
        return this._cacheConfig;
    }

    @Override
    protected AbstractSpaceCache createSpaceCache() throws SpaceCacheInitializationException {
        ITemplatePacket[] viewTemplatePackets = this.convertToTemplatePackets(this._cacheConfig.getViewQueries());
        this._cacheConfig.setViewTemplatePackets(viewTemplatePackets);
        this._isReplicationLocalView = LocalViewContainer.useReplicationLocalView(this.getRemoteSpace(), viewTemplatePackets);
        return this._isReplicationLocalView ? new ReplicationLocalView(this) : new NotificationLocalView(this);
    }

    public boolean isReplicationLocalView() {
        return this._isReplicationLocalView;
    }

    protected AbstractSpaceProxyActionManager<LocalViewContainer> createActionManager() {
        return new LocalViewImplActionManager(this);
    }

    public void applyNotifyInfoDefaults(NotifyInfo notifyInfo) {
        super.applyNotifyInfoDefaults(notifyInfo);
        if (this._isReplicationLocalView) {
            if (notifyInfo.getNotifyTemplate() == Boolean.FALSE) {
                throw new IllegalArgumentException("Cannot use TriggerNotifyTemplate==false with Local View.");
            }
            notifyInfo.setNotifyTemplate(Boolean.valueOf(true));
        }
    }

    @Override
    protected Logger initLogger() {
        return Logger.getLogger("com.gigaspaces.localview");
    }

    public String getCacheTypeName() {
        return "LocalView";
    }

    @Override
    public LocalViewConnectionState getConnectionState() {
        return this._localViewConnectionState;
    }

    @Override
    public void addConnectionStateListener(LocalViewConnectionStateListener localViewConnectionStateListener) {
        this._listeners.add(localViewConnectionStateListener);
    }

    @Override
    public void removeConnectionStateListener(LocalViewConnectionStateListener localViewConnectionStateListener) {
        this._listeners.remove(localViewConnectionStateListener);
    }

    private ITemplatePacket[] convertToTemplatePackets(List<Object> templates) throws SpaceCacheInitializationException {
        ITemplatePacket[] templatePackets = new ITemplatePacket[templates.size()];
        for (int i = 0; i < templatePackets.length; ++i) {
            try {
                templatePackets[i] = ((EntrySnapshot)this.getRemoteSpace().snapshot(templates.get(i))).getTemplatePacket();
            }
            catch (RemoteException e) {
                throw new SpaceCacheInitializationException("Failed to initialize local view template #" + i, e);
            }
            ITemplatePacket currPacket = templatePackets[i];
            if (_disableTemplatesOverlapValidation) continue;
            for (int j = 0; j < i; ++j) {
                ITemplatePacket prevPacket = templatePackets[j];
                if (prevPacket.getTypeName().equals(currPacket.getTypeName())) {
                    throw new IllegalArgumentException("Local View does not support two templates of the same class [" + currPacket.getTypeName() + "].");
                }
                String commonSuperTypeName = this.getRemoteSpace().getTypeManager().getCommonSuperTypeName(prevPacket.getTypeDescriptor(), currPacket.getTypeDescriptor());
                if (commonSuperTypeName == null) continue;
                if (commonSuperTypeName.equals(prevPacket.getTypeName())) {
                    throw new IllegalArgumentException("Local View does not support overlapping template classes. Type [" + prevPacket.getTypeName() + "] is a super class of [" + currPacket.getTypeName() + "].");
                }
                if (!commonSuperTypeName.equals(currPacket.getTypeName())) continue;
                throw new IllegalArgumentException("Local View does not support overlapping template classes. Type [" + currPacket.getTypeName() + "] is a super class of [" + prevPacket.getTypeName() + "].");
            }
        }
        return templatePackets;
    }

    private static boolean useReplicationLocalView(IDirectSpaceProxy directProxy, ITemplatePacket[] viewTemplatePackets) {
        if (_disableReplicationLocalView) {
            return false;
        }
        if (LocalViewContainer.haveUnreplicableTypes(viewTemplatePackets)) {
            return false;
        }
        return directProxy.getSpaceClusterInfo().isReplicated() && !directProxy.getSpaceClusterInfo().isActiveActive();
    }

    private static boolean haveUnreplicableTypes(ITemplatePacket[] templatePackets) {
        for (ITemplatePacket packet : templatePackets) {
            if (packet.getTypeDescriptor().isReplicable()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void notifyLocalSpaceOnInternalStateChange(SpaceCacheState state) {
        switch (state) {
            case CONNECTED: {
                this.updateConnectionState(LocalViewConnectionState.ACTIVE);
                break;
            }
            case CONNECTING: {
                break;
            }
            case DISCONNECTED: {
                this.updateConnectionState(LocalViewConnectionState.INACTIVE);
                break;
            }
            case CLOSED: {
                this.updateConnectionState(LocalViewConnectionState.CLOSED);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported state " + state.name());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnectionState(LocalViewConnectionState newState) {
        Object object = this._stateLock;
        synchronized (object) {
            if (this._localViewConnectionState == LocalViewConnectionState.CLOSED) {
                return;
            }
            if (this._localViewConnectionState == newState) {
                return;
            }
            LocalViewConnectionState currState = this._localViewConnectionState;
            this._localViewConnectionState = newState;
            this._logger.info(this._cacheID + " connection state changed from " + (Object)((Object)currState) + " to " + (Object)((Object)newState));
            for (LocalViewConnectionStateListener listener : this._listeners) {
                listener.onConnectionStateChanged(currState, newState);
            }
        }
    }
}

