/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache.localview.actions;

import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.executor.SpaceTask;
import com.gigaspaces.internal.client.cache.AbstractSpaceCache;
import com.gigaspaces.internal.client.cache.localview.LocalViewContainer;
import com.gigaspaces.internal.client.spaceproxy.actions.AdminProxyAction;
import com.j_spaces.core.DropClassException;
import com.j_spaces.core.SpaceHealthStatus;
import java.rmi.RemoteException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

public class LocalViewImplAdminAction
extends AdminProxyAction<LocalViewContainer> {
    public void dropClass(LocalViewContainer spaceProxy, String className) throws RemoteException, DropClassException {
        if (spaceProxy.isReplicationLocalView()) {
            throw new UnsupportedOperationException("Local view is read only - this operation is not supported.");
        }
        AbstractSpaceCache cache = spaceProxy.assertCacheConnected();
        cache.getRemoteProxy().dropClass(className);
    }

    public void ping(LocalViewContainer spaceProxy) throws RemoteException {
        AbstractSpaceCache cache = spaceProxy.assertCacheConnected();
        cache.getRemoteProxy().ping();
    }

    public SpaceHealthStatus getSpaceHealthStatus(LocalViewContainer spaceProxy) throws RemoteException {
        AbstractSpaceCache cache = spaceProxy.assertCacheConnected();
        return cache.getRemoteProxy().getSpaceHealthStatus();
    }

    public AsyncFuture execute(LocalViewContainer spaceProxy, SpaceTask task, Object routing, Transaction txn, AsyncFutureListener listener) throws RemoteException, TransactionException {
        if (spaceProxy.isReplicationLocalView()) {
            throw new UnsupportedOperationException("Local view is read only - this operation is not supported.");
        }
        AbstractSpaceCache cache = spaceProxy.assertCacheConnected();
        return cache.getRemoteProxy().execute(task, routing, txn, listener);
    }
}

