/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache.localview.actions;

import com.gigaspaces.client.ReadByIdsException;
import com.gigaspaces.client.ReadTakeByIdsException;
import com.gigaspaces.internal.client.cache.AbstractSpaceCache;
import com.gigaspaces.internal.client.cache.localview.LocalViewContainer;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.ReadTakeByIdsProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actions.ReadTakeByIdsProxyAction;
import com.gigaspaces.internal.server.storage.EntryDataType;
import com.gigaspaces.internal.transport.ITemplatePacket;
import java.lang.reflect.Array;
import java.rmi.RemoteException;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.TransactionException;

public class LocalViewImplReadTakeByIdsAction
extends ReadTakeByIdsProxyAction<LocalViewContainer> {
    public Object[] readByIds(LocalViewContainer spaceProxy, ReadTakeByIdsProxyActionInfo actionInfo, boolean returnPackets) throws RemoteException, TransactionException, UnusableEntryException, InterruptedException {
        Object[] results;
        if (actionInfo.txn != null) {
            throw new UnsupportedOperationException("Local view is read only - doesn't support transactions.");
        }
        spaceProxy.verifyProjectionsAreSupported(actionInfo.queryPacket.getProjectionTemplate());
        AbstractSpaceCache cache = spaceProxy.assertCacheConnected();
        if (cache.getCacheEntryDataType() == EntryDataType.USER_TYPE) {
            Exception[] exceptions = null;
            Class resultClass = cache.getRemoteProxy().getTypeManager().getResultClass((ITemplatePacket)actionInfo.queryPacket);
            results = (Object[])Array.newInstance(resultClass, actionInfo.ids.length);
            for (int i = 0; i < actionInfo.ids.length; ++i) {
                try {
                    results[i] = cache.getLocalSpaceImpl().getEngine().directLocalReadById(actionInfo.ids[i], actionInfo.className, actionInfo.queryPacket.getQueryResultType());
                    continue;
                }
                catch (Exception e) {
                    if (exceptions == null) {
                        exceptions = new Exception[actionInfo.ids.length];
                    }
                    exceptions[i] = e;
                }
            }
            if (exceptions != null) {
                throw ReadTakeByIdsException.newException((Object[])actionInfo.ids, (Object[])results, exceptions, (boolean)actionInfo.isTake);
            }
        } else {
            try {
                results = cache.getLocalSpaceImpl().readByIds((ITemplatePacket)actionInfo.queryPacket, actionInfo.txn, false, null, actionInfo.modifiers);
            }
            catch (ReadByIdsException e) {
                throw e;
            }
            catch (Exception e) {
                throw ReadTakeByIdsException.newException((Object[])actionInfo.ids, (Throwable)e, (boolean)actionInfo.isTake);
            }
        }
        return results;
    }

    public Object[] takeByIds(LocalViewContainer spaceProxy, ReadTakeByIdsProxyActionInfo actionInfo, boolean returnPackets) throws RemoteException, TransactionException, UnusableEntryException, InterruptedException {
        throw new UnsupportedOperationException("Local view is read only - doesn't support takeByIds.");
    }
}

