/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache.localview.notification;

import com.gigaspaces.events.DataEventSession;
import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.internal.client.cache.NotifySpaceCache;
import com.gigaspaces.internal.client.cache.SpaceCacheInitializationException;
import com.gigaspaces.internal.client.cache.localview.LocalViewContainer;
import com.gigaspaces.internal.client.cache.localview.notification.NotificationLocalViewListener;
import com.gigaspaces.internal.query.continous.ContinousQueryConfig;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.j_spaces.core.client.SpaceInitializationException;
import java.rmi.RemoteException;
import java.util.logging.Logger;

public class NotificationLocalView
extends NotifySpaceCache {
    private final LocalViewContainer _cacheContainer;
    private NotificationLocalViewListener[] _listeners;

    public NotificationLocalView(LocalViewContainer cacheContainer) {
        super(cacheContainer);
        this._cacheContainer = cacheContainer;
    }

    @Override
    public void initialize() throws SpaceInitializationException, InterruptedException {
        super.initialize();
        this._listeners = this.initEventListeners(this._cacheContainer.getCacheConfig().getViewTemplatePackets());
    }

    @Override
    public void close() {
        if (this._listeners != null) {
            for (NotificationLocalViewListener listener : this._listeners) {
                if (listener == null) continue;
                listener.close();
            }
        }
        super.close();
    }

    @Override
    protected Logger initLogger() {
        return Logger.getLogger("com.gigaspaces.localview");
    }

    @Override
    protected boolean useFifoEventListeners() {
        return true;
    }

    private NotificationLocalViewListener[] initEventListeners(ITemplatePacket[] templates) throws SpaceCacheInitializationException {
        NotifyActionType notifyActionType = NotifyActionType.NOTIFY_WRITE.or(NotifyActionType.NOTIFY_UPDATE).or(NotifyActionType.NOTIFY_TAKE).or(NotifyActionType.NOTIFY_UNMATCHED).or(NotifyActionType.NOTIFY_LEASE_EXPIRATION);
        ContinousQueryConfig continousQueryConfig = new ContinousQueryConfig().setLeaseDuration(this._cacheContainer.getCacheConfig().getMaxDisconnectionDuration().longValue()).setNotifyActionType(notifyActionType).setReadModifiers(40960);
        NotificationLocalViewListener[] listeners = new NotificationLocalViewListener[templates.length];
        try {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i] = new NotificationLocalViewListener(this, templates[i], (DataEventSession)this._eventSession, continousQueryConfig);
            }
        }
        catch (RemoteException e) {
            throw new SpaceCacheInitializationException("Failed to register local view notification event listener", e);
        }
        return listeners;
    }
}

