/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache.localview.notification;

import com.gigaspaces.events.DataEventSession;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.cache.localview.notification.NotificationLocalView;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.query.continous.ContinousQuery;
import com.gigaspaces.internal.query.continous.ContinousQueryConfig;
import com.gigaspaces.internal.query.continous.ContinousQueryListener;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NotificationLocalViewListener
implements ContinousQueryListener {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.localview");
    private final IDirectSpaceProxy _localSpace;
    private final ITemplatePacket _queryPacket;
    private final ContinousQuery _continousQuery;

    public NotificationLocalViewListener(NotificationLocalView localView, ITemplatePacket queryPacket, DataEventSession eventSession, ContinousQueryConfig config) throws RemoteException {
        this._localSpace = localView.getLocalProxy();
        this._queryPacket = queryPacket;
        this._continousQuery = new ContinousQuery((ISpaceProxy)localView.getRemoteProxy(), this._queryPacket, (ContinousQueryListener)this, config, eventSession);
    }

    public void close() {
        block2: {
            try {
                this._continousQuery.close();
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.FINE)) break block2;
                _logger.log(Level.FINE, "Failed to close [" + this._continousQuery + "], ignoring", e);
            }
        }
    }

    private void cache(IEntryPacket packet) {
        block4: {
            try {
                long ttl;
                Object entry = packet;
                EntryType entryType = this._queryPacket.getQueryResultType().getEntryType();
                if (entryType == null) {
                    entryType = packet.getTypeDescriptor().getObjectType();
                }
                if (entryType != packet.getEntryType()) {
                    entry = this._localSpace.getTypeManager().convertQueryResult(packet, this._queryPacket, false);
                }
                this._localSpace.update(entry, null, (ttl = packet.getTTL()) > 0L ? ttl : 1L, 0L, 4096);
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.FINE)) break block4;
                _logger.log(Level.FINE, "cache(): Ignore because of notify concurrency", ex);
            }
        }
    }

    public void onExisting(IEntryPacket entry) {
        this.cache(entry);
    }

    public void onEvent(EntryArrivedRemoteEvent event) {
        block7: {
            try {
                IEntryPacket entry = event.getEntryPacket();
                int action = event.getNotifyType();
                switch (action) {
                    case 4: 
                    case 32: {
                        this._localSpace.takeByUid(entry.getUID(), null, this._localSpace.getReadModifiers(), QueryResultTypeInternal.NOT_SET, true);
                        break;
                    }
                    case 8: {
                        this._localSpace.getRemoteJSpace().cancel(entry.getUID(), entry.getTypeName(), 1);
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.cache(entry);
                    }
                }
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.FINE)) break block7;
                _logger.log(Level.FINE, "takeLocals: ", ex);
            }
        }
    }
}

