/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache.localview.replication;

import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.AbstractReplicationEntryEventHandler;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.ITransportPacket;
import com.gigaspaces.internal.transport.TemplatePacketFactory;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.client.EntryAlreadyInSpaceException;
import com.j_spaces.core.client.EntryNotInSpaceException;
import com.j_spaces.core.client.EntryVersionConflictException;
import java.util.Collection;
import java.util.logging.Level;
import net.jini.core.transaction.Transaction;

public class LocalViewReplicationEntryEventHandler
extends AbstractReplicationEntryEventHandler {
    private final SpaceEngine _engine;

    public LocalViewReplicationEntryEventHandler(SpaceEngine engine) {
        this._engine = engine;
    }

    public void writeEntry(IReplicationInContext context, Transaction txn, boolean twoPhaseCommit, IEntryPacket entry) throws Exception {
        IReplicationInBatchContext batchContext = (IReplicationInBatchContext)context;
        this._engine.getTypeManager().loadServerTypeDesc((ITransportPacket)entry);
        long lease = entry.getTTL();
        try {
            this._engine.write(entry, txn, lease, 0, true, false, null);
            this.afterConsumption(txn, batchContext);
        }
        catch (EntryAlreadyInSpaceException e) {
            if (context.getContextLogger().isLoggable(Level.WARNING)) {
                context.getContextLogger().log(Level.WARNING, "Replicator: " + ((Object)((Object)e)).getClass().getName() + ". Failed to write entry: " + entry.getTypeName() + " UID: " + entry.getUID() + " in target [" + this._engine.getFullSpaceName() + "] space.");
            }
            this.afterConsumption(txn, batchContext);
        }
    }

    private void afterConsumption(Transaction txn, IReplicationInBatchContext batchContext) {
        if (txn == null) {
            batchContext.currentConsumed();
        }
    }

    public void updateEntry(IReplicationInContext context, Transaction txn, boolean twoPhaseCommit, IEntryPacket entry, IEntryPacket previousPacket, boolean partialUpdate, boolean overrideVersion) throws Exception {
        IReplicationInBatchContext batchContext = (IReplicationInBatchContext)context;
        this._engine.getTypeManager().loadServerTypeDesc((ITransportPacket)entry);
        long lease = entry.getTTL();
        try {
            int updateModifiers;
            int n = updateModifiers = overrideVersion ? 524288 : 0;
            if (partialUpdate) {
                updateModifiers |= 0x10;
            }
            this._engine.update(entry, txn, lease, 0L, null, true, false, false, updateModifiers);
            this.afterConsumption(txn, batchContext);
        }
        catch (EntryVersionConflictException e) {
            if (context.getContextLogger().isLoggable(Level.WARNING)) {
                context.getContextLogger().log(Level.WARNING, "Replicator: " + ((Object)((Object)e)).getClass().getName() + ". Failed to update entry: " + entry.getTypeName() + " UID: " + entry.getUID() + " in target [" + this._engine.getFullSpaceName() + "] space.");
            }
            this.afterConsumption(txn, batchContext);
        }
        catch (EntryNotInSpaceException e) {
            if (context.getContextLogger().isLoggable(Level.WARNING)) {
                context.getContextLogger().log(Level.WARNING, "Replicator: " + ((Object)((Object)e)).getClass().getName() + ". Failed to update entry: " + entry.getTypeName() + " UID: " + entry.getUID() + " in target [" + this._engine.getFullSpaceName() + "] space.");
            }
            this.afterConsumption(txn, batchContext);
        }
    }

    public void removeEntry(IReplicationInContext context, Transaction txn, boolean twoPhaseCommit, IEntryPacket entry) throws Exception {
        this._engine.getTypeManager().loadServerTypeDesc((ITransportPacket)entry);
        this.removeEntryByUid(context, txn, twoPhaseCommit, entry.getUID(), entry.isTransient(), entry.getOperationID());
    }

    public void removeEntryByUid(IReplicationInContext context, Transaction txn, boolean twoPhaseCommit, String uid, boolean isTransient, OperationID operationID) throws Exception {
        IReplicationInBatchContext batchContext = (IReplicationInBatchContext)context;
        ITemplatePacket template = TemplatePacketFactory.createUidPacket((String)uid, (int)0, (boolean)false);
        template.setOperationID(operationID);
        try {
            this._engine.read(template, txn, 0L, true, true, null, false, true, false, 16384);
            this.afterConsumption(txn, batchContext);
        }
        catch (EntryVersionConflictException e) {
            if (context.getContextLogger().isLoggable(Level.WARNING)) {
                context.getContextLogger().log(Level.WARNING, "Replicator: " + ((Object)((Object)e)).getClass().getName() + ". Failed to remove entry - UID " + uid + " in target [" + this._engine.getFullSpaceName() + "] space.");
            }
            this.afterConsumption(txn, batchContext);
        }
        catch (EntryNotInSpaceException e) {
            if (context.getContextLogger().isLoggable(Level.FINE)) {
                context.getContextLogger().log(Level.FINE, "Replicator: " + ((Object)((Object)e)).getClass().getName() + ". Failed to remove entry - UID " + uid + " in target [" + this._engine.getFullSpaceName() + "] space.");
            }
            this.afterConsumption(txn, batchContext);
        }
    }

    public void changeEntry(IReplicationInContext context, Transaction txn, boolean twoPhaseCommit, String typeName, String uid, Object id, int routingHash, int version, int previousVersion, long timeToLive, Collection<SpaceEntryMutator> mutators, boolean isTransient, OperationID operationID, IEntryData previousEntry) throws Exception {
        IReplicationInBatchContext batchContext = (IReplicationInBatchContext)context;
        try {
            ITemplatePacket template = TemplatePacketFactory.createUidPacket((String)uid, (int)version);
            int operationModifiers = 0;
            this._engine.change(template, txn, timeToLive, 0L, null, true, false, mutators, operationModifiers, false);
            this.afterConsumption(txn, batchContext);
        }
        catch (EntryVersionConflictException e) {
            if (context.getContextLogger().isLoggable(Level.WARNING)) {
                context.getContextLogger().log(Level.WARNING, "Replicator: " + ((Object)((Object)e)).getClass().getName() + ". Failed to change entry: " + typeName + " UID: " + uid + " in target [" + this._engine.getFullSpaceName() + "] space.");
            }
            this.afterConsumption(txn, batchContext);
        }
        catch (EntryNotInSpaceException e) {
            if (context.getContextLogger().isLoggable(Level.WARNING)) {
                context.getContextLogger().log(Level.WARNING, "Replicator: " + ((Object)((Object)e)).getClass().getName() + ". Failed to change entry: " + typeName + " UID: " + uid + " in target [" + this._engine.getFullSpaceName() + "] space.");
            }
            this.afterConsumption(txn, batchContext);
        }
    }
}

