/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache.localview.replication;

import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.impl.handlers.SpaceReplicationEntryLeaseEventHandler;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.core.OperationID;
import java.util.logging.Level;
import net.jini.core.lease.UnknownLeaseException;

public class LocalViewReplicationEntryLeaseEventHandler
extends SpaceReplicationEntryLeaseEventHandler {
    public LocalViewReplicationEntryLeaseEventHandler(SpaceEngine engine) {
        super(engine);
    }

    public void inCancelEntryLeaseByUID(IReplicationInContext context, String typeName, String uid, boolean isTransient, int routingValue) {
        block2: {
            try {
                this.getLeaseManager().cancel(uid, typeName, 1, true, false, false);
            }
            catch (UnknownLeaseException ex) {
                if (!context.getContextLogger().isLoggable(Level.FINE)) break block2;
                context.getContextLogger().log(Level.FINE, "Replicator: " + ((Object)((Object)ex)).getClass().getName() + ". Failed to cancel Entry lease: " + typeName + " UID: " + uid + " ObjectType: " + 1 + " in target [" + this._engine.getFullSpaceName() + "] space.\nThis entry might be already expired or canceled.");
            }
        }
        IReplicationInBatchContext batchContext = (IReplicationInBatchContext)context;
        batchContext.currentConsumed();
    }

    public void inEntryLeaseExpiredByUID(IReplicationInContext context, String typeName, String uid, boolean isTransient, OperationID operationID) {
        block2: {
            try {
                this.getLeaseManager().cancel(uid, typeName, 1, true, false, true, operationID, false);
            }
            catch (UnknownLeaseException ex) {
                if (!context.getContextLogger().isLoggable(Level.FINE)) break block2;
                context.getContextLogger().log(Level.FINE, "Replicator: " + ((Object)((Object)ex)).getClass().getName() + ". Failed to expire Entry lease: " + typeName + " UID: " + uid + " ObjectType: " + 1 + " in target [" + this._engine.getFullSpaceName() + "] space.\nThis entry might be already canceled.");
            }
        }
        IReplicationInBatchContext batchContext = (IReplicationInBatchContext)context;
        batchContext.currentConsumed();
    }

    public void inEntryLeaseExpired(IReplicationInContext context, IEntryPacket entryPacket) {
        this.inEntryLeaseExpiredByUID(context, entryPacket.getTypeName(), entryPacket.getUID(), entryPacket.isTransient(), entryPacket.getOperationID());
    }

    public void inExtendEntryLeasePeriod(IReplicationInContext context, String typeName, String uid, boolean isTransient, long lease, int routingValue) throws UnknownLeaseException {
        try {
            this.getLeaseManager().renew(uid, typeName, 1, lease, true, false, false);
        }
        catch (UnknownLeaseException unknownLeaseException) {
            // empty catch block
        }
        IReplicationInBatchContext batchContext = (IReplicationInBatchContext)context;
        batchContext.currentConsumed();
    }
}

