/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache.localview.replication;

import com.gigaspaces.client.localview.LocalViewConnectionState;
import com.gigaspaces.internal.client.cache.AbstractSpaceCache;
import com.gigaspaces.internal.client.cache.SpaceCacheInitializationException;
import com.gigaspaces.internal.client.cache.localview.LocalViewContainer;
import com.gigaspaces.internal.client.cache.localview.replication.LocalViewReplicationEntryEventHandler;
import com.gigaspaces.internal.client.cache.localview.replication.LocalViewReplicationEntryLeaseEventHandler;
import com.gigaspaces.internal.client.cache.localview.replication.LocalViewReplicationMetadataEventHandler;
import com.gigaspaces.internal.client.cache.localview.replication.LocalViewReplicationTransactionEventHandler;
import com.gigaspaces.internal.client.cache.localview.replication.ReplicationLocalViewStateListener;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.operations.RegisterLocalViewSpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.UnregisterLocalViewSpaceOperationRequest;
import com.gigaspaces.internal.cluster.SpaceClusterInfo;
import com.gigaspaces.internal.cluster.node.IReplicationNodeStateListener;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInDataTypeCreatedHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInDataTypeIndexAddedHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInEntryHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInEntryLeaseCancelledHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInEntryLeaseExpiredHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInEntryLeaseExtendedHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInTransactionHandler;
import com.gigaspaces.internal.cluster.node.impl.IReplicationNodeBuilder;
import com.gigaspaces.internal.cluster.node.impl.ReplicationNode;
import com.gigaspaces.internal.cluster.node.impl.ReplicationNodeBuilder;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeConfig;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeConfigBuilder;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeFixFacade;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataBatchConsumer;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataConsumer;
import com.gigaspaces.internal.cluster.node.impl.packets.data.SpaceEngineFixFacade;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogBuilder;
import com.gigaspaces.internal.cluster.node.impl.processlog.ReliableAsyncAdaptiveProcessLogBuilder;
import com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile.DistributedTransactionProcessingConfiguration;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceCopyIntermediateResult;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceReplicaConsumeFacade;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceReplicaDataConsumer;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceReplicaDataConsumer;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceSynchronizeReplicaRequestContext;
import com.gigaspaces.internal.cluster.node.impl.router.RouterStubHolder;
import com.gigaspaces.internal.cluster.node.replica.ISpaceCopyReplicaParameters;
import com.gigaspaces.internal.cluster.node.replica.ISpaceCopyResult;
import com.gigaspaces.internal.cluster.node.replica.ISpaceSynchronizeReplicaRequestContext;
import com.gigaspaces.internal.cluster.node.replica.ISpaceSynchronizeReplicaState;
import com.gigaspaces.internal.cluster.node.replica.ISpaceSynchronizeResult;
import com.gigaspaces.internal.cluster.node.replica.SpaceCopyReplicaParameters;
import com.gigaspaces.internal.query.QueryUtils;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterUtils;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.space.SpaceEngineReplicaConsumerFacade;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.gigaspaces.internal.utils.concurrent.ScheduledThreadPoolAsyncHandlerProvider;
import com.gigaspaces.management.space.SpaceQueryDetails;
import com.gigaspaces.security.SecurityException;
import com.gigaspaces.start.SystemInfo;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.client.SpaceInitializationException;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.kernel.JSpaceUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;

public class ReplicationLocalView
extends AbstractSpaceCache {
    private final LocalViewContainer _cacheContainer;
    private final ReplicationLocalViewStateListener _stateListener;
    private ReplicationNode _viewReplicationNode;
    private List<ITemplatePacket>[] _partitionedQueryPackets;
    private List<SpaceQueryDetails>[] _partitionedQueryDescriptions;

    public ReplicationLocalView(LocalViewContainer cacheContainer) {
        super(cacheContainer);
        this._cacheContainer = cacheContainer;
        this._stateListener = new ReplicationLocalViewStateListener(this, cacheContainer.getCacheConfig());
    }

    @Override
    public void initialize() throws SpaceInitializationException, InterruptedException {
        super.initialize();
        SpaceClusterInfo clusterInfo = this._remoteSpace.getSpaceClusterInfo();
        int numOfPartitions = clusterInfo.isPartitioned() ? clusterInfo.getNumberOfPartitions() : 1;
        this.partitionTemplates(numOfPartitions);
        this._viewReplicationNode = this.createReplicationNode(this.getLocalSpaceImpl().getEngine());
        this.registerViewReplicationNode();
        this.synchronizeFromPrimaries();
    }

    private void partitionTemplates(int numOfPartitions) {
        int i;
        List<Object> queries = this._cacheContainer.getCacheConfig().getViewQueries();
        ITemplatePacket[] queryPackets = this._cacheContainer.getCacheConfig().getViewTemplatePackets();
        this._partitionedQueryPackets = new List[numOfPartitions];
        this._partitionedQueryDescriptions = new List[numOfPartitions];
        for (i = 0; i < numOfPartitions; ++i) {
            this._partitionedQueryPackets[i] = new ArrayList<ITemplatePacket>();
            this._partitionedQueryDescriptions[i] = new ArrayList<SpaceQueryDetails>();
        }
        for (i = 0; i < queryPackets.length; ++i) {
            ITemplatePacket queryPacket = queryPackets[i].clone();
            queryPacket.setSerializeTypeDesc(true);
            SpaceQueryDetails queryDesc = new SpaceQueryDetails(QueryUtils.getQueryDescription((Object)queries.get(i)));
            int partitionId = PartitionedClusterUtils.getPartitionId((Object)queryPacket.getRoutingFieldValue(), (int)numOfPartitions);
            if (partitionId != -1) {
                this._partitionedQueryPackets[partitionId].add(queryPacket);
                this._partitionedQueryDescriptions[partitionId].add(queryDesc);
                continue;
            }
            for (int j = 0; j < numOfPartitions; ++j) {
                this._partitionedQueryPackets[j].add(queryPacket);
                this._partitionedQueryDescriptions[j].add(queryDesc);
            }
        }
    }

    @Override
    public void close() {
        if (this._viewReplicationNode != null) {
            this.unregisterViewReplicationNode();
            this._viewReplicationNode.close();
            this._viewReplicationNode = null;
        }
        super.close();
    }

    @Override
    protected Logger initLogger() {
        return Logger.getLogger("com.gigaspaces.localview");
    }

    @Override
    public boolean isHealthy() {
        return this._stateListener.isHealthy();
    }

    public boolean hasTemplates(int partitionId) {
        return !this._partitionedQueryPackets[partitionId].isEmpty();
    }

    @Override
    protected String getCacheSuffix() {
        Uuid uuid = UuidFactory.generate();
        String hostname = SystemInfo.singleton().network().getHost().getHostName();
        String processId = "";
        try {
            long pid = SystemInfo.singleton().os().processId();
            processId = "[" + pid + "]";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "_LocalView_" + hostname + processId + "_" + uuid;
    }

    private ReplicationNode createReplicationNode(SpaceEngine engine) {
        ReplicationNodeBuilder replicationNodeBuilder = ReplicationLocalView.createReplicationNodeBuilder(engine);
        ReplicationNodeConfig replicationNodeConfig = ReplicationNodeConfigBuilder.getInstance().createLocalViewConfig(this._remoteSpace.getName(), this._remoteSpace.getSpaceClusterInfo(), replicationNodeBuilder, this._partitionedQueryPackets.length);
        ReplicationNode replicationNode = new ReplicationNode(replicationNodeConfig, (IReplicationNodeBuilder)replicationNodeBuilder, engine.getFullSpaceName(), engine.getMetricRegistrator());
        LocalViewReplicationEntryEventHandler entryHandler = new LocalViewReplicationEntryEventHandler(engine);
        replicationNode.setInEntryHandler((IReplicationInEntryHandler)entryHandler);
        LocalViewReplicationTransactionEventHandler transactionHandler = new LocalViewReplicationTransactionEventHandler(engine, entryHandler);
        replicationNode.setInTransactionHandler((IReplicationInTransactionHandler)transactionHandler);
        LocalViewReplicationEntryLeaseEventHandler entryLeaseHandler = new LocalViewReplicationEntryLeaseEventHandler(engine);
        replicationNode.setInEntryLeaseCancelledHandler((IReplicationInEntryLeaseCancelledHandler)entryLeaseHandler);
        replicationNode.setInEntryLeaseExpiredHandler((IReplicationInEntryLeaseExpiredHandler)entryLeaseHandler);
        replicationNode.setInEntryLeaseExtendedHandler((IReplicationInEntryLeaseExtendedHandler)entryLeaseHandler);
        LocalViewReplicationMetadataEventHandler metadataHandler = new LocalViewReplicationMetadataEventHandler(engine.getTypeManager(), engine);
        replicationNode.setInDataTypeCreatedHandler((IReplicationInDataTypeCreatedHandler)metadataHandler);
        replicationNode.setInDataTypeIndexAddedHandler((IReplicationInDataTypeIndexAddedHandler)metadataHandler);
        replicationNode.getAdmin().setNodeStateListener((IReplicationNodeStateListener)this._stateListener);
        replicationNode.getAdmin().setActive();
        return replicationNode;
    }

    private static ReplicationNodeBuilder createReplicationNodeBuilder(SpaceEngine engine) {
        ReplicationNodeBuilder nodeBuilder = new ReplicationNodeBuilder();
        nodeBuilder.setReplicationRouterBuilder(engine.getReplicationManager().getReplicationRouterBuilder());
        ReplicationPacketDataConsumer dataConsumer = new ReplicationPacketDataConsumer(engine.getTypeManager(), (IDataConsumeFixFacade)new SpaceEngineFixFacade(engine), null);
        nodeBuilder.setReplicaDataConsumer((ISpaceReplicaDataConsumer)new SpaceReplicaDataConsumer(engine.getTypeManager(), (ISpaceReplicaConsumeFacade)new SpaceEngineReplicaConsumerFacade(engine)));
        DistributedTransactionProcessingConfiguration distributedTransactionProcessingConfiguration = new DistributedTransactionProcessingConfiguration(60000L, -1L);
        nodeBuilder.setReplicationProcessLogBuilder((IReplicationProcessLogBuilder)new ReliableAsyncAdaptiveProcessLogBuilder((IReplicationPacketDataBatchConsumer)dataConsumer, distributedTransactionProcessingConfiguration));
        int CORE_POOL_SIZE = 2;
        nodeBuilder.setAsyncHandlerProvider((IAsyncHandlerProvider)new ScheduledThreadPoolAsyncHandlerProvider("ReplicationNodePool-" + engine.getFullSpaceName(), 2));
        return nodeBuilder;
    }

    private void registerViewReplicationNode() throws InterruptedException, SpaceCacheInitializationException {
        RouterStubHolder viewStub = this._viewReplicationNode.getAdmin().getRouterAdmin().getMyRouterStubHolder();
        RegisterLocalViewSpaceOperationRequest request = new RegisterLocalViewSpaceOperationRequest((List[])this._partitionedQueryPackets, (List[])this._partitionedQueryDescriptions, viewStub, this._cacheContainer.getCacheConfig().getBatchSize().intValue(), this._cacheContainer.getCacheConfig().getBatchTimeout().longValue());
        try {
            this._remoteSpace.getProxyRouter().execute((RemoteOperationRequest)request);
        }
        catch (NullPointerException e) {
            throw new SpaceCacheInitializationException("LocalView replication node registration failed: " + e);
        }
        if (request.getErrors() != null) {
            request.getErrors().throwIfAny(SecurityException.class);
            request.getErrors().throwIfAny(IllegalStateException.class);
            throw new SpaceCacheInitializationException("LocalView replication node registration failed: " + request.getErrors().getDescription());
        }
    }

    private void synchronizeFromPrimaries() throws InterruptedException, SpaceCacheInitializationException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Synchronizing initial state from remote space [" + this._remoteSpace.getName() + "]");
        }
        long bootstrapStartTime = SystemTime.timeMillis();
        long synchronizeTimeout = this._cacheContainer.getCacheConfig().getInitialSynchronizationTimeout();
        ISpaceSynchronizeReplicaState[] replicaStates = this.startSynchronize();
        ISpaceCopyResult copyResult = this.waitForCopy(replicaStates, synchronizeTimeout);
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Completed synchronization copy stage from " + replicaStates.length + " partitions, recovered data: " + StringUtils.NEW_LINE + copyResult.getStringDescription(this._remoteSpace.getName(), this._remoteSpace.getURL().toString(), this._localSpace.getName(), true, SystemTime.timeMillis() - bootstrapStartTime));
        }
        this._stateListener.setDisconnectedState(replicaStates.length);
        this._viewReplicationNode.getAdmin().getRouterAdmin().enableIncomingCommunication();
        try {
            this.waitForSynchronize(replicaStates, synchronizeTimeout);
            this._stateListener.onSynchronizationCompleted();
        }
        catch (InterruptedException e) {
            this._stateListener.onSynchronizationCompleted();
            throw e;
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Synchronization completed successfully. TOTAL TIME: " + JSpaceUtilities.formatMillis((long)(SystemTime.timeMillis() - bootstrapStartTime)));
        }
    }

    private void unregisterViewReplicationNode() {
        String viewStubHolderName = this._viewReplicationNode.getAdmin().getRouterAdmin().getMyRouterStubHolder().getMyEndpointDetails().getLookupName();
        UnregisterLocalViewSpaceOperationRequest request = new UnregisterLocalViewSpaceOperationRequest(viewStubHolderName, (List[])this._partitionedQueryPackets);
        try {
            this._remoteSpace.getProxyRouter().execute((RemoteOperationRequest)request);
            if (request.getErrors() != null && this._logger.isLoggable(Level.WARNING)) {
                this._logger.log(Level.WARNING, "LocalView replication node unregistration failed: " + request.getErrors().getDescription());
            }
        }
        catch (InterruptedException e) {
            if (this._logger.isLoggable(Level.WARNING)) {
                this._logger.log(Level.WARNING, "LocalView replication node unregistration interrupted", e);
            }
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public SpaceCacheInitializationException getInitializationException() {
        try {
            this._stateListener.onSynchronizationCompleted();
            return null;
        }
        catch (SpaceCacheInitializationException e) {
            return e;
        }
    }

    private ISpaceSynchronizeReplicaState[] startSynchronize() throws SpaceCacheInitializationException {
        int concurrentConsumers = 2;
        int fetchBatchSize = this._cacheContainer.getCacheConfig().getBatchSize();
        ISpaceSynchronizeReplicaState[] replicaStates = new ISpaceSynchronizeReplicaState[this._partitionedQueryPackets.length];
        for (int i = 0; i < replicaStates.length; ++i) {
            if (!this.hasTemplates(i)) continue;
            String synchronizeGroupName = ReplicationLocalView.getReplicationGroupName(i + 1, this._remoteSpace);
            SpaceURL url = this.getPrimaryMemberUrl(i);
            SpaceSynchronizeReplicaRequestContext context = new SpaceSynchronizeReplicaRequestContext();
            context.setOriginUrl((Object)url);
            context.setConcurrentConsumers(2);
            context.setFetchBatchSize(fetchBatchSize);
            context.setSynchronizeGroupName(synchronizeGroupName);
            SpaceCopyReplicaParameters copyParameters = new SpaceCopyReplicaParameters();
            copyParameters.setCopyNotifyTemplates(false);
            copyParameters.setTransient(false);
            copyParameters.setReplicaType(SpaceCopyReplicaParameters.ReplicaType.SYNCRONIZE);
            for (ITemplatePacket templatePacket : this._partitionedQueryPackets[i]) {
                copyParameters.addTemplatePacket(templatePacket);
            }
            context.setParameters((ISpaceCopyReplicaParameters)copyParameters);
            replicaStates[i] = this._viewReplicationNode.spaceSynchronizeReplicaRequest((ISpaceSynchronizeReplicaRequestContext)context);
        }
        return replicaStates;
    }

    private SpaceURL getPrimaryMemberUrl(int partitionId) throws SpaceCacheInitializationException {
        SpaceURL url = this._remoteSpace.getProxyRouter().getPrimaryMemberUrl(partitionId);
        if (url == null) {
            throw new SpaceCacheInitializationException("Unavailable primary member for partition [" + partitionId + "].");
        }
        return url;
    }

    private ISpaceCopyResult waitForCopy(ISpaceSynchronizeReplicaState[] replicaStates, long timeout) throws InterruptedException, SpaceCacheInitializationException {
        ISpaceCopyIntermediateResult result = null;
        Object error = null;
        for (int i = 0; i < replicaStates.length; ++i) {
            if (replicaStates[i] == null) continue;
            if (error == null) {
                try {
                    ISpaceCopyResult memberResult = replicaStates[i].waitForCopyResult(timeout, TimeUnit.MILLISECONDS);
                    if (memberResult.isFailed()) {
                        error = memberResult.getFailureReason();
                        continue;
                    }
                    if (result == null) {
                        result = (ISpaceCopyIntermediateResult)memberResult;
                        continue;
                    }
                    result = result.merge((ISpaceCopyIntermediateResult)memberResult);
                }
                catch (TimeoutException e) {
                    error = new SpaceCacheInitializationException("Timeout expired while waiting for copy result from partition #" + i, e);
                }
                continue;
            }
            try {
                replicaStates[i].abort(3L, TimeUnit.SECONDS);
                continue;
            }
            catch (TimeoutException e) {
                if (!this._logger.isLoggable(Level.FINE)) continue;
                this._logger.log(Level.FINE, this._cacheID + " failed to abort synchronization of partition #" + i);
            }
        }
        if (error != null) {
            throw new SpaceCacheInitializationException("Failed to synchronize local view", (Throwable)error);
        }
        return (ISpaceCopyResult)result;
    }

    private void waitForSynchronize(ISpaceSynchronizeReplicaState[] replicaStates, long timeout) throws InterruptedException, SpaceCacheInitializationException {
        try {
            for (int i = 0; i < replicaStates.length; ++i) {
                ISpaceSynchronizeResult synchronizeResult;
                if (replicaStates[i] == null || !(synchronizeResult = replicaStates[i].waitForSynchronizeCompletion(timeout, TimeUnit.MILLISECONDS)).isFailed()) continue;
                throw new SpaceCacheInitializationException("Failed to synchronize local view", synchronizeResult.getFailureReason());
            }
        }
        catch (TimeoutException e) {
            throw new SpaceCacheInitializationException("Local view synchronization timed out", e);
        }
    }

    private static String getReplicationGroupName(int partitionId, IDirectSpaceProxy remoteSpace) {
        return ReplicationNodeConfigBuilder.getInstance().getSynchronizeGroupName(remoteSpace.getSpaceClusterInfo(), partitionId, remoteSpace.getName());
    }

    public void triggerDisconnection() {
        this._cacheContainer.updateConnectionState(LocalViewConnectionState.DISCONNECTED);
    }

    public void triggerConnection() {
        this._cacheContainer.updateConnectionState(LocalViewConnectionState.ACTIVE);
    }
}

