/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.cache.localview.replication;

import com.gigaspaces.cluster.replication.IncomingReplicationOutOfSyncException;
import com.gigaspaces.internal.client.cache.SpaceCacheInitializationException;
import com.gigaspaces.internal.client.cache.localview.LocalViewConfig;
import com.gigaspaces.internal.client.cache.localview.replication.ReplicationLocalView;
import com.gigaspaces.internal.cluster.node.AbstractReplicationNodeStateListener;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogMemberState;
import com.gigaspaces.internal.cluster.node.impl.groups.BrokenReplicationTopologyException;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterUtils;
import com.gigaspaces.time.SystemTime;
import java.util.HashMap;
import java.util.Map;

public class ReplicationLocalViewStateListener
extends AbstractReplicationNodeStateListener {
    private final ReplicationLocalView _localView;
    private final LocalViewConfig _viewConfig;
    private final Map<Integer, Long> _disconnectedPartitions;
    private final Object _lock;
    private volatile long _disconnectTime;
    private volatile Thread _synchronizationPendingThread;
    private String _synchronizationError;

    public ReplicationLocalViewStateListener(ReplicationLocalView localView, LocalViewConfig viewConfig) {
        this._localView = localView;
        this._viewConfig = viewConfig;
        this._disconnectedPartitions = new HashMap<Integer, Long>();
        this._lock = new Object();
        this._synchronizationPendingThread = Thread.currentThread();
    }

    public boolean isHealthy() {
        long disconnectTime = this._disconnectTime;
        if (disconnectTime == 0L) {
            return true;
        }
        long disconnectDuration = SystemTime.timeMillis() - disconnectTime;
        return disconnectDuration < this._viewConfig.getMaxDisconnectionDuration();
    }

    public boolean onTargetChannelOutOfSync(String groupName, final String channelSourceLookupName, final IncomingReplicationOutOfSyncException outOfSyncReason) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ReplicationLocalViewStateListener.this._lock;
                synchronized (object) {
                    if (ReplicationLocalViewStateListener.this.stopOngoingSynchronizationIfRelevant("Replication is out of sync - " + outOfSyncReason.getMessage() + ". Source lookup name is " + channelSourceLookupName)) {
                        ReplicationLocalViewStateListener.this._localView.onCacheFailure();
                    }
                }
            }
        }.start();
        return false;
    }

    public void onTargetChannelBacklogDropped(String groupName, final String channelSourceLooString, IBacklogMemberState memberState) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ReplicationLocalViewStateListener.this._lock;
                synchronized (object) {
                    if (ReplicationLocalViewStateListener.this.stopOngoingSynchronizationIfRelevant("Backlog was dropped for this target. Source lookup name is " + channelSourceLooString)) {
                        return;
                    }
                    ReplicationLocalViewStateListener.this._localView.onCacheFailure();
                }
            }
        }.start();
    }

    public void onTargetChannelCreationValidation(String groupName, String sourceMemberName, Object sourceUniqueId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisconnectedState(int numOfPartitions) {
        Object object = this._lock;
        synchronized (object) {
            this._disconnectTime = SystemTime.timeMillis();
            for (int i = 0; i < numOfPartitions; ++i) {
                if (!this._localView.hasTemplates(i)) continue;
                this._disconnectedPartitions.put(i, this._disconnectTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTargetChannelSourceDisconnected(String groupName, String sourceMemberName, Object sourceUniqueId) {
        Object object = this._lock;
        synchronized (object) {
            if (this.stopOngoingSynchronizationIfRelevant("Disconnected from source " + sourceMemberName)) {
                return;
            }
            long currTime = SystemTime.timeMillis();
            int partitionId = ReplicationLocalViewStateListener.extractPartitionId(sourceMemberName);
            this._disconnectedPartitions.put(partitionId, currTime);
            long previousDisconnectTime = this._disconnectTime;
            this._disconnectTime = this.updateDisconnectTime();
            if (this._disconnectTime != 0L && previousDisconnectTime == 0L) {
                this._localView.triggerDisconnection();
            }
        }
    }

    private boolean stopOngoingSynchronizationIfRelevant(String message) {
        this._synchronizationError = message;
        Thread synchronizationPendingThread = this._synchronizationPendingThread;
        if (synchronizationPendingThread != null) {
            synchronizationPendingThread.interrupt();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTargetChannelConnected(String groupName, String sourceMemberName, Object sourceUniqueId) {
        Object object = this._lock;
        synchronized (object) {
            if (this.isHealthy()) {
                int partitionId = ReplicationLocalViewStateListener.extractPartitionId(sourceMemberName);
                this._disconnectedPartitions.remove(partitionId);
                this._disconnectTime = this.updateDisconnectTime();
                if (this._disconnectTime == 0L) {
                    this._localView.triggerConnection();
                }
            }
        }
    }

    private long updateDisconnectTime() {
        long oldestDisconnectTime = 0L;
        for (Long disconnectTime : this._disconnectedPartitions.values()) {
            if (oldestDisconnectTime != 0L && oldestDisconnectTime <= disconnectTime) continue;
            oldestDisconnectTime = disconnectTime;
        }
        return oldestDisconnectTime;
    }

    public void onSourceBrokenReplicationTopology(String groupName, String channelTargetMemberName, BrokenReplicationTopologyException error) {
    }

    public void onSourceChannelActivated(String groupName, String memberName) {
    }

    public void onNewReplicaRequest(String groupName, String channelName, boolean isSynchronizeRequest) {
    }

    private static int extractPartitionId(String memberName) {
        return PartitionedClusterUtils.extractPartitionIdFromSpaceName((String)memberName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSynchronizationCompleted() throws SpaceCacheInitializationException {
        Object object = this._lock;
        synchronized (object) {
            this._synchronizationPendingThread = null;
            if (this._synchronizationError != null) {
                throw new SpaceCacheInitializationException("Failed to synchronize local view - " + this._synchronizationError);
            }
        }
    }
}

