/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.rest.client.java.api;

import com.gigaspaces.rest.client.java.invoker.ApiCallback;
import com.gigaspaces.rest.client.java.invoker.ApiClient;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.invoker.Configuration;
import com.gigaspaces.rest.client.java.invoker.Pair;
import com.gigaspaces.rest.client.java.invoker.ProgressRequestBody;
import com.gigaspaces.rest.client.java.invoker.ProgressResponseBody;
import com.gigaspaces.rest.client.java.model.Space;
import com.gigaspaces.rest.client.java.model.SpaceInstance;
import com.gigaspaces.rest.client.java.model.SpaceInstanceOperationsStatistics;
import com.gigaspaces.rest.client.java.model.SpaceInstanceReplicationStatistics;
import com.gigaspaces.rest.client.java.model.SpaceInstanceTypesStatistics;
import com.gigaspaces.rest.client.java.model.SpaceOperationsStatistics;
import com.gigaspaces.rest.client.java.model.SpaceQueryResult;
import com.gigaspaces.rest.client.java.model.SpaceTypesStatistics;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SpacesApi {
    private ApiClient apiClient;

    public SpacesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SpacesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call spacesGetCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spaces";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicSecurity"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call spacesGetValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.spacesGetCall(progressListener, progressRequestListener);
        return call;
    }

    public List<Space> spacesGet() throws ApiException {
        ApiResponse<List<Space>> resp = this.spacesGetWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<List<Space>> spacesGetWithHttpInfo() throws ApiException {
        Call call = this.spacesGetValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<List<Space>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call spacesGetAsync(final ApiCallback<List<Space>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.spacesGetValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Space>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call spacesIdGetCall(String id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spaces/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicSecurity"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call spacesIdGetValidateBeforeCall(String id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spacesIdGet(Async)");
        }
        Call call = this.spacesIdGetCall(id, progressListener, progressRequestListener);
        return call;
    }

    public Space spacesIdGet(String id) throws ApiException {
        ApiResponse<Space> resp = this.spacesIdGetWithHttpInfo(id);
        return resp.getData();
    }

    public ApiResponse<Space> spacesIdGetWithHttpInfo(String id) throws ApiException {
        Call call = this.spacesIdGetValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<Space>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call spacesIdGetAsync(String id, final ApiCallback<Space> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.spacesIdGetValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Space>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call spacesIdInstancesGetCall(String id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spaces/{id}/instances".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicSecurity"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call spacesIdInstancesGetValidateBeforeCall(String id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spacesIdInstancesGet(Async)");
        }
        Call call = this.spacesIdInstancesGetCall(id, progressListener, progressRequestListener);
        return call;
    }

    public List<SpaceInstance> spacesIdInstancesGet(String id) throws ApiException {
        ApiResponse<List<SpaceInstance>> resp = this.spacesIdInstancesGetWithHttpInfo(id);
        return resp.getData();
    }

    public ApiResponse<List<SpaceInstance>> spacesIdInstancesGetWithHttpInfo(String id) throws ApiException {
        Call call = this.spacesIdInstancesGetValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<List<SpaceInstance>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call spacesIdInstancesGetAsync(String id, final ApiCallback<List<SpaceInstance>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.spacesIdInstancesGetValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<SpaceInstance>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call spacesIdInstancesInstanceIdDemotePostCall(String id, String instanceId, String maxSuspendTime, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spaces/{id}/instances/{instanceId}/demote".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString())).replaceAll("\\{instanceId\\}", this.apiClient.escapeString(instanceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (maxSuspendTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("maxSuspendTime", maxSuspendTime));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicSecurity"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call spacesIdInstancesInstanceIdDemotePostValidateBeforeCall(String id, String instanceId, String maxSuspendTime, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spacesIdInstancesInstanceIdDemotePost(Async)");
        }
        if (instanceId == null) {
            throw new ApiException("Missing the required parameter 'instanceId' when calling spacesIdInstancesInstanceIdDemotePost(Async)");
        }
        Call call = this.spacesIdInstancesInstanceIdDemotePostCall(id, instanceId, maxSuspendTime, progressListener, progressRequestListener);
        return call;
    }

    public String spacesIdInstancesInstanceIdDemotePost(String id, String instanceId, String maxSuspendTime) throws ApiException {
        ApiResponse<String> resp = this.spacesIdInstancesInstanceIdDemotePostWithHttpInfo(id, instanceId, maxSuspendTime);
        return resp.getData();
    }

    public ApiResponse<String> spacesIdInstancesInstanceIdDemotePostWithHttpInfo(String id, String instanceId, String maxSuspendTime) throws ApiException {
        Call call = this.spacesIdInstancesInstanceIdDemotePostValidateBeforeCall(id, instanceId, maxSuspendTime, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call spacesIdInstancesInstanceIdDemotePostAsync(String id, String instanceId, String maxSuspendTime, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.spacesIdInstancesInstanceIdDemotePostValidateBeforeCall(id, instanceId, maxSuspendTime, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call spacesIdInstancesInstanceIdGetCall(String id, String instanceId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spaces/{id}/instances/{instanceId}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString())).replaceAll("\\{instanceId\\}", this.apiClient.escapeString(instanceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicSecurity"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call spacesIdInstancesInstanceIdGetValidateBeforeCall(String id, String instanceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spacesIdInstancesInstanceIdGet(Async)");
        }
        if (instanceId == null) {
            throw new ApiException("Missing the required parameter 'instanceId' when calling spacesIdInstancesInstanceIdGet(Async)");
        }
        Call call = this.spacesIdInstancesInstanceIdGetCall(id, instanceId, progressListener, progressRequestListener);
        return call;
    }

    public SpaceInstance spacesIdInstancesInstanceIdGet(String id, String instanceId) throws ApiException {
        ApiResponse<SpaceInstance> resp = this.spacesIdInstancesInstanceIdGetWithHttpInfo(id, instanceId);
        return resp.getData();
    }

    public ApiResponse<SpaceInstance> spacesIdInstancesInstanceIdGetWithHttpInfo(String id, String instanceId) throws ApiException {
        Call call = this.spacesIdInstancesInstanceIdGetValidateBeforeCall(id, instanceId, null, null);
        Type localVarReturnType = new TypeToken<SpaceInstance>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call spacesIdInstancesInstanceIdGetAsync(String id, String instanceId, final ApiCallback<SpaceInstance> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.spacesIdInstancesInstanceIdGetValidateBeforeCall(id, instanceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SpaceInstance>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call spacesIdInstancesInstanceIdQueryGetCall(String id, String instanceId, String typeName, String filter, List<String> columns, Integer maxResults, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spaces/{id}/instances/{instanceId}/query".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString())).replaceAll("\\{instanceId\\}", this.apiClient.escapeString(instanceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (typeName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("typeName", typeName));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", filter));
        }
        if (columns != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "columns", columns));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicSecurity"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call spacesIdInstancesInstanceIdQueryGetValidateBeforeCall(String id, String instanceId, String typeName, String filter, List<String> columns, Integer maxResults, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spacesIdInstancesInstanceIdQueryGet(Async)");
        }
        if (instanceId == null) {
            throw new ApiException("Missing the required parameter 'instanceId' when calling spacesIdInstancesInstanceIdQueryGet(Async)");
        }
        if (typeName == null) {
            throw new ApiException("Missing the required parameter 'typeName' when calling spacesIdInstancesInstanceIdQueryGet(Async)");
        }
        Call call = this.spacesIdInstancesInstanceIdQueryGetCall(id, instanceId, typeName, filter, columns, maxResults, progressListener, progressRequestListener);
        return call;
    }

    public SpaceQueryResult spacesIdInstancesInstanceIdQueryGet(String id, String instanceId, String typeName, String filter, List<String> columns, Integer maxResults) throws ApiException {
        ApiResponse<SpaceQueryResult> resp = this.spacesIdInstancesInstanceIdQueryGetWithHttpInfo(id, instanceId, typeName, filter, columns, maxResults);
        return resp.getData();
    }

    public ApiResponse<SpaceQueryResult> spacesIdInstancesInstanceIdQueryGetWithHttpInfo(String id, String instanceId, String typeName, String filter, List<String> columns, Integer maxResults) throws ApiException {
        Call call = this.spacesIdInstancesInstanceIdQueryGetValidateBeforeCall(id, instanceId, typeName, filter, columns, maxResults, null, null);
        Type localVarReturnType = new TypeToken<SpaceQueryResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call spacesIdInstancesInstanceIdQueryGetAsync(String id, String instanceId, String typeName, String filter, List<String> columns, Integer maxResults, final ApiCallback<SpaceQueryResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.spacesIdInstancesInstanceIdQueryGetValidateBeforeCall(id, instanceId, typeName, filter, columns, maxResults, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SpaceQueryResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call spacesIdInstancesInstanceIdStatisticsOperationsGetCall(String id, String instanceId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spaces/{id}/instances/{instanceId}/statistics/operations".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString())).replaceAll("\\{instanceId\\}", this.apiClient.escapeString(instanceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicSecurity"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call spacesIdInstancesInstanceIdStatisticsOperationsGetValidateBeforeCall(String id, String instanceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spacesIdInstancesInstanceIdStatisticsOperationsGet(Async)");
        }
        if (instanceId == null) {
            throw new ApiException("Missing the required parameter 'instanceId' when calling spacesIdInstancesInstanceIdStatisticsOperationsGet(Async)");
        }
        Call call = this.spacesIdInstancesInstanceIdStatisticsOperationsGetCall(id, instanceId, progressListener, progressRequestListener);
        return call;
    }

    public SpaceInstanceOperationsStatistics spacesIdInstancesInstanceIdStatisticsOperationsGet(String id, String instanceId) throws ApiException {
        ApiResponse<SpaceInstanceOperationsStatistics> resp = this.spacesIdInstancesInstanceIdStatisticsOperationsGetWithHttpInfo(id, instanceId);
        return resp.getData();
    }

    public ApiResponse<SpaceInstanceOperationsStatistics> spacesIdInstancesInstanceIdStatisticsOperationsGetWithHttpInfo(String id, String instanceId) throws ApiException {
        Call call = this.spacesIdInstancesInstanceIdStatisticsOperationsGetValidateBeforeCall(id, instanceId, null, null);
        Type localVarReturnType = new TypeToken<SpaceInstanceOperationsStatistics>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call spacesIdInstancesInstanceIdStatisticsOperationsGetAsync(String id, String instanceId, final ApiCallback<SpaceInstanceOperationsStatistics> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.spacesIdInstancesInstanceIdStatisticsOperationsGetValidateBeforeCall(id, instanceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SpaceInstanceOperationsStatistics>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call spacesIdInstancesInstanceIdStatisticsReplicationGetCall(String id, String instanceId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spaces/{id}/instances/{instanceId}/statistics/replication".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString())).replaceAll("\\{instanceId\\}", this.apiClient.escapeString(instanceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicSecurity"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call spacesIdInstancesInstanceIdStatisticsReplicationGetValidateBeforeCall(String id, String instanceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spacesIdInstancesInstanceIdStatisticsReplicationGet(Async)");
        }
        if (instanceId == null) {
            throw new ApiException("Missing the required parameter 'instanceId' when calling spacesIdInstancesInstanceIdStatisticsReplicationGet(Async)");
        }
        Call call = this.spacesIdInstancesInstanceIdStatisticsReplicationGetCall(id, instanceId, progressListener, progressRequestListener);
        return call;
    }

    public SpaceInstanceReplicationStatistics spacesIdInstancesInstanceIdStatisticsReplicationGet(String id, String instanceId) throws ApiException {
        ApiResponse<SpaceInstanceReplicationStatistics> resp = this.spacesIdInstancesInstanceIdStatisticsReplicationGetWithHttpInfo(id, instanceId);
        return resp.getData();
    }

    public ApiResponse<SpaceInstanceReplicationStatistics> spacesIdInstancesInstanceIdStatisticsReplicationGetWithHttpInfo(String id, String instanceId) throws ApiException {
        Call call = this.spacesIdInstancesInstanceIdStatisticsReplicationGetValidateBeforeCall(id, instanceId, null, null);
        Type localVarReturnType = new TypeToken<SpaceInstanceReplicationStatistics>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call spacesIdInstancesInstanceIdStatisticsReplicationGetAsync(String id, String instanceId, final ApiCallback<SpaceInstanceReplicationStatistics> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.spacesIdInstancesInstanceIdStatisticsReplicationGetValidateBeforeCall(id, instanceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SpaceInstanceReplicationStatistics>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call spacesIdInstancesInstanceIdStatisticsTypesGetCall(String id, String instanceId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spaces/{id}/instances/{instanceId}/statistics/types".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString())).replaceAll("\\{instanceId\\}", this.apiClient.escapeString(instanceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicSecurity"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call spacesIdInstancesInstanceIdStatisticsTypesGetValidateBeforeCall(String id, String instanceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spacesIdInstancesInstanceIdStatisticsTypesGet(Async)");
        }
        if (instanceId == null) {
            throw new ApiException("Missing the required parameter 'instanceId' when calling spacesIdInstancesInstanceIdStatisticsTypesGet(Async)");
        }
        Call call = this.spacesIdInstancesInstanceIdStatisticsTypesGetCall(id, instanceId, progressListener, progressRequestListener);
        return call;
    }

    public SpaceInstanceTypesStatistics spacesIdInstancesInstanceIdStatisticsTypesGet(String id, String instanceId) throws ApiException {
        ApiResponse<SpaceInstanceTypesStatistics> resp = this.spacesIdInstancesInstanceIdStatisticsTypesGetWithHttpInfo(id, instanceId);
        return resp.getData();
    }

    public ApiResponse<SpaceInstanceTypesStatistics> spacesIdInstancesInstanceIdStatisticsTypesGetWithHttpInfo(String id, String instanceId) throws ApiException {
        Call call = this.spacesIdInstancesInstanceIdStatisticsTypesGetValidateBeforeCall(id, instanceId, null, null);
        Type localVarReturnType = new TypeToken<SpaceInstanceTypesStatistics>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call spacesIdInstancesInstanceIdStatisticsTypesGetAsync(String id, String instanceId, final ApiCallback<SpaceInstanceTypesStatistics> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.spacesIdInstancesInstanceIdStatisticsTypesGetValidateBeforeCall(id, instanceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SpaceInstanceTypesStatistics>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call spacesIdQueryGetCall(String id, String typeName, String filter, List<String> columns, Integer maxResults, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spaces/{id}/query".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (typeName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("typeName", typeName));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", filter));
        }
        if (columns != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "columns", columns));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicSecurity"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call spacesIdQueryGetValidateBeforeCall(String id, String typeName, String filter, List<String> columns, Integer maxResults, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spacesIdQueryGet(Async)");
        }
        if (typeName == null) {
            throw new ApiException("Missing the required parameter 'typeName' when calling spacesIdQueryGet(Async)");
        }
        Call call = this.spacesIdQueryGetCall(id, typeName, filter, columns, maxResults, progressListener, progressRequestListener);
        return call;
    }

    public SpaceQueryResult spacesIdQueryGet(String id, String typeName, String filter, List<String> columns, Integer maxResults) throws ApiException {
        ApiResponse<SpaceQueryResult> resp = this.spacesIdQueryGetWithHttpInfo(id, typeName, filter, columns, maxResults);
        return resp.getData();
    }

    public ApiResponse<SpaceQueryResult> spacesIdQueryGetWithHttpInfo(String id, String typeName, String filter, List<String> columns, Integer maxResults) throws ApiException {
        Call call = this.spacesIdQueryGetValidateBeforeCall(id, typeName, filter, columns, maxResults, null, null);
        Type localVarReturnType = new TypeToken<SpaceQueryResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call spacesIdQueryGetAsync(String id, String typeName, String filter, List<String> columns, Integer maxResults, final ApiCallback<SpaceQueryResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.spacesIdQueryGetValidateBeforeCall(id, typeName, filter, columns, maxResults, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SpaceQueryResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call spacesIdStatisticsOperationsGetCall(String id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spaces/{id}/statistics/operations".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicSecurity"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call spacesIdStatisticsOperationsGetValidateBeforeCall(String id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spacesIdStatisticsOperationsGet(Async)");
        }
        Call call = this.spacesIdStatisticsOperationsGetCall(id, progressListener, progressRequestListener);
        return call;
    }

    public SpaceOperationsStatistics spacesIdStatisticsOperationsGet(String id) throws ApiException {
        ApiResponse<SpaceOperationsStatistics> resp = this.spacesIdStatisticsOperationsGetWithHttpInfo(id);
        return resp.getData();
    }

    public ApiResponse<SpaceOperationsStatistics> spacesIdStatisticsOperationsGetWithHttpInfo(String id) throws ApiException {
        Call call = this.spacesIdStatisticsOperationsGetValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<SpaceOperationsStatistics>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call spacesIdStatisticsOperationsGetAsync(String id, final ApiCallback<SpaceOperationsStatistics> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.spacesIdStatisticsOperationsGetValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SpaceOperationsStatistics>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call spacesIdStatisticsTypesGetCall(String id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spaces/{id}/statistics/types".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicSecurity"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call spacesIdStatisticsTypesGetValidateBeforeCall(String id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spacesIdStatisticsTypesGet(Async)");
        }
        Call call = this.spacesIdStatisticsTypesGetCall(id, progressListener, progressRequestListener);
        return call;
    }

    public SpaceTypesStatistics spacesIdStatisticsTypesGet(String id) throws ApiException {
        ApiResponse<SpaceTypesStatistics> resp = this.spacesIdStatisticsTypesGetWithHttpInfo(id);
        return resp.getData();
    }

    public ApiResponse<SpaceTypesStatistics> spacesIdStatisticsTypesGetWithHttpInfo(String id) throws ApiException {
        Call call = this.spacesIdStatisticsTypesGetValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<SpaceTypesStatistics>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call spacesIdStatisticsTypesGetAsync(String id, final ApiCallback<SpaceTypesStatistics> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.spacesIdStatisticsTypesGetValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SpaceTypesStatistics>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call spacesPostCall(String name, Integer partitions, Boolean backups, Boolean requiresIsolation, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spaces";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (name != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        }
        if (partitions != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("partitions", partitions));
        }
        if (backups != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("backups", backups));
        }
        if (requiresIsolation != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("requiresIsolation", requiresIsolation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BasicSecurity"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call spacesPostValidateBeforeCall(String name, Integer partitions, Boolean backups, Boolean requiresIsolation, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling spacesPost(Async)");
        }
        Call call = this.spacesPostCall(name, partitions, backups, requiresIsolation, progressListener, progressRequestListener);
        return call;
    }

    public String spacesPost(String name, Integer partitions, Boolean backups, Boolean requiresIsolation) throws ApiException {
        ApiResponse<String> resp = this.spacesPostWithHttpInfo(name, partitions, backups, requiresIsolation);
        return resp.getData();
    }

    public ApiResponse<String> spacesPostWithHttpInfo(String name, Integer partitions, Boolean backups, Boolean requiresIsolation) throws ApiException {
        Call call = this.spacesPostValidateBeforeCall(name, partitions, backups, requiresIsolation, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call spacesPostAsync(String name, Integer partitions, Boolean backups, Boolean requiresIsolation, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.spacesPostValidateBeforeCall(name, partitions, backups, requiresIsolation, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

