/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.rest.client.java.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class JvmStatistics {
    @SerializedName(value="timestamp")
    private Long timestamp = null;
    @SerializedName(value="uptime")
    private Long uptime = null;
    @SerializedName(value="memoryHeapCommittedInBytes")
    private Long memoryHeapCommittedInBytes = null;
    @SerializedName(value="memoryHeapUsedInBytes")
    private Long memoryHeapUsedInBytes = null;
    @SerializedName(value="memoryNonHeapCommittedInBytes")
    private Long memoryNonHeapCommittedInBytes = null;
    @SerializedName(value="memoryNonHeapUsedInBytes")
    private Long memoryNonHeapUsedInBytes = null;
    @SerializedName(value="threadCount")
    private Integer threadCount = null;
    @SerializedName(value="peakThreadCount")
    private Integer peakThreadCount = null;
    @SerializedName(value="gcCount")
    private Long gcCount = null;
    @SerializedName(value="gcTime")
    private Long gcTime = null;

    public JvmStatistics timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(required=true, value="timestamp when the statistics were taken")
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public JvmStatistics uptime(Long uptime) {
        this.uptime = uptime;
        return this;
    }

    @ApiModelProperty(required=true, value="uptime of this virtual machine (in milliseconds)")
    public Long getUptime() {
        return this.uptime;
    }

    public void setUptime(Long uptime) {
        this.uptime = uptime;
    }

    public JvmStatistics memoryHeapCommittedInBytes(Long memoryHeapCommittedInBytes) {
        this.memoryHeapCommittedInBytes = memoryHeapCommittedInBytes;
        return this;
    }

    @ApiModelProperty(required=true, value="amount of committed heap memory in bytes")
    public Long getMemoryHeapCommittedInBytes() {
        return this.memoryHeapCommittedInBytes;
    }

    public void setMemoryHeapCommittedInBytes(Long memoryHeapCommittedInBytes) {
        this.memoryHeapCommittedInBytes = memoryHeapCommittedInBytes;
    }

    public JvmStatistics memoryHeapUsedInBytes(Long memoryHeapUsedInBytes) {
        this.memoryHeapUsedInBytes = memoryHeapUsedInBytes;
        return this;
    }

    @ApiModelProperty(required=true, value="amount of used heap memory in bytes")
    public Long getMemoryHeapUsedInBytes() {
        return this.memoryHeapUsedInBytes;
    }

    public void setMemoryHeapUsedInBytes(Long memoryHeapUsedInBytes) {
        this.memoryHeapUsedInBytes = memoryHeapUsedInBytes;
    }

    public JvmStatistics memoryNonHeapCommittedInBytes(Long memoryNonHeapCommittedInBytes) {
        this.memoryNonHeapCommittedInBytes = memoryNonHeapCommittedInBytes;
        return this;
    }

    @ApiModelProperty(required=true, value="amount of committed non-heap memory in bytes")
    public Long getMemoryNonHeapCommittedInBytes() {
        return this.memoryNonHeapCommittedInBytes;
    }

    public void setMemoryNonHeapCommittedInBytes(Long memoryNonHeapCommittedInBytes) {
        this.memoryNonHeapCommittedInBytes = memoryNonHeapCommittedInBytes;
    }

    public JvmStatistics memoryNonHeapUsedInBytes(Long memoryNonHeapUsedInBytes) {
        this.memoryNonHeapUsedInBytes = memoryNonHeapUsedInBytes;
        return this;
    }

    @ApiModelProperty(required=true, value="amount of used non-heap memory in bytes")
    public Long getMemoryNonHeapUsedInBytes() {
        return this.memoryNonHeapUsedInBytes;
    }

    public void setMemoryNonHeapUsedInBytes(Long memoryNonHeapUsedInBytes) {
        this.memoryNonHeapUsedInBytes = memoryNonHeapUsedInBytes;
    }

    public JvmStatistics threadCount(Integer threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    @ApiModelProperty(required=true, value="current number of live threads in this virtual machine (including both daemon and non-daemon threads)")
    public Integer getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(Integer threadCount) {
        this.threadCount = threadCount;
    }

    public JvmStatistics peakThreadCount(Integer peakThreadCount) {
        this.peakThreadCount = peakThreadCount;
        return this;
    }

    @ApiModelProperty(required=true, value="peak live thread count since this virtual machine started (or peak was reset)")
    public Integer getPeakThreadCount() {
        return this.peakThreadCount;
    }

    public void setPeakThreadCount(Integer peakThreadCount) {
        this.peakThreadCount = peakThreadCount;
    }

    public JvmStatistics gcCount(Long gcCount) {
        this.gcCount = gcCount;
        return this;
    }

    @ApiModelProperty(required=true, value="total number of garbage collections that have occurred in this virtual machine")
    public Long getGcCount() {
        return this.gcCount;
    }

    public void setGcCount(Long gcCount) {
        this.gcCount = gcCount;
    }

    public JvmStatistics gcTime(Long gcTime) {
        this.gcTime = gcTime;
        return this;
    }

    @ApiModelProperty(required=true, value="approximate accumulated garbage collection elapsed time (in milliseconds) in this virtual machine")
    public Long getGcTime() {
        return this.gcTime;
    }

    public void setGcTime(Long gcTime) {
        this.gcTime = gcTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JvmStatistics jvmStatistics = (JvmStatistics)o;
        return Objects.equals(this.timestamp, jvmStatistics.timestamp) && Objects.equals(this.uptime, jvmStatistics.uptime) && Objects.equals(this.memoryHeapCommittedInBytes, jvmStatistics.memoryHeapCommittedInBytes) && Objects.equals(this.memoryHeapUsedInBytes, jvmStatistics.memoryHeapUsedInBytes) && Objects.equals(this.memoryNonHeapCommittedInBytes, jvmStatistics.memoryNonHeapCommittedInBytes) && Objects.equals(this.memoryNonHeapUsedInBytes, jvmStatistics.memoryNonHeapUsedInBytes) && Objects.equals(this.threadCount, jvmStatistics.threadCount) && Objects.equals(this.peakThreadCount, jvmStatistics.peakThreadCount) && Objects.equals(this.gcCount, jvmStatistics.gcCount) && Objects.equals(this.gcTime, jvmStatistics.gcTime);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.uptime, this.memoryHeapCommittedInBytes, this.memoryHeapUsedInBytes, this.memoryNonHeapCommittedInBytes, this.memoryNonHeapUsedInBytes, this.threadCount, this.peakThreadCount, this.gcCount, this.gcTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JvmStatistics {\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    uptime: ").append(this.toIndentedString(this.uptime)).append("\n");
        sb.append("    memoryHeapCommittedInBytes: ").append(this.toIndentedString(this.memoryHeapCommittedInBytes)).append("\n");
        sb.append("    memoryHeapUsedInBytes: ").append(this.toIndentedString(this.memoryHeapUsedInBytes)).append("\n");
        sb.append("    memoryNonHeapCommittedInBytes: ").append(this.toIndentedString(this.memoryNonHeapCommittedInBytes)).append("\n");
        sb.append("    memoryNonHeapUsedInBytes: ").append(this.toIndentedString(this.memoryNonHeapUsedInBytes)).append("\n");
        sb.append("    threadCount: ").append(this.toIndentedString(this.threadCount)).append("\n");
        sb.append("    peakThreadCount: ").append(this.toIndentedString(this.peakThreadCount)).append("\n");
        sb.append("    gcCount: ").append(this.toIndentedString(this.gcCount)).append("\n");
        sb.append("    gcTime: ").append(this.toIndentedString(this.gcTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

