/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.rest.client.java.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class OperatingSystemStatistics {
    @SerializedName(value="timestamp")
    private Long timestamp = null;
    @SerializedName(value="adminTimestamp")
    private Long adminTimestamp = null;
    @SerializedName(value="freeSwapSpaceSizeInBytes")
    private Long freeSwapSpaceSizeInBytes = null;
    @SerializedName(value="freePhysicalMemorySizeInBytes")
    private Long freePhysicalMemorySizeInBytes = null;
    @SerializedName(value="actualFreePhysicalMemorySizeInBytes")
    private Long actualFreePhysicalMemorySizeInBytes = null;
    @SerializedName(value="physicalMemoryUsedPerc")
    private Double physicalMemoryUsedPerc = null;
    @SerializedName(value="cpuPerc")
    private Double cpuPerc = null;
    @SerializedName(value="cpuPercFormatted")
    private String cpuPercFormatted = null;
    @SerializedName(value="actualMemoryUsed")
    private Long actualMemoryUsed = null;

    public OperatingSystemStatistics timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(required=true, value="The timestamp when the statistics were take")
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public OperatingSystemStatistics adminTimestamp(Long adminTimestamp) {
        this.adminTimestamp = adminTimestamp;
        return this;
    }

    @ApiModelProperty(required=true, value="The timestamp that is in sync with where the admin API is running. Can return -1 if the clocks have not sync yet")
    public Long getAdminTimestamp() {
        return this.adminTimestamp;
    }

    public void setAdminTimestamp(Long adminTimestamp) {
        this.adminTimestamp = adminTimestamp;
    }

    public OperatingSystemStatistics freeSwapSpaceSizeInBytes(Long freeSwapSpaceSizeInBytes) {
        this.freeSwapSpaceSizeInBytes = freeSwapSpaceSizeInBytes;
        return this;
    }

    @ApiModelProperty(required=true, value="Free swap space in bytes")
    public Long getFreeSwapSpaceSizeInBytes() {
        return this.freeSwapSpaceSizeInBytes;
    }

    public void setFreeSwapSpaceSizeInBytes(Long freeSwapSpaceSizeInBytes) {
        this.freeSwapSpaceSizeInBytes = freeSwapSpaceSizeInBytes;
    }

    public OperatingSystemStatistics freePhysicalMemorySizeInBytes(Long freePhysicalMemorySizeInBytes) {
        this.freePhysicalMemorySizeInBytes = freePhysicalMemorySizeInBytes;
        return this;
    }

    @ApiModelProperty(required=true, value="Free physical memory in bytes")
    public Long getFreePhysicalMemorySizeInBytes() {
        return this.freePhysicalMemorySizeInBytes;
    }

    public void setFreePhysicalMemorySizeInBytes(Long freePhysicalMemorySizeInBytes) {
        this.freePhysicalMemorySizeInBytes = freePhysicalMemorySizeInBytes;
    }

    public OperatingSystemStatistics actualFreePhysicalMemorySizeInBytes(Long actualFreePhysicalMemorySizeInBytes) {
        this.actualFreePhysicalMemorySizeInBytes = actualFreePhysicalMemorySizeInBytes;
        return this;
    }

    @ApiModelProperty(required=true, value="Actual free physical memory in bytes")
    public Long getActualFreePhysicalMemorySizeInBytes() {
        return this.actualFreePhysicalMemorySizeInBytes;
    }

    public void setActualFreePhysicalMemorySizeInBytes(Long actualFreePhysicalMemorySizeInBytes) {
        this.actualFreePhysicalMemorySizeInBytes = actualFreePhysicalMemorySizeInBytes;
    }

    public OperatingSystemStatistics physicalMemoryUsedPerc(Double physicalMemoryUsedPerc) {
        this.physicalMemoryUsedPerc = physicalMemoryUsedPerc;
        return this;
    }

    @ApiModelProperty(required=true, value="The percentage used of physical memory out of the total physical memory space. Uses the total free memory e.g. e.g. Linux plus cached")
    public Double getPhysicalMemoryUsedPerc() {
        return this.physicalMemoryUsedPerc;
    }

    public void setPhysicalMemoryUsedPerc(Double physicalMemoryUsedPerc) {
        this.physicalMemoryUsedPerc = physicalMemoryUsedPerc;
    }

    public OperatingSystemStatistics cpuPerc(Double cpuPerc) {
        this.cpuPerc = cpuPerc;
        return this;
    }

    @ApiModelProperty(required=true, value="The combined cpu perc (User + Sys + Nice + Wait)")
    public Double getCpuPerc() {
        return this.cpuPerc;
    }

    public void setCpuPerc(Double cpuPerc) {
        this.cpuPerc = cpuPerc;
    }

    public OperatingSystemStatistics cpuPercFormatted(String cpuPercFormatted) {
        this.cpuPercFormatted = cpuPercFormatted;
        return this;
    }

    @ApiModelProperty(required=true, value="The combined cpu formatted")
    public String getCpuPercFormatted() {
        return this.cpuPercFormatted;
    }

    public void setCpuPercFormatted(String cpuPercFormatted) {
        this.cpuPercFormatted = cpuPercFormatted;
    }

    public OperatingSystemStatistics actualMemoryUsed(Long actualMemoryUsed) {
        this.actualMemoryUsed = actualMemoryUsed;
        return this;
    }

    @ApiModelProperty(required=true, value="Actual Memory Used, in bytes")
    public Long getActualMemoryUsed() {
        return this.actualMemoryUsed;
    }

    public void setActualMemoryUsed(Long actualMemoryUsed) {
        this.actualMemoryUsed = actualMemoryUsed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatingSystemStatistics operatingSystemStatistics = (OperatingSystemStatistics)o;
        return Objects.equals(this.timestamp, operatingSystemStatistics.timestamp) && Objects.equals(this.adminTimestamp, operatingSystemStatistics.adminTimestamp) && Objects.equals(this.freeSwapSpaceSizeInBytes, operatingSystemStatistics.freeSwapSpaceSizeInBytes) && Objects.equals(this.freePhysicalMemorySizeInBytes, operatingSystemStatistics.freePhysicalMemorySizeInBytes) && Objects.equals(this.actualFreePhysicalMemorySizeInBytes, operatingSystemStatistics.actualFreePhysicalMemorySizeInBytes) && Objects.equals(this.physicalMemoryUsedPerc, operatingSystemStatistics.physicalMemoryUsedPerc) && Objects.equals(this.cpuPerc, operatingSystemStatistics.cpuPerc) && Objects.equals(this.cpuPercFormatted, operatingSystemStatistics.cpuPercFormatted) && Objects.equals(this.actualMemoryUsed, operatingSystemStatistics.actualMemoryUsed);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.adminTimestamp, this.freeSwapSpaceSizeInBytes, this.freePhysicalMemorySizeInBytes, this.actualFreePhysicalMemorySizeInBytes, this.physicalMemoryUsedPerc, this.cpuPerc, this.cpuPercFormatted, this.actualMemoryUsed);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperatingSystemStatistics {\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    adminTimestamp: ").append(this.toIndentedString(this.adminTimestamp)).append("\n");
        sb.append("    freeSwapSpaceSizeInBytes: ").append(this.toIndentedString(this.freeSwapSpaceSizeInBytes)).append("\n");
        sb.append("    freePhysicalMemorySizeInBytes: ").append(this.toIndentedString(this.freePhysicalMemorySizeInBytes)).append("\n");
        sb.append("    actualFreePhysicalMemorySizeInBytes: ").append(this.toIndentedString(this.actualFreePhysicalMemorySizeInBytes)).append("\n");
        sb.append("    physicalMemoryUsedPerc: ").append(this.toIndentedString(this.physicalMemoryUsedPerc)).append("\n");
        sb.append("    cpuPerc: ").append(this.toIndentedString(this.cpuPerc)).append("\n");
        sb.append("    cpuPercFormatted: ").append(this.toIndentedString(this.cpuPercFormatted)).append("\n");
        sb.append("    actualMemoryUsed: ").append(this.toIndentedString(this.actualMemoryUsed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

