/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.rest.client.java.model;

import com.gigaspaces.rest.client.java.model.ProcessingUnitSLA;
import com.gigaspaces.rest.client.java.model.ProcessingUnitTopology;
import com.gigaspaces.rest.client.java.model.QuiesceDetails;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ProcessingUnit {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="processingUnitType")
    private ProcessingUnitTypeEnum processingUnitType = null;
    @SerializedName(value="resource")
    private String resource = null;
    @SerializedName(value="topology")
    private ProcessingUnitTopology topology = null;
    @SerializedName(value="sla")
    private ProcessingUnitSLA sla = null;
    @SerializedName(value="spaces")
    private List<String> spaces = new ArrayList<String>();
    @SerializedName(value="scalable")
    private Boolean scalable = null;
    @SerializedName(value="status")
    private StatusEnum status = null;
    @SerializedName(value="quiesceDetails")
    private QuiesceDetails quiesceDetails = null;
    @SerializedName(value="instances")
    private List<String> instances = new ArrayList<String>();

    public ProcessingUnit name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="ProcessingUnit name (unique)")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProcessingUnit processingUnitType(ProcessingUnitTypeEnum processingUnitType) {
        this.processingUnitType = processingUnitType;
        return this;
    }

    @ApiModelProperty(required=true, value="ProcessingUnit type")
    public ProcessingUnitTypeEnum getProcessingUnitType() {
        return this.processingUnitType;
    }

    public void setProcessingUnitType(ProcessingUnitTypeEnum processingUnitType) {
        this.processingUnitType = processingUnitType;
    }

    public ProcessingUnit resource(String resource) {
        this.resource = resource;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of resource which contains binary files for processing unit (see /pus/resources)")
    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public ProcessingUnit topology(ProcessingUnitTopology topology) {
        this.topology = topology;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ProcessingUnitTopology getTopology() {
        return this.topology;
    }

    public void setTopology(ProcessingUnitTopology topology) {
        this.topology = topology;
    }

    public ProcessingUnit sla(ProcessingUnitSLA sla) {
        this.sla = sla;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ProcessingUnitSLA getSla() {
        return this.sla;
    }

    public void setSla(ProcessingUnitSLA sla) {
        this.sla = sla;
    }

    public ProcessingUnit spaces(List<String> spaces) {
        this.spaces = spaces;
        return this;
    }

    public ProcessingUnit addSpacesItem(String spacesItem) {
        this.spaces.add(spacesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The names of spaces which were deployed within this processing unit")
    public List<String> getSpaces() {
        return this.spaces;
    }

    public void setSpaces(List<String> spaces) {
        this.spaces = spaces;
    }

    public ProcessingUnit scalable(Boolean scalable) {
        this.scalable = scalable;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates if instances can be incremented/decremented on this processing unit")
    public Boolean isScalable() {
        return this.scalable;
    }

    public void setScalable(Boolean scalable) {
        this.scalable = scalable;
    }

    public ProcessingUnit status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="Processing unit status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ProcessingUnit quiesceDetails(QuiesceDetails quiesceDetails) {
        this.quiesceDetails = quiesceDetails;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public QuiesceDetails getQuiesceDetails() {
        return this.quiesceDetails;
    }

    public void setQuiesceDetails(QuiesceDetails quiesceDetails) {
        this.quiesceDetails = quiesceDetails;
    }

    public ProcessingUnit instances(List<String> instances) {
        this.instances = instances;
        return this;
    }

    public ProcessingUnit addInstancesItem(String instancesItem) {
        this.instances.add(instancesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of this processing unit's active instances")
    public List<String> getInstances() {
        return this.instances;
    }

    public void setInstances(List<String> instances) {
        this.instances = instances;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessingUnit processingUnit = (ProcessingUnit)o;
        return Objects.equals(this.name, processingUnit.name) && Objects.equals((Object)this.processingUnitType, (Object)processingUnit.processingUnitType) && Objects.equals(this.resource, processingUnit.resource) && Objects.equals(this.topology, processingUnit.topology) && Objects.equals(this.sla, processingUnit.sla) && Objects.equals(this.spaces, processingUnit.spaces) && Objects.equals(this.scalable, processingUnit.scalable) && Objects.equals((Object)this.status, (Object)processingUnit.status) && Objects.equals(this.quiesceDetails, processingUnit.quiesceDetails) && Objects.equals(this.instances, processingUnit.instances);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.processingUnitType, this.resource, this.topology, this.sla, this.spaces, this.scalable, this.status, this.quiesceDetails, this.instances});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessingUnit {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    processingUnitType: ").append(this.toIndentedString((Object)this.processingUnitType)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    topology: ").append(this.toIndentedString(this.topology)).append("\n");
        sb.append("    sla: ").append(this.toIndentedString(this.sla)).append("\n");
        sb.append("    spaces: ").append(this.toIndentedString(this.spaces)).append("\n");
        sb.append("    scalable: ").append(this.toIndentedString(this.scalable)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    quiesceDetails: ").append(this.toIndentedString(this.quiesceDetails)).append("\n");
        sb.append("    instances: ").append(this.toIndentedString(this.instances)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        NA("NA"),
        UNDEPLOYED("undeployed"),
        SCHEDULED("scheduled"),
        DEPLOYED("deployed"),
        BROKEN("broken"),
        COMPROMISED("compromised"),
        INTACT("intact");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ProcessingUnitTypeEnum {
        UNKNOWN("unknown"),
        STATELESS("stateless"),
        STATEFUL("stateful"),
        MIRROR("mirror"),
        WEB("web"),
        UNIVERSAL("universal"),
        GATEWAY("gateway");

        private String value;

        private ProcessingUnitTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ProcessingUnitTypeEnum fromValue(String text) {
            for (ProcessingUnitTypeEnum b : ProcessingUnitTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ProcessingUnitTypeEnum> {
            public void write(JsonWriter jsonWriter, ProcessingUnitTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ProcessingUnitTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ProcessingUnitTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

