/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.rest.client.java.model;

import com.gigaspaces.rest.client.java.model.ProcessingUnitSLA;
import com.gigaspaces.rest.client.java.model.ProcessingUnitTopology;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ProcessingUnitRequest {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="resource")
    private String resource = null;
    @SerializedName(value="topology")
    private ProcessingUnitTopology topology = null;
    @SerializedName(value="sla")
    private ProcessingUnitSLA sla = null;
    @SerializedName(value="contextProperties")
    private Map<String, String> contextProperties = null;

    public ProcessingUnitRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Procesing unit unique name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProcessingUnitRequest resource(String resource) {
        this.resource = resource;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of resource which contains binary files for processing unit (see /pus/resources)")
    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public ProcessingUnitRequest topology(ProcessingUnitTopology topology) {
        this.topology = topology;
        return this;
    }

    @ApiModelProperty(value="")
    public ProcessingUnitTopology getTopology() {
        return this.topology;
    }

    public void setTopology(ProcessingUnitTopology topology) {
        this.topology = topology;
    }

    public ProcessingUnitRequest sla(ProcessingUnitSLA sla) {
        this.sla = sla;
        return this;
    }

    @ApiModelProperty(value="")
    public ProcessingUnitSLA getSla() {
        return this.sla;
    }

    public void setSla(ProcessingUnitSLA sla) {
        this.sla = sla;
    }

    public ProcessingUnitRequest contextProperties(Map<String, String> contextProperties) {
        this.contextProperties = contextProperties;
        return this;
    }

    public ProcessingUnitRequest putContextPropertiesItem(String key, String contextPropertiesItem) {
        if (this.contextProperties == null) {
            this.contextProperties = new HashMap<String, String>();
        }
        this.contextProperties.put(key, contextPropertiesItem);
        return this;
    }

    @ApiModelProperty(value="Context properties (overriding properties in pu.xml)")
    public Map<String, String> getContextProperties() {
        return this.contextProperties;
    }

    public void setContextProperties(Map<String, String> contextProperties) {
        this.contextProperties = contextProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessingUnitRequest processingUnitRequest = (ProcessingUnitRequest)o;
        return Objects.equals(this.name, processingUnitRequest.name) && Objects.equals(this.resource, processingUnitRequest.resource) && Objects.equals(this.topology, processingUnitRequest.topology) && Objects.equals(this.sla, processingUnitRequest.sla) && Objects.equals(this.contextProperties, processingUnitRequest.contextProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.resource, this.topology, this.sla, this.contextProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessingUnitRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    topology: ").append(this.toIndentedString(this.topology)).append("\n");
        sb.append("    sla: ").append(this.toIndentedString(this.sla)).append("\n");
        sb.append("    contextProperties: ").append(this.toIndentedString(this.contextProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

