/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.rest.client.java.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ProcessingUnitSLA {
    @SerializedName(value="requiresIsolation")
    private Boolean requiresIsolation = null;
    @SerializedName(value="zones")
    private List<String> zones = new ArrayList<String>();
    @SerializedName(value="primaryZones")
    private List<String> primaryZones = null;
    @SerializedName(value="maxInstancesPerVM")
    private Integer maxInstancesPerVM = null;
    @SerializedName(value="maxInstancesPerMachine")
    private Integer maxInstancesPerMachine = null;

    public ProcessingUnitSLA requiresIsolation(Boolean requiresIsolation) {
        this.requiresIsolation = requiresIsolation;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates instances of this processing unit should be provisioned in an isolated container, i.e. without any other instances at the same container.")
    public Boolean isRequiresIsolation() {
        return this.requiresIsolation;
    }

    public void setRequiresIsolation(Boolean requiresIsolation) {
        this.requiresIsolation = requiresIsolation;
    }

    public ProcessingUnitSLA zones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public ProcessingUnitSLA addZonesItem(String zonesItem) {
        this.zones.add(zonesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of zones this processing unit can be provisioned within")
    public List<String> getZones() {
        return this.zones;
    }

    public void setZones(List<String> zones) {
        this.zones = zones;
    }

    public ProcessingUnitSLA primaryZones(List<String> primaryZones) {
        this.primaryZones = primaryZones;
        return this;
    }

    public ProcessingUnitSLA addPrimaryZonesItem(String primaryZonesItem) {
        if (this.primaryZones == null) {
            this.primaryZones = new ArrayList<String>();
        }
        this.primaryZones.add(primaryZonesItem);
        return this;
    }

    @ApiModelProperty(value="List of preferred zones for primary instances (applies only when Deterministic Deployment is configured)")
    public List<String> getPrimaryZones() {
        return this.primaryZones;
    }

    public void setPrimaryZones(List<String> primaryZones) {
        this.primaryZones = primaryZones;
    }

    public ProcessingUnitSLA maxInstancesPerVM(Integer maxInstancesPerVM) {
        this.maxInstancesPerVM = maxInstancesPerVM;
        return this;
    }

    @ApiModelProperty(value="Maximum instances that can be deployed per VM")
    public Integer getMaxInstancesPerVM() {
        return this.maxInstancesPerVM;
    }

    public void setMaxInstancesPerVM(Integer maxInstancesPerVM) {
        this.maxInstancesPerVM = maxInstancesPerVM;
    }

    public ProcessingUnitSLA maxInstancesPerMachine(Integer maxInstancesPerMachine) {
        this.maxInstancesPerMachine = maxInstancesPerMachine;
        return this;
    }

    @ApiModelProperty(value="Maximum instances that can be deployed per machine")
    public Integer getMaxInstancesPerMachine() {
        return this.maxInstancesPerMachine;
    }

    public void setMaxInstancesPerMachine(Integer maxInstancesPerMachine) {
        this.maxInstancesPerMachine = maxInstancesPerMachine;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessingUnitSLA processingUnitSLA = (ProcessingUnitSLA)o;
        return Objects.equals(this.requiresIsolation, processingUnitSLA.requiresIsolation) && Objects.equals(this.zones, processingUnitSLA.zones) && Objects.equals(this.primaryZones, processingUnitSLA.primaryZones) && Objects.equals(this.maxInstancesPerVM, processingUnitSLA.maxInstancesPerVM) && Objects.equals(this.maxInstancesPerMachine, processingUnitSLA.maxInstancesPerMachine);
    }

    public int hashCode() {
        return Objects.hash(this.requiresIsolation, this.zones, this.primaryZones, this.maxInstancesPerVM, this.maxInstancesPerMachine);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessingUnitSLA {\n");
        sb.append("    requiresIsolation: ").append(this.toIndentedString(this.requiresIsolation)).append("\n");
        sb.append("    zones: ").append(this.toIndentedString(this.zones)).append("\n");
        sb.append("    primaryZones: ").append(this.toIndentedString(this.primaryZones)).append("\n");
        sb.append("    maxInstancesPerVM: ").append(this.toIndentedString(this.maxInstancesPerVM)).append("\n");
        sb.append("    maxInstancesPerMachine: ").append(this.toIndentedString(this.maxInstancesPerMachine)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

