/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.rest.client.java.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class ReplicationChannelStatistics {
    @SerializedName(value="lastKeyToReplicate")
    private Long lastKeyToReplicate = null;
    @SerializedName(value="lastConfirmedKeyFromTarget")
    private Long lastConfirmedKeyFromTarget = null;
    @SerializedName(value="channelState")
    private ChannelStateEnum channelState = null;
    @SerializedName(value="replicationMode")
    private ReplicationModeEnum replicationMode = null;
    @SerializedName(value="throughput")
    private Integer throughput = null;
    @SerializedName(value="totalNumberOfReplicatedPackets")
    private Long totalNumberOfReplicatedPackets = null;
    @SerializedName(value="inconsistencyReason")
    private String inconsistencyReason = null;
    @SerializedName(value="generatedTrafficBytes")
    private Long generatedTrafficBytes = null;
    @SerializedName(value="receivedTrafficBytes")
    private Long receivedTrafficBytes = null;
    @SerializedName(value="generatedTrafficTP")
    private Long generatedTrafficTP = null;
    @SerializedName(value="receivedTrafficTP")
    private Long receivedTrafficTP = null;
    @SerializedName(value="generatedTrafficPerPacket")
    private Long generatedTrafficPerPacket = null;
    @SerializedName(value="redologRetainedSize")
    private Long redologRetainedSize = null;
    @SerializedName(value="redologRetainedWeight")
    private Long redologRetainedWeight = null;
    @SerializedName(value="operatingMode")
    private OperatingModeEnum operatingMode = null;

    public ReplicationChannelStatistics lastKeyToReplicate(Long lastKeyToReplicate) {
        this.lastKeyToReplicate = lastKeyToReplicate;
        return this;
    }

    @ApiModelProperty(required=true, value="The key of the last packet sent to target")
    public Long getLastKeyToReplicate() {
        return this.lastKeyToReplicate;
    }

    public void setLastKeyToReplicate(Long lastKeyToReplicate) {
        this.lastKeyToReplicate = lastKeyToReplicate;
    }

    public ReplicationChannelStatistics lastConfirmedKeyFromTarget(Long lastConfirmedKeyFromTarget) {
        this.lastConfirmedKeyFromTarget = lastConfirmedKeyFromTarget;
        return this;
    }

    @ApiModelProperty(required=true, value="The key of the last packet confirmed by target")
    public Long getLastConfirmedKeyFromTarget() {
        return this.lastConfirmedKeyFromTarget;
    }

    public void setLastConfirmedKeyFromTarget(Long lastConfirmedKeyFromTarget) {
        this.lastConfirmedKeyFromTarget = lastConfirmedKeyFromTarget;
    }

    public ReplicationChannelStatistics channelState(ChannelStateEnum channelState) {
        this.channelState = channelState;
        return this;
    }

    @ApiModelProperty(required=true, value="The replication channel state")
    public ChannelStateEnum getChannelState() {
        return this.channelState;
    }

    public void setChannelState(ChannelStateEnum channelState) {
        this.channelState = channelState;
    }

    public ReplicationChannelStatistics replicationMode(ReplicationModeEnum replicationMode) {
        this.replicationMode = replicationMode;
        return this;
    }

    @ApiModelProperty(required=true, value="The replication mode")
    public ReplicationModeEnum getReplicationMode() {
        return this.replicationMode;
    }

    public void setReplicationMode(ReplicationModeEnum replicationMode) {
        this.replicationMode = replicationMode;
    }

    public ReplicationChannelStatistics throughput(Integer throughput) {
        this.throughput = throughput;
        return this;
    }

    @ApiModelProperty(required=true, value="The current rate of packet being sent per second")
    public Integer getThroughput() {
        return this.throughput;
    }

    public void setThroughput(Integer throughput) {
        this.throughput = throughput;
    }

    public ReplicationChannelStatistics totalNumberOfReplicatedPackets(Long totalNumberOfReplicatedPackets) {
        this.totalNumberOfReplicatedPackets = totalNumberOfReplicatedPackets;
        return this;
    }

    @ApiModelProperty(required=true, value="An approximation of the total number of replicated packets through this channel")
    public Long getTotalNumberOfReplicatedPackets() {
        return this.totalNumberOfReplicatedPackets;
    }

    public void setTotalNumberOfReplicatedPackets(Long totalNumberOfReplicatedPackets) {
        this.totalNumberOfReplicatedPackets = totalNumberOfReplicatedPackets;
    }

    public ReplicationChannelStatistics inconsistencyReason(String inconsistencyReason) {
        this.inconsistencyReason = inconsistencyReason;
        return this;
    }

    @ApiModelProperty(required=true, value="The channel inconsistency reason or null if the channel is consistent")
    public String getInconsistencyReason() {
        return this.inconsistencyReason;
    }

    public void setInconsistencyReason(String inconsistencyReason) {
        this.inconsistencyReason = inconsistencyReason;
    }

    public ReplicationChannelStatistics generatedTrafficBytes(Long generatedTrafficBytes) {
        this.generatedTrafficBytes = generatedTrafficBytes;
        return this;
    }

    @ApiModelProperty(required=true, value="The total number of bytes sent")
    public Long getGeneratedTrafficBytes() {
        return this.generatedTrafficBytes;
    }

    public void setGeneratedTrafficBytes(Long generatedTrafficBytes) {
        this.generatedTrafficBytes = generatedTrafficBytes;
    }

    public ReplicationChannelStatistics receivedTrafficBytes(Long receivedTrafficBytes) {
        this.receivedTrafficBytes = receivedTrafficBytes;
        return this;
    }

    @ApiModelProperty(required=true, value="The total number of bytes received")
    public Long getReceivedTrafficBytes() {
        return this.receivedTrafficBytes;
    }

    public void setReceivedTrafficBytes(Long receivedTrafficBytes) {
        this.receivedTrafficBytes = receivedTrafficBytes;
    }

    public ReplicationChannelStatistics generatedTrafficTP(Long generatedTrafficTP) {
        this.generatedTrafficTP = generatedTrafficTP;
        return this;
    }

    @ApiModelProperty(required=true, value="The current rate of bytes being sent per second")
    public Long getGeneratedTrafficTP() {
        return this.generatedTrafficTP;
    }

    public void setGeneratedTrafficTP(Long generatedTrafficTP) {
        this.generatedTrafficTP = generatedTrafficTP;
    }

    public ReplicationChannelStatistics receivedTrafficTP(Long receivedTrafficTP) {
        this.receivedTrafficTP = receivedTrafficTP;
        return this;
    }

    @ApiModelProperty(required=true, value="The current rate of bytes being received per second")
    public Long getReceivedTrafficTP() {
        return this.receivedTrafficTP;
    }

    public void setReceivedTrafficTP(Long receivedTrafficTP) {
        this.receivedTrafficTP = receivedTrafficTP;
    }

    public ReplicationChannelStatistics generatedTrafficPerPacket(Long generatedTrafficPerPacket) {
        this.generatedTrafficPerPacket = generatedTrafficPerPacket;
        return this;
    }

    @ApiModelProperty(required=true, value="The current rate of bytes being sent per replication packet")
    public Long getGeneratedTrafficPerPacket() {
        return this.generatedTrafficPerPacket;
    }

    public void setGeneratedTrafficPerPacket(Long generatedTrafficPerPacket) {
        this.generatedTrafficPerPacket = generatedTrafficPerPacket;
    }

    public ReplicationChannelStatistics redologRetainedSize(Long redologRetainedSize) {
        this.redologRetainedSize = redologRetainedSize;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of packets that are kept in the redolog for this channel")
    public Long getRedologRetainedSize() {
        return this.redologRetainedSize;
    }

    public void setRedologRetainedSize(Long redologRetainedSize) {
        this.redologRetainedSize = redologRetainedSize;
    }

    public ReplicationChannelStatistics redologRetainedWeight(Long redologRetainedWeight) {
        this.redologRetainedWeight = redologRetainedWeight;
        return this;
    }

    @ApiModelProperty(required=true, value="The accumulated weight of packets that are kept in the redolog for this channel")
    public Long getRedologRetainedWeight() {
        return this.redologRetainedWeight;
    }

    public void setRedologRetainedWeight(Long redologRetainedWeight) {
        this.redologRetainedWeight = redologRetainedWeight;
    }

    public ReplicationChannelStatistics operatingMode(OperatingModeEnum operatingMode) {
        this.operatingMode = operatingMode;
        return this;
    }

    @ApiModelProperty(required=true, value="The current mode this channel is operating in")
    public OperatingModeEnum getOperatingMode() {
        return this.operatingMode;
    }

    public void setOperatingMode(OperatingModeEnum operatingMode) {
        this.operatingMode = operatingMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationChannelStatistics replicationChannelStatistics = (ReplicationChannelStatistics)o;
        return Objects.equals(this.lastKeyToReplicate, replicationChannelStatistics.lastKeyToReplicate) && Objects.equals(this.lastConfirmedKeyFromTarget, replicationChannelStatistics.lastConfirmedKeyFromTarget) && Objects.equals((Object)this.channelState, (Object)replicationChannelStatistics.channelState) && Objects.equals((Object)this.replicationMode, (Object)replicationChannelStatistics.replicationMode) && Objects.equals(this.throughput, replicationChannelStatistics.throughput) && Objects.equals(this.totalNumberOfReplicatedPackets, replicationChannelStatistics.totalNumberOfReplicatedPackets) && Objects.equals(this.inconsistencyReason, replicationChannelStatistics.inconsistencyReason) && Objects.equals(this.generatedTrafficBytes, replicationChannelStatistics.generatedTrafficBytes) && Objects.equals(this.receivedTrafficBytes, replicationChannelStatistics.receivedTrafficBytes) && Objects.equals(this.generatedTrafficTP, replicationChannelStatistics.generatedTrafficTP) && Objects.equals(this.receivedTrafficTP, replicationChannelStatistics.receivedTrafficTP) && Objects.equals(this.generatedTrafficPerPacket, replicationChannelStatistics.generatedTrafficPerPacket) && Objects.equals(this.redologRetainedSize, replicationChannelStatistics.redologRetainedSize) && Objects.equals(this.redologRetainedWeight, replicationChannelStatistics.redologRetainedWeight) && Objects.equals((Object)this.operatingMode, (Object)replicationChannelStatistics.operatingMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lastKeyToReplicate, this.lastConfirmedKeyFromTarget, this.channelState, this.replicationMode, this.throughput, this.totalNumberOfReplicatedPackets, this.inconsistencyReason, this.generatedTrafficBytes, this.receivedTrafficBytes, this.generatedTrafficTP, this.receivedTrafficTP, this.generatedTrafficPerPacket, this.redologRetainedSize, this.redologRetainedWeight, this.operatingMode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReplicationChannelStatistics {\n");
        sb.append("    lastKeyToReplicate: ").append(this.toIndentedString(this.lastKeyToReplicate)).append("\n");
        sb.append("    lastConfirmedKeyFromTarget: ").append(this.toIndentedString(this.lastConfirmedKeyFromTarget)).append("\n");
        sb.append("    channelState: ").append(this.toIndentedString((Object)this.channelState)).append("\n");
        sb.append("    replicationMode: ").append(this.toIndentedString((Object)this.replicationMode)).append("\n");
        sb.append("    throughput: ").append(this.toIndentedString(this.throughput)).append("\n");
        sb.append("    totalNumberOfReplicatedPackets: ").append(this.toIndentedString(this.totalNumberOfReplicatedPackets)).append("\n");
        sb.append("    inconsistencyReason: ").append(this.toIndentedString(this.inconsistencyReason)).append("\n");
        sb.append("    generatedTrafficBytes: ").append(this.toIndentedString(this.generatedTrafficBytes)).append("\n");
        sb.append("    receivedTrafficBytes: ").append(this.toIndentedString(this.receivedTrafficBytes)).append("\n");
        sb.append("    generatedTrafficTP: ").append(this.toIndentedString(this.generatedTrafficTP)).append("\n");
        sb.append("    receivedTrafficTP: ").append(this.toIndentedString(this.receivedTrafficTP)).append("\n");
        sb.append("    generatedTrafficPerPacket: ").append(this.toIndentedString(this.generatedTrafficPerPacket)).append("\n");
        sb.append("    redologRetainedSize: ").append(this.toIndentedString(this.redologRetainedSize)).append("\n");
        sb.append("    redologRetainedWeight: ").append(this.toIndentedString(this.redologRetainedWeight)).append("\n");
        sb.append("    operatingMode: ").append(this.toIndentedString((Object)this.operatingMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OperatingModeEnum {
        SYNC("SYNC"),
        ASYNC("ASYNC"),
        RELIABLE_ASYNC("RELIABLE_ASYNC");

        private String value;

        private OperatingModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OperatingModeEnum fromValue(String text) {
            for (OperatingModeEnum b : OperatingModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OperatingModeEnum> {
            public void write(JsonWriter jsonWriter, OperatingModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OperatingModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OperatingModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ReplicationModeEnum {
        SYNC("SYNC"),
        ASYNC("ASYNC"),
        MIRROR("MIRROR"),
        BACKUP_SPACE("BACKUP_SPACE"),
        ACTIVE_SPACE("ACTIVE_SPACE"),
        LOCAL_VIEW("LOCAL_VIEW"),
        GATEWAY("GATEWAY"),
        DURABLE_NOTIFICATION("DURABLE_NOTIFICATION");

        private String value;

        private ReplicationModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ReplicationModeEnum fromValue(String text) {
            for (ReplicationModeEnum b : ReplicationModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ReplicationModeEnum> {
            public void write(JsonWriter jsonWriter, ReplicationModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ReplicationModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ReplicationModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ChannelStateEnum {
        DISCONNECTED("DISCONNECTED"),
        CONNECTED("CONNECTED"),
        ACTIVE("ACTIVE");

        private String value;

        private ChannelStateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ChannelStateEnum fromValue(String text) {
            for (ChannelStateEnum b : ChannelStateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ChannelStateEnum> {
            public void write(JsonWriter jsonWriter, ChannelStateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ChannelStateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ChannelStateEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

