/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.rest.client.java.model;

import com.gigaspaces.rest.client.java.model.SuspendInfo;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class SpaceInstance {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="mode")
    private String mode = null;
    @SerializedName(value="partitionId")
    private Integer partitionId = null;
    @SerializedName(value="backupId")
    private Integer backupId = null;
    @SerializedName(value="hostId")
    private String hostId = null;
    @SerializedName(value="containerId")
    private String containerId = null;
    @SerializedName(value="suspendInfo")
    private SuspendInfo suspendInfo = null;

    public SpaceInstance id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Space Instance unique identifier")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public SpaceInstance mode(String mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(required=true, value="space mode (primary, backup, none)")
    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public SpaceInstance partitionId(Integer partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    @ApiModelProperty(required=true, value="Partition Id")
    public Integer getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(Integer partitionId) {
        this.partitionId = partitionId;
    }

    public SpaceInstance backupId(Integer backupId) {
        this.backupId = backupId;
        return this;
    }

    @ApiModelProperty(required=true, value="Backup id of instance within its partition")
    public Integer getBackupId() {
        return this.backupId;
    }

    public void setBackupId(Integer backupId) {
        this.backupId = backupId;
    }

    public SpaceInstance hostId(String hostId) {
        this.hostId = hostId;
        return this;
    }

    @ApiModelProperty(required=true, value="The host id which the space deployed in")
    public String getHostId() {
        return this.hostId;
    }

    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    public SpaceInstance containerId(String containerId) {
        this.containerId = containerId;
        return this;
    }

    @ApiModelProperty(required=true, value="The container(gsc) id which the space deployed in")
    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public SpaceInstance suspendInfo(SuspendInfo suspendInfo) {
        this.suspendInfo = suspendInfo;
        return this;
    }

    @ApiModelProperty(required=true, value="The space suspension info")
    public SuspendInfo getSuspendInfo() {
        return this.suspendInfo;
    }

    public void setSuspendInfo(SuspendInfo suspendInfo) {
        this.suspendInfo = suspendInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpaceInstance spaceInstance = (SpaceInstance)o;
        return Objects.equals(this.id, spaceInstance.id) && Objects.equals(this.mode, spaceInstance.mode) && Objects.equals(this.partitionId, spaceInstance.partitionId) && Objects.equals(this.backupId, spaceInstance.backupId) && Objects.equals(this.hostId, spaceInstance.hostId) && Objects.equals(this.containerId, spaceInstance.containerId) && Objects.equals(this.suspendInfo, spaceInstance.suspendInfo);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.mode, this.partitionId, this.backupId, this.hostId, this.containerId, this.suspendInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SpaceInstance {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    partitionId: ").append(this.toIndentedString(this.partitionId)).append("\n");
        sb.append("    backupId: ").append(this.toIndentedString(this.backupId)).append("\n");
        sb.append("    hostId: ").append(this.toIndentedString(this.hostId)).append("\n");
        sb.append("    containerId: ").append(this.toIndentedString(this.containerId)).append("\n");
        sb.append("    suspendInfo: ").append(this.toIndentedString(this.suspendInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

