/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.rest.client.java.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SparkApplicationRequest {
    @SerializedName(value="mainClass")
    private String mainClass = null;
    @SerializedName(value="applicationJar")
    private String applicationJar = null;
    @SerializedName(value="applicationArguments")
    private List<String> applicationArguments = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="sparkProperties")
    private Map<String, String> sparkProperties = null;

    public SparkApplicationRequest mainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    @ApiModelProperty(required=true, value="Main class in jar")
    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public SparkApplicationRequest applicationJar(String applicationJar) {
        this.applicationJar = applicationJar;
        return this;
    }

    @ApiModelProperty(required=true, value="path to jar job")
    public String getApplicationJar() {
        return this.applicationJar;
    }

    public void setApplicationJar(String applicationJar) {
        this.applicationJar = applicationJar;
    }

    public SparkApplicationRequest applicationArguments(List<String> applicationArguments) {
        this.applicationArguments = applicationArguments;
        return this;
    }

    public SparkApplicationRequest addApplicationArgumentsItem(String applicationArgumentsItem) {
        if (this.applicationArguments == null) {
            this.applicationArguments = new ArrayList<String>();
        }
        this.applicationArguments.add(applicationArgumentsItem);
        return this;
    }

    @ApiModelProperty(value="List of args to the application")
    public List<String> getApplicationArguments() {
        return this.applicationArguments;
    }

    public void setApplicationArguments(List<String> applicationArguments) {
        this.applicationArguments = applicationArguments;
    }

    public SparkApplicationRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Spark app name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SparkApplicationRequest sparkProperties(Map<String, String> sparkProperties) {
        this.sparkProperties = sparkProperties;
        return this;
    }

    public SparkApplicationRequest putSparkPropertiesItem(String key, String sparkPropertiesItem) {
        if (this.sparkProperties == null) {
            this.sparkProperties = new HashMap<String, String>();
        }
        this.sparkProperties.put(key, sparkPropertiesItem);
        return this;
    }

    @ApiModelProperty(value="Spark configurations")
    public Map<String, String> getSparkProperties() {
        return this.sparkProperties;
    }

    public void setSparkProperties(Map<String, String> sparkProperties) {
        this.sparkProperties = sparkProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparkApplicationRequest sparkApplicationRequest = (SparkApplicationRequest)o;
        return Objects.equals(this.mainClass, sparkApplicationRequest.mainClass) && Objects.equals(this.applicationJar, sparkApplicationRequest.applicationJar) && Objects.equals(this.applicationArguments, sparkApplicationRequest.applicationArguments) && Objects.equals(this.name, sparkApplicationRequest.name) && Objects.equals(this.sparkProperties, sparkApplicationRequest.sparkProperties);
    }

    public int hashCode() {
        return Objects.hash(this.mainClass, this.applicationJar, this.applicationArguments, this.name, this.sparkProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SparkApplicationRequest {\n");
        sb.append("    mainClass: ").append(this.toIndentedString(this.mainClass)).append("\n");
        sb.append("    applicationJar: ").append(this.toIndentedString(this.applicationJar)).append("\n");
        sb.append("    applicationArguments: ").append(this.toIndentedString(this.applicationArguments)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sparkProperties: ").append(this.toIndentedString(this.sparkProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

