/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.rest.client.java.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class TransportStatistics {
    @SerializedName(value="timestamp")
    private Long timestamp = null;
    @SerializedName(value="completedTaskCount")
    private Long completedTaskCount = null;
    @SerializedName(value="completedTaskPerSecond")
    private Double completedTaskPerSecond = null;
    @SerializedName(value="activeThreadsCount")
    private Integer activeThreadsCount = null;
    @SerializedName(value="activeThreadsPerc")
    private Double activeThreadsPerc = null;
    @SerializedName(value="queueSize")
    private Integer queueSize = null;

    public TransportStatistics timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(required=true, value="timestamp when the statistics were taken")
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public TransportStatistics completedTaskCount(Long completedTaskCount) {
        this.completedTaskCount = completedTaskCount;
        return this;
    }

    @ApiModelProperty(required=true, value="number of communication level tasks that were completed")
    public Long getCompletedTaskCount() {
        return this.completedTaskCount;
    }

    public void setCompletedTaskCount(Long completedTaskCount) {
        this.completedTaskCount = completedTaskCount;
    }

    public TransportStatistics completedTaskPerSecond(Double completedTaskPerSecond) {
        this.completedTaskPerSecond = completedTaskPerSecond;
        return this;
    }

    @ApiModelProperty(required=true, value="number of completed communication level tasks per second")
    public Double getCompletedTaskPerSecond() {
        return this.completedTaskPerSecond;
    }

    public void setCompletedTaskPerSecond(Double completedTaskPerSecond) {
        this.completedTaskPerSecond = completedTaskPerSecond;
    }

    public TransportStatistics activeThreadsCount(Integer activeThreadsCount) {
        this.activeThreadsCount = activeThreadsCount;
        return this;
    }

    @ApiModelProperty(required=true, value="number of active threads currently processing a communication task")
    public Integer getActiveThreadsCount() {
        return this.activeThreadsCount;
    }

    public void setActiveThreadsCount(Integer activeThreadsCount) {
        this.activeThreadsCount = activeThreadsCount;
    }

    public TransportStatistics activeThreadsPerc(Double activeThreadsPerc) {
        this.activeThreadsPerc = activeThreadsPerc;
        return this;
    }

    @ApiModelProperty(required=true, value="percentage of active threads out of the maximum threads")
    public Double getActiveThreadsPerc() {
        return this.activeThreadsPerc;
    }

    public void setActiveThreadsPerc(Double activeThreadsPerc) {
        this.activeThreadsPerc = activeThreadsPerc;
    }

    public TransportStatistics queueSize(Integer queueSize) {
        this.queueSize = queueSize;
        return this;
    }

    @ApiModelProperty(required=true, value="number of currently waiting communication tasks to be executed")
    public Integer getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(Integer queueSize) {
        this.queueSize = queueSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransportStatistics transportStatistics = (TransportStatistics)o;
        return Objects.equals(this.timestamp, transportStatistics.timestamp) && Objects.equals(this.completedTaskCount, transportStatistics.completedTaskCount) && Objects.equals(this.completedTaskPerSecond, transportStatistics.completedTaskPerSecond) && Objects.equals(this.activeThreadsCount, transportStatistics.activeThreadsCount) && Objects.equals(this.activeThreadsPerc, transportStatistics.activeThreadsPerc) && Objects.equals(this.queueSize, transportStatistics.queueSize);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.completedTaskCount, this.completedTaskPerSecond, this.activeThreadsCount, this.activeThreadsPerc, this.queueSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransportStatistics {\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    completedTaskCount: ").append(this.toIndentedString(this.completedTaskCount)).append("\n");
        sb.append("    completedTaskPerSecond: ").append(this.toIndentedString(this.completedTaskPerSecond)).append("\n");
        sb.append("    activeThreadsCount: ").append(this.toIndentedString(this.activeThreadsCount)).append("\n");
        sb.append("    activeThreadsPerc: ").append(this.toIndentedString(this.activeThreadsPerc)).append("\n");
        sb.append("    queueSize: ").append(this.toIndentedString(this.queueSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

