/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.jmx.topthreads;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.luminis.jmx.topthreads.TopThreadsPanel;

public class Main {
    private static final String PROGRAM_NAME = "TopThreads";
    public static final String JARNAME = "topthreads.jar";
    public static final String VERSION = "1.0.3";

    static void usage() {
        System.out.println("");
        System.out.println("TopThreads version 1.0.3");
        System.out.println("");
        System.out.println("Usage: java -jar topthreads.jar <hostname>:<port>");
        System.out.println("    or java -cp topthreads.jar " + Main.class.getName() + " <hostname>:<port>");
        System.out.println("    or as a JConsole plugin: jconsole -pluginpath topthreads.jar");
        System.out.println("Requires java 1.6");
        System.out.println("");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        String[] arg2;
        if (args.length != 1) {
            Main.usage();
        }
        if ((arg2 = args[0].split(":")).length != 2) {
            Main.usage();
        }
        String hostname = arg2[0];
        int port = -1;
        try {
            port = Integer.parseInt(arg2[1]);
        }
        catch (NumberFormatException x) {
            Main.usage();
        }
        if (port < 0) {
            Main.usage();
        }
        final TopThreadsPanel topth = new TopThreadsPanel();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Main.createAndShowGUI(topth);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        MBeanServerConnection server = Main.connect(topth, hostname, port);
        topth.setMBeanServerConnection(server);
    }

    public static void createAndShowGUI(JPanel jtop) {
        JFrame frame = new JFrame(PROGRAM_NAME);
        JComponent contentPane = (JComponent)frame.getContentPane();
        contentPane.add((Component)jtop, "Center");
        contentPane.setOpaque(true);
        contentPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(contentPane);
        frame.pack();
        frame.setVisible(true);
    }

    static MBeanServerConnection connect(JPanel gui, String hostname, int port) {
        String connectSting = "/jndi/rmi://" + hostname + ":" + port + "/jmxrmi";
        MBeanServerConnection server = null;
        try {
            JMXServiceURL url = new JMXServiceURL("rmi", "", 0, connectSting);
            JMXConnector connector = JMXConnectorFactory.connect(url);
            server = connector.getMBeanServerConnection();
        }
        catch (MalformedURLException url) {
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(gui, "Could not connect to " + hostname + ":" + port + ".\n" + "Check that the application you want to monitor has remote jmx monitoring enabled.", PROGRAM_NAME, 0);
            System.exit(1);
        }
        return server;
    }
}

