/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.jmx.topthreads;

import com.sun.tools.jconsole.JConsoleContext;
import com.sun.tools.jconsole.JConsolePlugin;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import net.luminis.jmx.topthreads.TopThreadsPanel;

public class PluginAdapter
extends JConsolePlugin {
    public static final String TAB_NAME = "Top threads";

    @Override
    public Map<String, JPanel> getTabs() {
        TopThreadsPanel topth = new TopThreadsPanel();
        ConnectionListener x = new ConnectionListener(topth);
        this.addContextPropertyChangeListener(x);
        x.checkConnection();
        return Collections.singletonMap(TAB_NAME, topth);
    }

    @Override
    public SwingWorker<?, ?> newSwingWorker() {
        return null;
    }

    private class ConnectionListener
    implements PropertyChangeListener {
        private TopThreadsPanel jtopp;

        public ConnectionListener(TopThreadsPanel jtopp) {
            this.jtopp = jtopp;
        }

        public void checkConnection() {
            MBeanServerConnection connection = PluginAdapter.this.getContext().getMBeanServerConnection();
            if (connection != null) {
                this.jtopp.setMBeanServerConnection(connection);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName() == "connectionState") {
                JConsoleContext ctx = PluginAdapter.this.getContext();
                if (event.getNewValue().equals((Object)JConsoleContext.ConnectionState.CONNECTED)) {
                    if (ctx != null) {
                        this.jtopp.setMBeanServerConnection(ctx.getMBeanServerConnection());
                    }
                } else {
                    this.jtopp.setMBeanServerConnection(null);
                }
            }
        }
    }
}

