/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.jmx.topthreads;

import java.lang.management.ThreadInfo;
import java.util.Comparator;

class ThreadInfoStats {
    private static int historyLength = 10;
    private ThreadInfo threadInfo;
    private long threadId;
    private long previousCpuTime;
    private long lastCpuUsage;
    private int updateCount;
    private int percentage;
    private boolean showTrace;
    private int[] usageHistory;
    private int historyIndex;
    private int validValues;
    private int index;

    public ThreadInfoStats(long id, ThreadInfo current, long cpuTime) {
        this.threadId = id;
        this.threadInfo = current;
        this.previousCpuTime = cpuTime;
        this.usageHistory = new int[historyLength];
    }

    public long getThreadId() {
        return this.threadId;
    }

    public boolean getShowTrace() {
        return this.showTrace;
    }

    public void showTrace(boolean on) {
        this.showTrace = on;
    }

    public boolean mustShowTrace() {
        return this.showTrace;
    }

    public int getPercentage() {
        return this.percentage;
    }

    public Thread.State getThreadState() {
        return this.threadInfo.getThreadState();
    }

    public long getCpuUsage() {
        return this.lastCpuUsage;
    }

    public int getAverageUsage() {
        if (this.validValues > 0) {
            int sum = this.percentage;
            int[] nArray = this.usageHistory;
            int n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                int value = nArray[n];
                sum += value;
                ++n;
            }
            return sum / this.validValues;
        }
        return 0;
    }

    public long getCpuTime() {
        return this.previousCpuTime;
    }

    public String getThreadName() {
        return this.threadInfo.getThreadName();
    }

    public long update(ThreadInfo current, long cpuTime) {
        this.usageHistory[this.historyIndex] = this.percentage;
        ++this.historyIndex;
        this.historyIndex %= historyLength;
        if (this.validValues < historyLength) {
            ++this.validValues;
        }
        this.threadInfo = current;
        this.lastCpuUsage = cpuTime - this.previousCpuTime;
        if (this.lastCpuUsage < 0L) {
            this.lastCpuUsage = 0L;
        }
        this.previousCpuTime = cpuTime;
        ++this.updateCount;
        return this.lastCpuUsage;
    }

    public boolean checkUpdate(int currentUpdate) {
        if (this.updateCount != currentUpdate) {
            assert (this.updateCount == currentUpdate - 1 || this.updateCount == 0);
            this.lastCpuUsage = 0L;
            this.updateCount = currentUpdate;
            return false;
        }
        return true;
    }

    public void computePercentage(long totalCpuTime) {
        if (totalCpuTime != 0L) {
            this.percentage = (int)(100L * this.lastCpuUsage / totalCpuTime);
        }
    }

    public int[] getHistory() {
        int[] values = new int[historyLength];
        int count = 0;
        while (count < historyLength) {
            int index = (this.historyIndex + count) % historyLength;
            values[count] = this.usageHistory[index];
            ++count;
        }
        return values;
    }

    public String getHistoryAsString() {
        StringBuffer history = new StringBuffer();
        boolean notAllZero = false;
        int count = 0;
        while (count < historyLength) {
            int index = (this.historyIndex + count) % historyLength;
            int value = this.usageHistory[index];
            if (value > 0) {
                notAllZero = true;
            }
            history.append(value);
            history.append(" ");
            ++count;
        }
        if (notAllZero) {
            return history.toString();
        }
        return "";
    }

    static Comparator<ThreadInfoStats> lastUsageComparator() {
        return new Comparator<ThreadInfoStats>(){

            @Override
            public int compare(ThreadInfoStats o1, ThreadInfoStats o2) {
                if (o1.lastCpuUsage < o2.lastCpuUsage) {
                    return 1;
                }
                if (o1.lastCpuUsage > o2.lastCpuUsage) {
                    return -1;
                }
                if (o1.previousCpuTime < o2.previousCpuTime) {
                    return 1;
                }
                if (o1.previousCpuTime > o2.previousCpuTime) {
                    return -1;
                }
                return 0;
            }
        };
    }

    static Comparator<ThreadInfoStats> nameComparator() {
        return new Comparator<ThreadInfoStats>(){

            @Override
            public int compare(ThreadInfoStats o1, ThreadInfoStats o2) {
                return o1.getThreadName().compareTo(o2.getThreadName());
            }
        };
    }

    public static Comparator<ThreadInfoStats> fixOrderComparator() {
        return new Comparator<ThreadInfoStats>(){

            @Override
            public int compare(ThreadInfoStats o1, ThreadInfoStats o2) {
                if (o1.index == 0 && o2.index == 0) {
                    return new Long(o1.lastCpuUsage).compareTo(o2.lastCpuUsage);
                }
                if (o1.index == 0) {
                    return 1;
                }
                if (o2.index == 0) {
                    return -1;
                }
                return new Integer(o1.index).compareTo(o2.index);
            }
        };
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public int getIndex() {
        return this.index;
    }
}

