/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.jmx.topthreads;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import javax.management.MBeanServerConnection;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import net.luminis.jmx.topthreads.ThreadInfoStats;

public class TopThreadsPanel
extends JPanel {
    public static final String DEBUG_FLAG = "topthreads.debug";
    public static final int INITIAL_POLL_INTERVAL = 10;
    public static final int INITIAL_MAX_THREADS = 100;
    private static final int COLUMN_SETTRACE = 0;
    private static final int COLUMN_THREADNAME = 1;
    private static final int COLUMN_TOTAL_TIME = 2;
    private static final int COLUMN_HISTORY = 2;
    private static final int COLUMN_USAGE = 3;
    private static final int COLUMN_PERCENTAGE = 4;
    private static final int COLUMN_AVG = 5;
    private static final int COLUMN_THREADSTATE = 6;
    private static final int COLUMN_COUNT = 7;
    public static final int COLUMN_INDEX = 7;
    public static final int COLUMN_HISVAL = 7;
    public static final int PSEUDO_COLUMN_THREAD_INFO = -1;
    private JLabel threadCountLabel;
    private int threadCount;
    private JLabel threadsRunningLabel;
    private int threadsRunning;
    private JLabel threadsBlockedLabel;
    private int threadsBlocked;
    private JLabel threadsWaitingLabel;
    private int threadsWaiting;
    private JLabel threadsTimedWaitingLabel;
    private int threadsTimedWaiting;
    private JTable table;
    private ThreadInfoTableModel tableModel;
    private JTextArea stackTraceArea;
    private JTextField intervalField;
    private int timerInterval = 10;
    private JTextField maxThreadsField;
    private int maxThreadsDisplayed = 100;
    private boolean debug;
    private MBeanServerConnection server;
    private ThreadMXBean threadMXBean;
    private Comparator<ThreadInfoStats> m_comparator = ThreadInfoStats.lastUsageComparator();
    private boolean fixOrder;
    private Map<Long, ThreadInfoStats> threadData = new HashMap<Long, ThreadInfoStats>();
    private int updateCount;
    private ThreadInfoStats tracedThread;
    private String latestStackTrace = "";
    private Timer timer;
    private TimerTask timerTask;
    private int maxStackTraceDepth = 100;
    private JSplitPane m_splitter;

    public TopThreadsPanel() {
        super(new BorderLayout());
        this.add((Component)this.createTopPanel(), "North");
        this.createTable();
        JScrollPane tableScrollPane = new JScrollPane(this.table);
        this.stackTraceArea = new JTextArea();
        this.stackTraceArea.setEditable(false);
        this.stackTraceArea.setMinimumSize(new Dimension(0, 0));
        JScrollPane textScrollPane = new JScrollPane(this.stackTraceArea);
        this.m_splitter = new JSplitPane(0, tableScrollPane, textScrollPane);
        this.m_splitter.setOneTouchExpandable(true);
        this.m_splitter.setContinuousLayout(false);
        this.m_splitter.setDividerLocation(0.3f);
        this.m_splitter.setResizeWeight(1.0);
        this.add((Component)this.m_splitter, "Center");
        this.add(this.createBottomPanel(), "South");
        if (System.getProperty(DEBUG_FLAG) != null && System.getProperty(DEBUG_FLAG).equals("true")) {
            this.debug = true;
        }
    }

    private JPanel createTopPanel() {
        int strutLarge = 13;
        int strutSmall = 3;
        this.threadCountLabel = new JLabel(" ");
        this.threadsRunningLabel = new JLabel();
        this.threadsBlockedLabel = new JLabel();
        this.threadsWaitingLabel = new JLabel();
        this.threadsTimedWaitingLabel = new JLabel();
        this.threadCountLabel.setToolTipText("current thread count");
        JPanel countPanel = new JPanel(new FlowLayout(0, 0, 5));
        countPanel.add(new JLabel("Count:"));
        countPanel.add(Box.createHorizontalStrut(strutSmall));
        countPanel.add(this.threadCountLabel);
        countPanel.add(Box.createHorizontalStrut(strutLarge));
        countPanel.add(new JLabel("Running:"));
        countPanel.add(Box.createHorizontalStrut(strutSmall));
        countPanel.add(this.threadsRunningLabel);
        countPanel.add(Box.createHorizontalStrut(strutLarge));
        countPanel.add(new JLabel("Blocked:"));
        countPanel.add(Box.createHorizontalStrut(strutSmall));
        countPanel.add(this.threadsBlockedLabel);
        countPanel.add(Box.createHorizontalStrut(strutLarge));
        countPanel.add(new JLabel("Waiting:"));
        countPanel.add(Box.createHorizontalStrut(strutSmall));
        countPanel.add(this.threadsWaitingLabel);
        countPanel.add(Box.createHorizontalStrut(strutLarge));
        countPanel.add(new JLabel("TimedWaiting:"));
        countPanel.add(Box.createHorizontalStrut(strutSmall));
        countPanel.add(this.threadsTimedWaitingLabel);
        return countPanel;
    }

    private Component createTopPanel2() {
        this.threadCountLabel = new JLabel(" ");
        this.threadCountLabel.setToolTipText("current thread count");
        this.threadsRunningLabel = new JLabel();
        this.threadsBlockedLabel = new JLabel();
        this.threadsWaitingLabel = new JLabel();
        this.threadsTimedWaitingLabel = new JLabel();
        Box countPanel = new Box(0);
        int strutSmall = 3;
        int strutLarge = 6;
        countPanel.add(new JLabel("Count:"));
        countPanel.add(Box.createHorizontalStrut(strutSmall));
        countPanel.add(this.threadCountLabel);
        countPanel.add(Box.createHorizontalStrut(strutLarge));
        countPanel.add(Box.createGlue());
        countPanel.add(new JLabel("Running:"));
        countPanel.add(Box.createHorizontalStrut(strutSmall));
        countPanel.add(this.threadsRunningLabel);
        countPanel.add(Box.createHorizontalStrut(strutLarge));
        countPanel.add(Box.createGlue());
        countPanel.add(new JLabel("Blocked:"));
        countPanel.add(Box.createHorizontalStrut(strutSmall));
        countPanel.add(this.threadsBlockedLabel);
        countPanel.add(Box.createHorizontalStrut(strutLarge));
        countPanel.add(Box.createGlue());
        countPanel.add(new JLabel("Waiting:"));
        countPanel.add(Box.createHorizontalStrut(strutSmall));
        countPanel.add(this.threadsWaitingLabel);
        countPanel.add(Box.createHorizontalStrut(strutLarge));
        countPanel.add(Box.createGlue());
        countPanel.add(new JLabel("TimedWaiting:"));
        countPanel.add(Box.createHorizontalStrut(strutSmall));
        countPanel.add(this.threadsTimedWaitingLabel);
        return countPanel;
    }

    private void createTable() {
        this.tableModel = new ThreadInfoTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 300));
        this.table.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(120);
        this.table.setIntercellSpacing(new Dimension(6, 3));
        this.table.setRowHeight(this.table.getRowHeight() + 4);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setGridColor(Color.LIGHT_GRAY);
        this.table.getColumnModel().getColumn(2).setCellRenderer(new UsageHistoryRenderer());
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int column = TopThreadsPanel.this.table.columnAtPoint(e.getPoint());
                if (column != 0) {
                    int row = TopThreadsPanel.this.table.rowAtPoint(e.getPoint());
                    TopThreadsPanel.this.tableModel.setValueAt(Boolean.TRUE, row, 0);
                }
            }
        });
    }

    private Component createBottomPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout());
        int strutSmall = 3;
        int strutLarge = 6;
        this.intervalField = new JTextField(2);
        this.intervalField.setHorizontalAlignment(4);
        this.intervalField.setText(String.valueOf(10));
        this.intervalField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                TopThreadsPanel.this.updateTimerInterval();
            }
        });
        buttonPanel.add(new JLabel("refresh:"));
        buttonPanel.add(Box.createHorizontalStrut(strutSmall));
        buttonPanel.add(this.intervalField);
        buttonPanel.add(Box.createHorizontalStrut(strutLarge));
        buttonPanel.add(Box.createGlue());
        this.maxThreadsField = new JTextField(3);
        this.maxThreadsField.setHorizontalAlignment(4);
        this.maxThreadsField.setText(String.valueOf(100));
        this.maxThreadsField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                TopThreadsPanel.this.updateMaxDisplayed();
            }
        });
        buttonPanel.add(new JLabel("max displayed:"));
        buttonPanel.add(Box.createHorizontalStrut(strutSmall));
        buttonPanel.add(this.maxThreadsField);
        buttonPanel.add(Box.createHorizontalStrut(strutLarge));
        buttonPanel.add(Box.createGlue());
        final JToggleButton fixOrderButton = new JToggleButton("fix order");
        fixOrderButton.setActionCommand("fix");
        fixOrderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("fix")) {
                    fixOrderButton.setActionCommand("unfix");
                    TopThreadsPanel.this.fixOrder(true);
                } else {
                    fixOrderButton.setActionCommand("fix");
                    TopThreadsPanel.this.fixOrder(false);
                }
            }
        });
        buttonPanel.add(fixOrderButton);
        return buttonPanel;
    }

    protected void fixOrder(boolean on) {
        this.fixOrder = on;
        this.m_comparator = on ? ThreadInfoStats.fixOrderComparator() : ThreadInfoStats.lastUsageComparator();
    }

    public synchronized void setMBeanServerConnection(MBeanServerConnection serverConnection) {
        this.server = serverConnection;
        if (serverConnection != null) {
            block7: {
                try {
                    this.threadMXBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=Threading", ThreadMXBean.class);
                }
                catch (IOException e) {
                    if (!this.debug) break block7;
                    System.err.println("Retrieving Thread MXBean failed: " + e);
                }
            }
            if (!this.threadMXBean.isThreadCpuTimeSupported()) {
                System.err.println("This VM does not support thread CPU time monitoring");
            } else {
                this.threadMXBean.setThreadCpuTimeEnabled(true);
            }
            this.initTimer(false);
        } else {
            if (this.debug) {
                System.err.println("JMX connection is reset.");
            }
            this.timer.cancel();
            this.threadMXBean = null;
        }
    }

    private void showStackTrace(final ThreadInfoStats threadInfo) {
        if (threadInfo != null) {
            new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    return TopThreadsPanel.this.retrieveStackTrace(threadInfo);
                }

                @Override
                protected void done() {
                    try {
                        TopThreadsPanel.this.stackTraceArea.setText((String)this.get());
                        TopThreadsPanel.this.stackTraceArea.setCaretPosition(0);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                }
            }.execute();
        }
    }

    private synchronized List<ThreadInfoStats> getThreadList() {
        if (this.threadMXBean == null) {
            return Collections.EMPTY_LIST;
        }
        ++this.updateCount;
        long[] threadIds = null;
        ThreadInfo[] threadInfos = null;
        try {
            threadIds = this.threadMXBean.getAllThreadIds();
            threadInfos = this.threadMXBean.getThreadInfo(threadIds);
        }
        catch (UndeclaredThrowableException ute) {
            if (this.debug) {
                System.err.println("error while getting thread info: " + ute + " caused by " + ute.getCause());
            }
            return Collections.EMPTY_LIST;
        }
        catch (Exception e) {
            if (this.debug) {
                System.err.println("error while getting thread info: " + e);
            }
            return Collections.EMPTY_LIST;
        }
        long totalCpuTime = 0L;
        int i = 0;
        while (i < threadIds.length) {
            long cpuTime;
            assert (threadInfos[i].getThreadId() == threadIds[i]);
            long id = threadIds[i];
            if (threadInfos[i] != null && (cpuTime = this.threadMXBean.getThreadCpuTime(id)) != -1L) {
                ThreadInfoStats stats = this.threadData.get(id);
                if (stats == null) {
                    stats = new ThreadInfoStats(id, threadInfos[i], cpuTime);
                    this.threadData.put(id, stats);
                } else {
                    totalCpuTime += stats.update(threadInfos[i], cpuTime);
                }
            }
            ++i;
        }
        this.resetStateCounts();
        this.latestStackTrace = "";
        ArrayList<ThreadInfoStats> list = new ArrayList<ThreadInfoStats>(this.threadData.values());
        for (ThreadInfoStats info : list) {
            if (!info.checkUpdate(this.updateCount) && this.threadMXBean.getThreadInfo(info.getThreadId()) == null) {
                this.threadData.remove(info.getThreadId());
            }
            info.computePercentage(totalCpuTime);
            this.updateStateCounts(info.getThreadState());
            if (!info.mustShowTrace()) continue;
            this.latestStackTrace = this.retrieveStackTrace(info);
        }
        Collections.sort(list, this.m_comparator);
        if (!this.fixOrder) {
            int index = 1;
            for (ThreadInfoStats info : list) {
                info.setIndex(index++);
            }
        }
        this.threadCount = list.size();
        return list.subList(0, Math.min(this.threadCount, this.maxThreadsDisplayed));
    }

    private String retrieveStackTrace(ThreadInfoStats info) {
        ThreadInfo extendedInfo = this.threadMXBean.getThreadInfo(info.getThreadId(), this.maxStackTraceDepth);
        if (extendedInfo != null) {
            StackTraceElement[] stackTrace = extendedInfo.getStackTrace();
            StringBuffer trace = new StringBuffer();
            StackTraceElement[] stackTraceElementArray = stackTrace;
            int n = 0;
            int n2 = stackTraceElementArray.length;
            while (n < n2) {
                StackTraceElement el = stackTraceElementArray[n];
                trace.append(el.toString());
                trace.append("\n");
                ++n;
            }
            return trace.toString();
        }
        return "";
    }

    private void resetStateCounts() {
        this.threadsBlocked = 0;
        this.threadsRunning = 0;
        this.threadsTimedWaiting = 0;
        this.threadsWaiting = 0;
    }

    private void updateStateCounts(Thread.State threadState) {
        switch (threadState) {
            case BLOCKED: {
                ++this.threadsBlocked;
                break;
            }
            case RUNNABLE: {
                ++this.threadsRunning;
                break;
            }
            case TIMED_WAITING: {
                ++this.threadsTimedWaiting;
                break;
            }
            case WAITING: {
                ++this.threadsWaiting;
            }
        }
    }

    void initTimer(boolean reset) {
        this.timerTask = new TimerTask(){
            SwingWorker<?, ?> swingWorker;

            @Override
            public void run() {
                if (this.swingWorker != null && !this.swingWorker.isDone()) {
                    TopThreadsPanel.this.enlargeTimerInterval();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(TopThreadsPanel.this, "Refresh interval is modified, because it was too small.", "TopThreadsPanel", 2);
                        }
                    });
                } else {
                    this.swingWorker = new RefreshUiWorker();
                    this.swingWorker.execute();
                }
            }
        };
        this.timer = new Timer("JTop Sampling thread");
        int delay = reset ? this.timerInterval : 0;
        this.timer.schedule(this.timerTask, delay * 1000, (long)(this.timerInterval * 1000));
    }

    protected void updateTimerInterval() {
        try {
            int newInterval = Integer.parseInt(this.intervalField.getText());
            if (newInterval > 0 && newInterval < 999) {
                this.timer.cancel();
                this.timerInterval = newInterval;
                this.initTimer(true);
            }
        }
        catch (NumberFormatException nfe) {
            this.intervalField.setText(String.valueOf(this.timerInterval));
        }
    }

    protected void enlargeTimerInterval() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int factor = Math.max(2, 5 - TopThreadsPanel.this.timerInterval);
                TopThreadsPanel topThreadsPanel = TopThreadsPanel.this;
                topThreadsPanel.timerInterval = topThreadsPanel.timerInterval * factor;
                TopThreadsPanel.this.intervalField.setText(String.valueOf(TopThreadsPanel.this.timerInterval));
                TopThreadsPanel.this.updateTimerInterval();
            }
        });
    }

    protected void updateMaxDisplayed() {
        try {
            int newMax = Integer.parseInt(this.maxThreadsField.getText());
            if (newMax >= 1) {
                this.maxThreadsDisplayed = newMax;
            } else {
                this.maxThreadsField.setText(String.valueOf(this.maxThreadsDisplayed));
            }
        }
        catch (NumberFormatException nfe) {
            this.maxThreadsField.setText(String.valueOf(this.maxThreadsDisplayed));
        }
    }

    class ThreadInfoTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[7];
        private List<ThreadInfoStats> threadList = Collections.EMPTY_LIST;

        public ThreadInfoTableModel() {
            this.columnNames[1] = "Thread";
            this.columnNames[2] = "Usage history";
            this.columnNames[3] = "Cpu";
            this.columnNames[4] = "%";
            this.columnNames[5] = "Average";
            this.columnNames[6] = "State";
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.threadList.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            ThreadInfoStats stats = this.threadList.get(row);
            switch (col) {
                case 0: {
                    return stats.getShowTrace();
                }
                case 1: {
                    return stats.getThreadName();
                }
                case 2: {
                    return stats.getHistory();
                }
                case 3: {
                    long usage = stats.getCpuUsage() / 1000L;
                    return new Long(usage);
                }
                case 4: {
                    return stats.getPercentage();
                }
                case 5: {
                    return stats.getAverageUsage();
                }
                case 6: {
                    return stats.getThreadState();
                }
                case 7: {
                    return stats.getHistoryAsString();
                }
                case -1: {
                    return stats;
                }
            }
            return null;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public void setValueAt(Object newValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                if (newValue.equals(Boolean.TRUE)) {
                    if (TopThreadsPanel.this.tracedThread != null) {
                        TopThreadsPanel.this.tracedThread.showTrace(false);
                    }
                    TopThreadsPanel.this.tableModel.fireTableDataChanged();
                    TopThreadsPanel.this.showStackTrace(this.threadList.get(rowIndex));
                }
                TopThreadsPanel.this.tracedThread = this.threadList.get(rowIndex);
                TopThreadsPanel.this.tracedThread.showTrace((Boolean)newValue);
            }
        }

        void setThreadList(List<ThreadInfoStats> list) {
            this.threadList = list;
        }
    }

    public class UsageHistoryRenderer
    extends JComponent
    implements TableCellRenderer {
        private int row;
        private int column;
        private JTable table;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            this.table = table;
            this.row = row;
            this.column = column;
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
            int[] values = (int[])this.table.getValueAt(this.row, this.column);
            int sum = 0;
            int[] nArray = values;
            int n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                int value = nArray[n];
                sum += value;
                ++n;
            }
            int height = this.getHeight();
            int width = this.getWidth();
            int partWidth = 25;
            int index = values.length - 1;
            while (index >= 0) {
                float percentage = (float)values[index] / 100.0f;
                int blue = 170 - (int)(percentage * 170.0f);
                if (blue < 0 || blue > 255) {
                    blue = 125;
                }
                Color color = new Color(255, 204, blue);
                int x0 = width - partWidth;
                int x1 = partWidth;
                width -= partWidth;
                int realHeigth = Math.round(percentage * (float)height);
                int y0 = height - realHeigth;
                int y1 = height;
                g.setColor(color);
                g.fillRect(x0, y0, x1, y1);
                if (sum > 0) {
                    g.setColor(Color.LIGHT_GRAY);
                    g.drawString("" + values[index], x0 + 3, y1 - 3);
                }
                if (x0 <= 0) break;
                --index;
            }
        }
    }

    class RefreshUiWorker
    extends SwingWorker<List<ThreadInfoStats>, Object> {
        RefreshUiWorker() {
        }

        @Override
        public List<ThreadInfoStats> doInBackground() {
            return TopThreadsPanel.this.getThreadList();
        }

        @Override
        protected void done() {
            try {
                List threadList = (List)this.get();
                TopThreadsPanel.this.tableModel.setThreadList(threadList);
                TopThreadsPanel.this.tableModel.fireTableDataChanged();
                TopThreadsPanel.this.threadCountLabel.setText(String.valueOf(TopThreadsPanel.this.threadCount));
                TopThreadsPanel.this.stackTraceArea.setText(TopThreadsPanel.this.latestStackTrace);
                TopThreadsPanel.this.threadsBlockedLabel.setText("" + TopThreadsPanel.this.threadsBlocked);
                TopThreadsPanel.this.threadsRunningLabel.setText("" + TopThreadsPanel.this.threadsRunning);
                TopThreadsPanel.this.threadsWaitingLabel.setText("" + TopThreadsPanel.this.threadsWaiting);
                TopThreadsPanel.this.threadsTimedWaitingLabel.setText("" + TopThreadsPanel.this.threadsTimedWaiting);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }
}

