/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.externalize.RelJsonReader;
import org.apache.calcite.rel.externalize.RelJsonWriter;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.test.JdbcTest;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class RelWriterTest {
    public static final String XX = "{\n  \"rels\": [\n    {\n      \"id\": \"0\",\n      \"relOp\": \"LogicalTableScan\",\n      \"table\": [\n        \"hr\",\n        \"emps\"\n      ],\n      \"inputs\": []\n    },\n    {\n      \"id\": \"1\",\n      \"relOp\": \"LogicalFilter\",\n      \"condition\": {\n        \"op\": \"=\",\n        \"operands\": [\n          {\n            \"input\": 1,\n            \"name\": \"$1\"\n          },\n          10\n        ]\n      }\n    },\n    {\n      \"id\": \"2\",\n      \"relOp\": \"LogicalAggregate\",\n      \"group\": [\n        0\n      ],\n      \"aggs\": [\n        {\n          \"agg\": \"COUNT\",\n          \"type\": {\n            \"type\": \"BIGINT\",\n            \"nullable\": false\n          },\n          \"distinct\": true,\n          \"operands\": [\n            1\n          ]\n        },\n        {\n          \"agg\": \"COUNT\",\n          \"type\": {\n            \"type\": \"BIGINT\",\n            \"nullable\": false\n          },\n          \"distinct\": false,\n          \"operands\": []\n        }\n      ]\n    }\n  ]\n}";

    @Test
    public void testWriter() {
        String s = (String)Frameworks.withPlanner((Frameworks.PlannerAction)new Frameworks.PlannerAction<String>(){

            public String apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema) {
                rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
                LogicalTableScan scan = LogicalTableScan.create((RelOptCluster)cluster, (RelOptTable)relOptSchema.getTableForMember(Arrays.asList("hr", "emps")));
                RexBuilder rexBuilder = cluster.getRexBuilder();
                LogicalFilter filter = LogicalFilter.create((RelNode)scan, (RexNode)rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexBuilder.makeFieldAccess(rexBuilder.makeRangeReference((RelNode)scan), "deptno", true), rexBuilder.makeExactLiteral(BigDecimal.TEN)}));
                RelJsonWriter writer = new RelJsonWriter();
                RelDataType bigIntType = cluster.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
                LogicalAggregate aggregate = LogicalAggregate.create((RelNode)filter, (boolean)false, (ImmutableBitSet)ImmutableBitSet.of((int[])new int[]{0}), null, (List)ImmutableList.of((Object)AggregateCall.create((SqlAggFunction)SqlStdOperatorTable.COUNT, (boolean)true, (List)ImmutableList.of((Object)1), (int)-1, (RelDataType)bigIntType, (String)"c"), (Object)AggregateCall.create((SqlAggFunction)SqlStdOperatorTable.COUNT, (boolean)false, (List)ImmutableList.of(), (int)-1, (RelDataType)bigIntType, (String)"d")));
                aggregate.explain((RelWriter)writer);
                return writer.asString();
            }
        });
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.is((Object)XX));
    }

    @Test
    public void testReader() {
        String s = (String)Frameworks.withPlanner((Frameworks.PlannerAction)new Frameworks.PlannerAction<String>(){

            public String apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema) {
                RelNode node;
                SchemaPlus schema = rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
                RelJsonReader reader = new RelJsonReader(cluster, relOptSchema, (Schema)schema);
                try {
                    node = reader.read(RelWriterTest.XX);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return RelOptUtil.dumpPlan((String)"", (RelNode)node, (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.EXPPLAN_ATTRIBUTES);
            }
        });
        Assert.assertThat((Object)Util.toLinux((String)s), (Matcher)CoreMatchers.is((Object)"LogicalAggregate(group=[{0}], agg#0=[COUNT(DISTINCT $1)], agg#1=[COUNT()])\n  LogicalFilter(condition=[=($1, 10)])\n    LogicalTableScan(table=[[hr, emps]])\n"));
    }
}

