/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.AbstractConverter;
import org.apache.calcite.plan.volcano.PlannerTests;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationImpl;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.junit.Assert;
import org.junit.Test;

public class CollationConversionTest {
    private static final TestRelCollationImpl LEAF_COLLATION = new TestRelCollationImpl((ImmutableList<RelFieldCollation>)ImmutableList.of((Object)new RelFieldCollation(0, RelFieldCollation.Direction.CLUSTERED)));
    private static final TestRelCollationImpl ROOT_COLLATION = new TestRelCollationImpl((ImmutableList<RelFieldCollation>)ImmutableList.of((Object)new RelFieldCollation(0)));
    private static final TestRelCollationTraitDef COLLATION_TRAIT_DEF = new TestRelCollationTraitDef();

    @Test
    public void testCollationConversion() {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRelTraitDef((RelTraitDef)COLLATION_TRAIT_DEF);
        planner.addRule((RelOptRule)new SingleNodeRule());
        planner.addRule((RelOptRule)new LeafTraitRule());
        planner.addRule((RelOptRule)AbstractConverter.ExpandConversionRule.INSTANCE);
        RelOptCluster cluster = PlannerTests.newCluster(planner);
        NoneLeafRel leafRel = new NoneLeafRel(cluster, "a");
        NoneSingleRel singleRel = new NoneSingleRel(cluster, (RelNode)leafRel);
        RelNode convertedRel = planner.changeTraits((RelNode)singleRel, cluster.traitSetOf((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION).plus((RelTrait)ROOT_COLLATION));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof RootSingleRel));
        Assert.assertTrue((boolean)result.getTraitSet().contains((RelTrait)ROOT_COLLATION));
        Assert.assertTrue((boolean)result.getTraitSet().contains((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION));
        RelNode input = result.getInput(0);
        Assert.assertTrue((boolean)(input instanceof PhysicalSort));
        Assert.assertTrue((boolean)result.getTraitSet().contains((RelTrait)ROOT_COLLATION));
        Assert.assertTrue((boolean)input.getTraitSet().contains((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION));
        RelNode input2 = input.getInput(0);
        Assert.assertTrue((boolean)(input2 instanceof LeafRel));
        Assert.assertTrue((boolean)input2.getTraitSet().contains((RelTrait)LEAF_COLLATION));
        Assert.assertTrue((boolean)input.getTraitSet().contains((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION));
    }

    private static class PhysicalSort
    extends Sort {
        PhysicalSort(RelOptCluster cluster, RelTraitSet traits, RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
            super(cluster, traits, input, collation, offset, fetch);
        }

        public Sort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
            return new PhysicalSort(this.getCluster(), traitSet, newInput, newCollation, offset, fetch);
        }

        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeTinyCost();
        }
    }

    private static class TestRelCollationTraitDef
    extends RelTraitDef<RelCollation> {
        private TestRelCollationTraitDef() {
        }

        public Class<RelCollation> getTraitClass() {
            return RelCollation.class;
        }

        public String getSimpleName() {
            return "testsort";
        }

        public boolean multiple() {
            return true;
        }

        public RelCollation getDefault() {
            return LEAF_COLLATION;
        }

        public RelNode convert(RelOptPlanner planner, RelNode rel, RelCollation toCollation, boolean allowInfiniteCostConverters) {
            if (toCollation.getFieldCollations().isEmpty()) {
                return null;
            }
            return new PhysicalSort(rel.getCluster(), rel.getTraitSet().replace((RelTrait)toCollation), rel, toCollation, null, null);
        }

        public boolean canConvert(RelOptPlanner planner, RelCollation fromTrait, RelCollation toTrait) {
            return true;
        }
    }

    private static class TestRelCollationImpl
    extends RelCollationImpl {
        TestRelCollationImpl(ImmutableList<RelFieldCollation> fieldCollations) {
            super(fieldCollations);
        }

        public RelTraitDef getTraitDef() {
            return COLLATION_TRAIT_DEF;
        }
    }

    private static class NoneSingleRel
    extends PlannerTests.TestSingleRel {
        NoneSingleRel(RelOptCluster cluster, RelNode input) {
            super(cluster, cluster.traitSetOf((RelTrait)Convention.NONE).plus((RelTrait)LEAF_COLLATION), input);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (traitSet.comprises(new RelTrait[]{Convention.NONE, LEAF_COLLATION}));
            return new NoneSingleRel(this.getCluster(), (RelNode)NoneSingleRel.sole(inputs));
        }
    }

    private class NoneLeafRel
    extends PlannerTests.TestLeafRel {
        NoneLeafRel(RelOptCluster cluster, String label) {
            super(cluster, cluster.traitSetOf((RelTrait)Convention.NONE).plus((RelTrait)LEAF_COLLATION), label);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (traitSet.comprises(new RelTrait[]{Convention.NONE, LEAF_COLLATION}));
            assert (inputs.isEmpty());
            return this;
        }
    }

    private class LeafRel
    extends PlannerTests.TestLeafRel {
        LeafRel(RelOptCluster cluster, String label) {
            super(cluster, cluster.traitSetOf((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION).plus((RelTrait)LEAF_COLLATION), label);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeTinyCost();
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new LeafRel(this.getCluster(), this.label);
        }
    }

    private class LeafTraitRule
    extends RelOptRule {
        LeafTraitRule() {
            super(LeafTraitRule.operand(NoneLeafRel.class, (RelOptRuleOperandChildren)LeafTraitRule.any()));
        }

        public Convention getOutConvention() {
            return PlannerTests.PHYS_CALLING_CONVENTION;
        }

        public void onMatch(RelOptRuleCall call) {
            NoneLeafRel leafRel = (NoneLeafRel)call.rel(0);
            call.transformTo((RelNode)new LeafRel(leafRel.getCluster(), leafRel.label));
        }
    }

    private class RootSingleRel
    extends PlannerTests.TestSingleRel {
        RootSingleRel(RelOptCluster cluster, RelNode input) {
            super(cluster, cluster.traitSetOf((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION).plus((RelTrait)ROOT_COLLATION), input);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeTinyCost();
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new RootSingleRel(this.getCluster(), (RelNode)RootSingleRel.sole(inputs));
        }
    }

    private class SingleNodeRule
    extends RelOptRule {
        SingleNodeRule() {
            super(SingleNodeRule.operand(NoneSingleRel.class, (RelOptRuleOperandChildren)SingleNodeRule.any()));
        }

        public Convention getOutConvention() {
            return PlannerTests.PHYS_CALLING_CONVENTION;
        }

        public void onMatch(RelOptRuleCall call) {
            NoneSingleRel single = (NoneSingleRel)call.rel(0);
            RelNode input = single.getInput();
            RelNode physInput = SingleNodeRule.convert((RelNode)input, (RelTraitSet)single.getTraitSet().replace((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION).plus((RelTrait)ROOT_COLLATION));
            call.transformTo((RelNode)new RootSingleRel(single.getCluster(), physInput));
        }
    }
}

