/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rel2sql;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.rel2sql.RelToSqlConverter;
import org.apache.calcite.rel.rules.UnionMergeRule;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RuleSet;
import org.apache.calcite.tools.RuleSets;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class RelToSqlConverterTest {
    private Sql sql(String sql) {
        return new Sql(CalciteAssert.SchemaSpec.JDBC_FOODMART, sql, SqlDialect.CALCITE, (List<Function<RelNode, RelNode>>)ImmutableList.of());
    }

    private static Planner getPlanner(List<RelTraitDef> traitDefs, SqlParser.Config parserConfig, CalciteAssert.SchemaSpec schemaSpec, Program ... programs) {
        SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)true);
        FrameworkConfig config = Frameworks.newConfigBuilder().parserConfig(parserConfig).defaultSchema(CalciteAssert.addSchema(rootSchema, schemaSpec)).traitDefs(traitDefs).programs(programs).build();
        return Frameworks.getPlanner((FrameworkConfig)config);
    }

    @Test
    public void testSimpleSelectStarFromProductTable() {
        String query = "select * from \"product\"";
        this.sql(query).ok("SELECT *\nFROM \"foodmart\".\"product\"");
    }

    @Test
    public void testSimpleSelectQueryFromProductTable() {
        String query = "select \"product_id\", \"product_class_id\" from \"product\"";
        String expected = "SELECT \"product_id\", \"product_class_id\"\nFROM \"foodmart\".\"product\"";
        this.sql(query).ok("SELECT \"product_id\", \"product_class_id\"\nFROM \"foodmart\".\"product\"");
    }

    @Test
    public void testSelectQueryWithWhereClauseOfLessThan() {
        String query = "select \"product_id\", \"shelf_width\"  from \"product\" where \"product_id\" < 10";
        String expected = "SELECT \"product_id\", \"shelf_width\"\nFROM \"foodmart\".\"product\"\nWHERE \"product_id\" < 10";
        this.sql(query).ok("SELECT \"product_id\", \"shelf_width\"\nFROM \"foodmart\".\"product\"\nWHERE \"product_id\" < 10");
    }

    @Test
    public void testSelectQueryWithWhereClauseOfBasicOperators() {
        String query = "select * from \"product\" where (\"product_id\" = 10 OR \"product_id\" <= 5) AND (80 >= \"shelf_width\" OR \"shelf_width\" > 30)";
        String expected = "SELECT *\nFROM \"foodmart\".\"product\"\nWHERE (\"product_id\" = 10 OR \"product_id\" <= 5) AND (80 >= \"shelf_width\" OR \"shelf_width\" > 30)";
        this.sql(query).ok("SELECT *\nFROM \"foodmart\".\"product\"\nWHERE (\"product_id\" = 10 OR \"product_id\" <= 5) AND (80 >= \"shelf_width\" OR \"shelf_width\" > 30)");
    }

    @Test
    public void testSelectQueryWithGroupBy() {
        String query = "select count(*) from \"product\" group by \"product_class_id\", \"product_id\"";
        String expected = "SELECT COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\", \"product_id\"";
        this.sql(query).ok("SELECT COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\", \"product_id\"");
    }

    @Test
    public void testSelectQueryWithMinAggregateFunction() {
        String query = "select min(\"net_weight\") from \"product\" group by \"product_class_id\" ";
        String expected = "SELECT MIN(\"net_weight\")\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"";
        this.sql(query).ok("SELECT MIN(\"net_weight\")\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"");
    }

    @Test
    public void testSelectQueryWithMinAggregateFunction1() {
        String query = "select \"product_class_id\", min(\"net_weight\") from \"product\" group by \"product_class_id\"";
        String expected = "SELECT \"product_class_id\", MIN(\"net_weight\")\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"";
        this.sql(query).ok("SELECT \"product_class_id\", MIN(\"net_weight\")\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"");
    }

    @Test
    public void testSelectQueryWithSumAggregateFunction() {
        String query = "select sum(\"net_weight\") from \"product\" group by \"product_class_id\" ";
        String expected = "SELECT SUM(\"net_weight\")\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"";
        this.sql(query).ok("SELECT SUM(\"net_weight\")\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"");
    }

    @Test
    public void testSelectQueryWithMultipleAggregateFunction() {
        String query = "select sum(\"net_weight\"), min(\"low_fat\"), count(*) from \"product\" group by \"product_class_id\" ";
        String expected = "SELECT SUM(\"net_weight\"), MIN(\"low_fat\"), COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"";
        this.sql(query).ok("SELECT SUM(\"net_weight\"), MIN(\"low_fat\"), COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"");
    }

    @Test
    public void testSelectQueryWithMultipleAggregateFunction1() {
        String query = "select \"product_class_id\", sum(\"net_weight\"), min(\"low_fat\"), count(*) from \"product\" group by \"product_class_id\" ";
        String expected = "SELECT \"product_class_id\", SUM(\"net_weight\"), MIN(\"low_fat\"), COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"";
        this.sql(query).ok("SELECT \"product_class_id\", SUM(\"net_weight\"), MIN(\"low_fat\"), COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\"");
    }

    @Test
    public void testSelectQueryWithGroupByAndProjectList() {
        String query = "select \"product_class_id\", \"product_id\", count(*) from \"product\" group by \"product_class_id\", \"product_id\"  ";
        String expected = "SELECT \"product_class_id\", \"product_id\", COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\", \"product_id\"";
        this.sql(query).ok("SELECT \"product_class_id\", \"product_id\", COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\", \"product_id\"");
    }

    @Test
    public void testSelectQueryWithGroupByAndProjectList1() {
        String query = "select count(*)  from \"product\" group by \"product_class_id\", \"product_id\"";
        String expected = "SELECT COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\", \"product_id\"";
        this.sql(query).ok("SELECT COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\", \"product_id\"");
    }

    @Test
    public void testSelectQueryWithGroupByHaving() {
        String query = "select count(*) from \"product\" group by \"product_class_id\", \"product_id\"  having \"product_id\"  > 10";
        String expected = "SELECT COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\", \"product_id\"\nHAVING \"product_id\" > 10";
        this.sql(query).ok("SELECT COUNT(*)\nFROM \"foodmart\".\"product\"\nGROUP BY \"product_class_id\", \"product_id\"\nHAVING \"product_id\" > 10");
    }

    @Test
    public void testSelectQueryWithGroupByHaving2() {
        String query = " select \"product\".\"product_id\",\n    min(\"sales_fact_1997\".\"store_id\")\n    from \"product\"\n    inner join \"sales_fact_1997\"\n    on \"product\".\"product_id\" = \"sales_fact_1997\".\"product_id\"\n    group by \"product\".\"product_id\"\n    having count(*) > 1";
        String expected = "SELECT \"product\".\"product_id\", MIN(\"sales_fact_1997\".\"store_id\")\nFROM \"foodmart\".\"product\"\nINNER JOIN \"foodmart\".\"sales_fact_1997\" ON \"product\".\"product_id\" = \"sales_fact_1997\".\"product_id\"\nGROUP BY \"product\".\"product_id\"\nHAVING COUNT(*) > 1";
        this.sql(query).ok(expected);
    }

    @Test
    public void testSelectQueryWithGroupByHaving3() {
        String query = " select * from (select \"product\".\"product_id\",\n    min(\"sales_fact_1997\".\"store_id\")\n    from \"product\"\n    inner join \"sales_fact_1997\"\n    on \"product\".\"product_id\" = \"sales_fact_1997\".\"product_id\"\n    group by \"product\".\"product_id\"\n    having count(*) > 1) where \"product_id\" > 100";
        String expected = "SELECT *\nFROM (SELECT \"product\".\"product_id\", MIN(\"sales_fact_1997\".\"store_id\")\nFROM \"foodmart\".\"product\"\nINNER JOIN \"foodmart\".\"sales_fact_1997\" ON \"product\".\"product_id\" = \"sales_fact_1997\".\"product_id\"\nGROUP BY \"product\".\"product_id\"\nHAVING COUNT(*) > 1) AS \"t2\"\nWHERE \"t2\".\"product_id\" > 100";
        this.sql(query).ok(expected);
    }

    @Test
    public void testSelectQueryWithOrderByClause() {
        String query = "select \"product_id\"  from \"product\" order by \"net_weight\"";
        String expected = "SELECT \"product_id\", \"net_weight\"\nFROM \"foodmart\".\"product\"\nORDER BY \"net_weight\"";
        this.sql(query).ok("SELECT \"product_id\", \"net_weight\"\nFROM \"foodmart\".\"product\"\nORDER BY \"net_weight\"");
    }

    @Test
    public void testSelectQueryWithOrderByClause1() {
        String query = "select \"product_id\", \"net_weight\" from \"product\" order by \"net_weight\"";
        String expected = "SELECT \"product_id\", \"net_weight\"\nFROM \"foodmart\".\"product\"\nORDER BY \"net_weight\"";
        this.sql(query).ok("SELECT \"product_id\", \"net_weight\"\nFROM \"foodmart\".\"product\"\nORDER BY \"net_weight\"");
    }

    @Test
    public void testSelectQueryWithTwoOrderByClause() {
        String query = "select \"product_id\"  from \"product\" order by \"net_weight\", \"gross_weight\"";
        String expected = "SELECT \"product_id\", \"net_weight\", \"gross_weight\"\nFROM \"foodmart\".\"product\"\nORDER BY \"net_weight\", \"gross_weight\"";
        this.sql(query).ok("SELECT \"product_id\", \"net_weight\", \"gross_weight\"\nFROM \"foodmart\".\"product\"\nORDER BY \"net_weight\", \"gross_weight\"");
    }

    @Test
    public void testSelectQueryWithAscDescOrderByClause() {
        String query = "select \"product_id\" from \"product\" order by \"net_weight\" asc, \"gross_weight\" desc, \"low_fat\"";
        String expected = "SELECT \"product_id\", \"net_weight\", \"gross_weight\", \"low_fat\"\nFROM \"foodmart\".\"product\"\nORDER BY \"net_weight\", \"gross_weight\" DESC, \"low_fat\"";
        this.sql(query).ok("SELECT \"product_id\", \"net_weight\", \"gross_weight\", \"low_fat\"\nFROM \"foodmart\".\"product\"\nORDER BY \"net_weight\", \"gross_weight\" DESC, \"low_fat\"");
    }

    @Test
    public void testSelectQueryWithLimitClause() {
        String query = "select \"product_id\"  from \"product\" limit 100 offset 10";
        String expected = "SELECT product_id\nFROM foodmart.product\nLIMIT 100\nOFFSET 10";
        this.sql(query).dialect(SqlDialect.DatabaseProduct.HIVE.getDialect()).ok("SELECT product_id\nFROM foodmart.product\nLIMIT 100\nOFFSET 10");
    }

    @Test
    public void testSelectQueryWithLimitClauseWithoutOrder() {
        String query = "select \"product_id\"  from \"product\" limit 100 offset 10";
        String expected = "SELECT \"product_id\"\nFROM \"foodmart\".\"product\"\nOFFSET 10 ROWS\nFETCH NEXT 100 ROWS ONLY";
        this.sql(query).ok("SELECT \"product_id\"\nFROM \"foodmart\".\"product\"\nOFFSET 10 ROWS\nFETCH NEXT 100 ROWS ONLY");
    }

    @Test
    public void testSelectQueryWithLimitOffsetClause() {
        String query = "select \"product_id\"  from \"product\" order by \"net_weight\" asc limit 100 offset 10";
        String expected = "SELECT \"product_id\", \"net_weight\"\nFROM \"foodmart\".\"product\"\nORDER BY \"net_weight\"\nOFFSET 10 ROWS\nFETCH NEXT 100 ROWS ONLY";
        this.sql(query).ok("SELECT \"product_id\", \"net_weight\"\nFROM \"foodmart\".\"product\"\nORDER BY \"net_weight\"\nOFFSET 10 ROWS\nFETCH NEXT 100 ROWS ONLY");
    }

    @Test
    public void testSelectQueryWithFetchOffsetClause() {
        String query = "select \"product_id\"  from \"product\" order by \"product_id\" offset 10 rows fetch next 100 rows only";
        String expected = "SELECT \"product_id\"\nFROM \"foodmart\".\"product\"\nORDER BY \"product_id\"\nOFFSET 10 ROWS\nFETCH NEXT 100 ROWS ONLY";
        this.sql(query).ok("SELECT \"product_id\"\nFROM \"foodmart\".\"product\"\nORDER BY \"product_id\"\nOFFSET 10 ROWS\nFETCH NEXT 100 ROWS ONLY");
    }

    @Test
    public void testSelectQueryComplex() {
        String query = "select count(*), \"units_per_case\" from \"product\" where \"cases_per_pallet\" > 100 group by \"product_id\", \"units_per_case\" order by \"units_per_case\" desc";
        String expected = "SELECT COUNT(*), \"units_per_case\"\nFROM \"foodmart\".\"product\"\nWHERE \"cases_per_pallet\" > 100\nGROUP BY \"product_id\", \"units_per_case\"\nORDER BY \"units_per_case\" DESC";
        this.sql(query).ok("SELECT COUNT(*), \"units_per_case\"\nFROM \"foodmart\".\"product\"\nWHERE \"cases_per_pallet\" > 100\nGROUP BY \"product_id\", \"units_per_case\"\nORDER BY \"units_per_case\" DESC");
    }

    @Test
    public void testSelectQueryWithGroup() {
        String query = "select count(*), sum(\"employee_id\") from \"reserve_employee\" where \"hire_date\" > '2015-01-01' and (\"position_title\" = 'SDE' or \"position_title\" = 'SDM') group by \"store_id\", \"position_title\"";
        String expected = "SELECT COUNT(*), SUM(\"employee_id\")\nFROM \"foodmart\".\"reserve_employee\"\nWHERE \"hire_date\" > '2015-01-01' AND (\"position_title\" = 'SDE' OR \"position_title\" = 'SDM')\nGROUP BY \"store_id\", \"position_title\"";
        this.sql(query).ok("SELECT COUNT(*), SUM(\"employee_id\")\nFROM \"foodmart\".\"reserve_employee\"\nWHERE \"hire_date\" > '2015-01-01' AND (\"position_title\" = 'SDE' OR \"position_title\" = 'SDM')\nGROUP BY \"store_id\", \"position_title\"");
    }

    @Test
    public void testSimpleJoin() {
        String query = "select *\nfrom \"sales_fact_1997\" as s\n  join \"customer\" as c using (\"customer_id\")\n  join \"product\" as p using (\"product_id\")\n  join \"product_class\" as pc using (\"product_class_id\")\nwhere c.\"city\" = 'San Francisco'\nand pc.\"product_department\" = 'Snacks'\n";
        String expected = "SELECT *\nFROM \"foodmart\".\"sales_fact_1997\"\nINNER JOIN \"foodmart\".\"customer\" ON \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\"\nINNER JOIN \"foodmart\".\"product\" ON \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\nINNER JOIN \"foodmart\".\"product_class\" ON \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\nWHERE \"customer\".\"city\" = 'San Francisco' AND \"product_class\".\"product_department\" = 'Snacks'";
        this.sql(query).ok("SELECT *\nFROM \"foodmart\".\"sales_fact_1997\"\nINNER JOIN \"foodmart\".\"customer\" ON \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\"\nINNER JOIN \"foodmart\".\"product\" ON \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\nINNER JOIN \"foodmart\".\"product_class\" ON \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\nWHERE \"customer\".\"city\" = 'San Francisco' AND \"product_class\".\"product_department\" = 'Snacks'");
    }

    @Test
    public void testSubQueryAlias() {
        String query = "select t1.\"customer_id\", t2.\"customer_id\" \nfrom (select \"customer_id\" from \"sales_fact_1997\") as t1 \ninner join (select \"customer_id\" from \"sales_fact_1997\") t2 \non t1.\"customer_id\" = t2.\"customer_id\"";
        String expected = "SELECT *\nFROM (SELECT sales_fact_1997.customer_id\nFROM foodmart.sales_fact_1997 AS sales_fact_1997) AS t\nINNER JOIN (SELECT sales_fact_19970.customer_id\nFROM foodmart.sales_fact_1997 AS sales_fact_19970) AS t0 ON t.customer_id = t0.customer_id";
        this.sql(query).dialect(SqlDialect.DatabaseProduct.DB2.getDialect()).ok("SELECT *\nFROM (SELECT sales_fact_1997.customer_id\nFROM foodmart.sales_fact_1997 AS sales_fact_1997) AS t\nINNER JOIN (SELECT sales_fact_19970.customer_id\nFROM foodmart.sales_fact_1997 AS sales_fact_19970) AS t0 ON t.customer_id = t0.customer_id");
    }

    @Test
    public void testCartesianProductWithCommaSyntax() {
        String query = "select * from \"department\" , \"employee\"";
        String expected = "SELECT *\nFROM \"foodmart\".\"department\",\n\"foodmart\".\"employee\"";
        this.sql(query).ok(expected);
    }

    @Test
    public void testCartesianProductWithInnerJoinSyntax() {
        String query = "select * from \"department\"\nINNER JOIN \"employee\" ON TRUE";
        String expected = "SELECT *\nFROM \"foodmart\".\"department\",\n\"foodmart\".\"employee\"";
        this.sql(query).ok(expected);
    }

    @Test
    public void testFullJoinOnTrueCondition() {
        String query = "select * from \"department\"\nFULL JOIN \"employee\" ON TRUE";
        String expected = "SELECT *\nFROM \"foodmart\".\"department\"\nFULL JOIN \"foodmart\".\"employee\" ON TRUE";
        this.sql(query).ok(expected);
    }

    @Test
    public void testSimpleIn() {
        String query = "select * from \"department\" where \"department_id\" in (\n  select \"department_id\" from \"employee\"\n  where \"store_id\" < 150)";
        String expected = "SELECT \"department\".\"department_id\", \"department\".\"department_description\"\nFROM \"foodmart\".\"department\"\nINNER JOIN (SELECT \"department_id\"\nFROM \"foodmart\".\"employee\"\nWHERE \"store_id\" < 150\nGROUP BY \"department_id\") AS \"t1\" ON \"department\".\"department_id\" = \"t1\".\"department_id\"";
        this.sql(query).ok("SELECT \"department\".\"department_id\", \"department\".\"department_description\"\nFROM \"foodmart\".\"department\"\nINNER JOIN (SELECT \"department_id\"\nFROM \"foodmart\".\"employee\"\nWHERE \"store_id\" < 150\nGROUP BY \"department_id\") AS \"t1\" ON \"department\".\"department_id\" = \"t1\".\"department_id\"");
    }

    @Test
    public void testDb2DialectJoinStar() {
        String query = "select * from \"foodmart\".\"employee\" A join \"foodmart\".\"department\" B\non A.\"department_id\" = B.\"department_id\"";
        String expected = "SELECT *\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.department AS department ON employee.department_id = department.department_id";
        this.sql(query).dialect(SqlDialect.DatabaseProduct.DB2.getDialect()).ok("SELECT *\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.department AS department ON employee.department_id = department.department_id");
    }

    @Test
    public void testDb2DialectSelfJoinStar() {
        String query = "select * from \"foodmart\".\"employee\" A join \"foodmart\".\"employee\" B\non A.\"department_id\" = B.\"department_id\"";
        String expected = "SELECT *\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.employee AS employee0 ON employee.department_id = employee0.department_id";
        this.sql(query).dialect(SqlDialect.DatabaseProduct.DB2.getDialect()).ok("SELECT *\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.employee AS employee0 ON employee.department_id = employee0.department_id");
    }

    @Test
    public void testDb2DialectJoin() {
        String query = "select A.\"employee_id\", B.\"department_id\" from \"foodmart\".\"employee\" A join \"foodmart\".\"department\" B\non A.\"department_id\" = B.\"department_id\"";
        String expected = "SELECT employee.employee_id, department.department_id\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.department AS department ON employee.department_id = department.department_id";
        this.sql(query).dialect(SqlDialect.DatabaseProduct.DB2.getDialect()).ok("SELECT employee.employee_id, department.department_id\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.department AS department ON employee.department_id = department.department_id");
    }

    @Test
    public void testDb2DialectSelfJoin() {
        String query = "select A.\"employee_id\", B.\"employee_id\" from \"foodmart\".\"employee\" A join \"foodmart\".\"employee\" B\non A.\"department_id\" = B.\"department_id\"";
        String expected = "SELECT employee.employee_id, employee0.employee_id AS employee_id0\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.employee AS employee0 ON employee.department_id = employee0.department_id";
        this.sql(query).dialect(SqlDialect.DatabaseProduct.DB2.getDialect()).ok("SELECT employee.employee_id, employee0.employee_id AS employee_id0\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.employee AS employee0 ON employee.department_id = employee0.department_id");
    }

    @Test
    public void testDb2DialectWhere() {
        String query = "select A.\"employee_id\" from \"foodmart\".\"employee\" A where A.\"department_id\" < 1000";
        String expected = "SELECT employee.employee_id\nFROM foodmart.employee AS employee\nWHERE employee.department_id < 1000";
        this.sql(query).dialect(SqlDialect.DatabaseProduct.DB2.getDialect()).ok("SELECT employee.employee_id\nFROM foodmart.employee AS employee\nWHERE employee.department_id < 1000");
    }

    @Test
    public void testDb2DialectJoinWhere() {
        String query = "select A.\"employee_id\", B.\"department_id\" from \"foodmart\".\"employee\" A join \"foodmart\".\"department\" B\non A.\"department_id\" = B.\"department_id\" where A.\"employee_id\" < 1000";
        String expected = "SELECT employee.employee_id, department.department_id\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.department AS department ON employee.department_id = department.department_id\nWHERE employee.employee_id < 1000";
        this.sql(query).dialect(SqlDialect.DatabaseProduct.DB2.getDialect()).ok("SELECT employee.employee_id, department.department_id\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.department AS department ON employee.department_id = department.department_id\nWHERE employee.employee_id < 1000");
    }

    @Test
    public void testDb2DialectSelfJoinWhere() {
        String query = "select A.\"employee_id\", B.\"employee_id\" from \"foodmart\".\"employee\" A join \"foodmart\".\"employee\" B\non A.\"department_id\" = B.\"department_id\" where B.\"employee_id\" < 2000";
        String expected = "SELECT employee.employee_id, employee0.employee_id AS employee_id0\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.employee AS employee0 ON employee.department_id = employee0.department_id\nWHERE employee0.employee_id < 2000";
        this.sql(query).dialect(SqlDialect.DatabaseProduct.DB2.getDialect()).ok("SELECT employee.employee_id, employee0.employee_id AS employee_id0\nFROM foodmart.employee AS employee\nINNER JOIN foodmart.employee AS employee0 ON employee.department_id = employee0.department_id\nWHERE employee0.employee_id < 2000");
    }

    @Test
    public void testDb2DialectCast() {
        String query = "select \"hire_date\", cast(\"hire_date\" as varchar(10)) from \"foodmart\".\"reserve_employee\"";
        String expected = "SELECT reserve_employee.hire_date, CAST(reserve_employee.hire_date AS VARCHAR(10))\nFROM foodmart.reserve_employee AS reserve_employee";
        this.sql(query).dialect(SqlDialect.DatabaseProduct.DB2.getDialect()).ok("SELECT reserve_employee.hire_date, CAST(reserve_employee.hire_date AS VARCHAR(10))\nFROM foodmart.reserve_employee AS reserve_employee");
    }

    @Test
    public void testDb2DialectSelectQueryWithGroupByHaving() {
        String query = "select count(*) from \"product\" group by \"product_class_id\", \"product_id\" having \"product_id\"  > 10";
        String expected = "SELECT COUNT(*)\nFROM foodmart.product AS product\nGROUP BY product.product_class_id, product.product_id\nHAVING product.product_id > 10";
        this.sql(query).dialect(SqlDialect.DatabaseProduct.DB2.getDialect()).ok("SELECT COUNT(*)\nFROM foodmart.product AS product\nGROUP BY product.product_class_id, product.product_id\nHAVING product.product_id > 10");
    }

    @Test
    public void testDb2DialectSelectQueryComplex() {
        String query = "select count(*), \"units_per_case\" from \"product\" where \"cases_per_pallet\" > 100 group by \"product_id\", \"units_per_case\" order by \"units_per_case\" desc";
        String expected = "SELECT COUNT(*), product.units_per_case\nFROM foodmart.product AS product\nWHERE product.cases_per_pallet > 100\nGROUP BY product.product_id, product.units_per_case\nORDER BY product.units_per_case DESC";
        this.sql(query).dialect(SqlDialect.DatabaseProduct.DB2.getDialect()).ok("SELECT COUNT(*), product.units_per_case\nFROM foodmart.product AS product\nWHERE product.cases_per_pallet > 100\nGROUP BY product.product_id, product.units_per_case\nORDER BY product.units_per_case DESC");
    }

    @Test
    public void testDb2DialectSelectQueryWithGroup() {
        String query = "select count(*), sum(\"employee_id\") from \"reserve_employee\" where \"hire_date\" > '2015-01-01' and (\"position_title\" = 'SDE' or \"position_title\" = 'SDM') group by \"store_id\", \"position_title\"";
        String expected = "SELECT COUNT(*), SUM(reserve_employee.employee_id)\nFROM foodmart.reserve_employee AS reserve_employee\nWHERE reserve_employee.hire_date > '2015-01-01' AND (reserve_employee.position_title = 'SDE' OR reserve_employee.position_title = 'SDM')\nGROUP BY reserve_employee.store_id, reserve_employee.position_title";
        this.sql(query).dialect(SqlDialect.DatabaseProduct.DB2.getDialect()).ok("SELECT COUNT(*), SUM(reserve_employee.employee_id)\nFROM foodmart.reserve_employee AS reserve_employee\nWHERE reserve_employee.hire_date > '2015-01-01' AND (reserve_employee.position_title = 'SDE' OR reserve_employee.position_title = 'SDM')\nGROUP BY reserve_employee.store_id, reserve_employee.position_title");
    }

    @Test
    public void testJoinPlan2() {
        String sql = "SELECT v1.deptno, v2.deptno\nFROM dept v1 LEFT JOIN emp v2 ON v1.deptno = v2.deptno\nWHERE v2.job LIKE 'PRESIDENT'";
        String expected = "SELECT \"DEPT\".\"DEPTNO\", \"EMP\".\"DEPTNO\" AS \"DEPTNO0\"\nFROM \"JDBC_SCOTT\".\"DEPT\"\nLEFT JOIN \"JDBC_SCOTT\".\"EMP\" ON \"DEPT\".\"DEPTNO\" = \"EMP\".\"DEPTNO\"\nWHERE \"EMP\".\"JOB\" LIKE 'PRESIDENT'";
        String expected2 = "SELECT DEPT.DEPTNO, EMP.DEPTNO AS DEPTNO0\nFROM JDBC_SCOTT.DEPT AS DEPT\nLEFT JOIN JDBC_SCOTT.EMP AS EMP ON DEPT.DEPTNO = EMP.DEPTNO\nWHERE EMP.JOB LIKE 'PRESIDENT'";
        this.sql("SELECT v1.deptno, v2.deptno\nFROM dept v1 LEFT JOIN emp v2 ON v1.deptno = v2.deptno\nWHERE v2.job LIKE 'PRESIDENT'").schema(CalciteAssert.SchemaSpec.JDBC_SCOTT).ok("SELECT \"DEPT\".\"DEPTNO\", \"EMP\".\"DEPTNO\" AS \"DEPTNO0\"\nFROM \"JDBC_SCOTT\".\"DEPT\"\nLEFT JOIN \"JDBC_SCOTT\".\"EMP\" ON \"DEPT\".\"DEPTNO\" = \"EMP\".\"DEPTNO\"\nWHERE \"EMP\".\"JOB\" LIKE 'PRESIDENT'").dialect(SqlDialect.DatabaseProduct.DB2.getDialect()).ok("SELECT DEPT.DEPTNO, EMP.DEPTNO AS DEPTNO0\nFROM JDBC_SCOTT.DEPT AS DEPT\nLEFT JOIN JDBC_SCOTT.EMP AS EMP ON DEPT.DEPTNO = EMP.DEPTNO\nWHERE EMP.JOB LIKE 'PRESIDENT'");
    }

    @Test
    public void testSimpleJoinConditionWithIsNullOperators() {
        String query = "select *\nfrom \"foodmart\".\"sales_fact_1997\" as \"t1\"\ninner join \"foodmart\".\"customer\" as \"t2\"\non \"t1\".\"customer_id\" = \"t2\".\"customer_id\" or (\"t1\".\"customer_id\" is null and \"t2\".\"customer_id\" is null) or\n\"t2\".\"occupation\" is null\ninner join \"foodmart\".\"product\" as \"t3\"\non \"t1\".\"product_id\" = \"t3\".\"product_id\" or (\"t1\".\"product_id\" is not null or \"t3\".\"product_id\" is not null)";
        String expected = "SELECT *\nFROM \"foodmart\".\"sales_fact_1997\"\nINNER JOIN \"foodmart\".\"customer\" ON \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\" OR FALSE AND FALSE OR \"customer\".\"occupation\" IS NULL\nINNER JOIN \"foodmart\".\"product\" ON \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\" OR TRUE OR TRUE";
        this.sql(query).ok(expected);
    }

    @Test
    public void testThreeQueryUnion() {
        String query = "SELECT \"product_id\" FROM \"product\"  UNION ALL SELECT \"product_id\" FROM \"sales_fact_1997\"  UNION ALL SELECT \"product_class_id\" AS product_id FROM \"product_class\"";
        String expected = "SELECT \"product_id\"\nFROM \"foodmart\".\"product\"\nUNION ALL\nSELECT \"product_id\"\nFROM \"foodmart\".\"sales_fact_1997\"\nUNION ALL\nSELECT \"product_class_id\" AS \"PRODUCT_ID\"\nFROM \"foodmart\".\"product_class\"";
        HepProgram program = new HepProgramBuilder().addRuleClass(UnionMergeRule.class).build();
        RuleSet rules = RuleSets.ofList((RelOptRule[])new RelOptRule[]{UnionMergeRule.INSTANCE});
        this.sql(query).optimize(rules, (RelOptPlanner)new HepPlanner(program)).ok(expected);
    }

    @Test
    public void testUnionWrappedInASelect() {
        String query = "select sum(\n  case when \"product_id\"=0 then \"net_weight\" else 0 end) as net_weight\nfrom (\n  select \"product_id\", \"net_weight\"\n  from \"product\"\n  union all\n  select \"product_id\", 0 as \"net_weight\"\n  from \"sales_fact_1997\") t0";
        String expected = "SELECT SUM(CASE WHEN \"product_id\" = 0 THEN \"net_weight\" ELSE 0 END) AS \"NET_WEIGHT\"\nFROM (SELECT \"product_id\", \"net_weight\"\nFROM \"foodmart\".\"product\"\nUNION ALL\nSELECT \"product_id\", 0 AS \"net_weight\"\nFROM \"foodmart\".\"sales_fact_1997\") AS \"t1\"";
        this.sql("select sum(\n  case when \"product_id\"=0 then \"net_weight\" else 0 end) as net_weight\nfrom (\n  select \"product_id\", \"net_weight\"\n  from \"product\"\n  union all\n  select \"product_id\", 0 as \"net_weight\"\n  from \"sales_fact_1997\") t0").ok("SELECT SUM(CASE WHEN \"product_id\" = 0 THEN \"net_weight\" ELSE 0 END) AS \"NET_WEIGHT\"\nFROM (SELECT \"product_id\", \"net_weight\"\nFROM \"foodmart\".\"product\"\nUNION ALL\nSELECT \"product_id\", 0 AS \"net_weight\"\nFROM \"foodmart\".\"sales_fact_1997\") AS \"t1\"");
    }

    @Test
    public void testLiteral() {
        this.checkLiteral("DATE '1978-05-02'");
        this.checkLiteral("TIME '12:34:56'");
        this.checkLiteral("TIME '12:34:56.78'");
        this.checkLiteral("TIMESTAMP '1978-05-02 12:34:56.78'");
        this.checkLiteral("'I can''t explain'");
        this.checkLiteral("''");
        this.checkLiteral("TRUE");
        this.checkLiteral("123");
        this.checkLiteral("123.45");
        this.checkLiteral("-123.45");
    }

    private void checkLiteral(String s) {
        this.sql("VALUES " + s).dialect(SqlDialect.DatabaseProduct.HSQLDB.getDialect()).ok("SELECT *\nFROM (VALUES  (" + s + "))");
    }

    @Test
    public void testFloor() {
        String query = "SELECT floor(\"hire_date\" TO MINUTE) FROM \"employee\"";
        String expected = "SELECT TRUNC(hire_date, 'MI')\nFROM foodmart.employee";
        this.sql(query).dialect(SqlDialect.DatabaseProduct.HSQLDB.getDialect()).ok(expected);
    }

    @Test
    public void testFloorPostgres() {
        String query = "SELECT floor(\"hire_date\" TO MINUTE) FROM \"employee\"";
        String expected = "SELECT DATE_TRUNC('MINUTE', \"hire_date\")\nFROM \"foodmart\".\"employee\"";
        this.sql(query).dialect(SqlDialect.DatabaseProduct.POSTGRESQL.getDialect()).ok(expected);
    }

    @Test
    public void testFloorOracle() {
        String query = "SELECT floor(\"hire_date\" TO MINUTE) FROM \"employee\"";
        String expected = "SELECT TRUNC(\"hire_date\", 'MINUTE')\nFROM \"foodmart\".\"employee\"";
        this.sql(query).dialect(SqlDialect.DatabaseProduct.ORACLE.getDialect()).ok(expected);
    }

    @Test
    public void testFloorMssqlWeek() {
        String query = "SELECT floor(\"hire_date\" TO WEEK) FROM \"employee\"";
        String expected = "SELECT CONVERT(DATETIME, CONVERT(VARCHAR(10), DATEADD(day, - (6 + DATEPART(weekday, [hire_date] )) % 7, [hire_date] ), 126))\nFROM [foodmart].[employee]";
        this.sql(query).dialect(SqlDialect.DatabaseProduct.MSSQL.getDialect()).ok(expected);
    }

    @Test
    public void testFloorMssqlMonth() {
        String query = "SELECT floor(\"hire_date\" TO MONTH) FROM \"employee\"";
        String expected = "SELECT CONVERT(DATETIME, CONVERT(VARCHAR(7), [hire_date] , 126)+'-01')\nFROM [foodmart].[employee]";
        this.sql(query).dialect(SqlDialect.DatabaseProduct.MSSQL.getDialect()).ok(expected);
    }

    @Test
    public void testFloorMysqlMonth() {
        String query = "SELECT floor(\"hire_date\" TO MONTH) FROM \"employee\"";
        String expected = "SELECT DATE_FORMAT(`hire_date`, '%Y-%m-01')\nFROM `foodmart`.`employee`";
        this.sql(query).dialect(SqlDialect.DatabaseProduct.MYSQL.getDialect()).ok(expected);
    }

    @Test
    public void testFloorMysqlWeek() {
        String query = "SELECT floor(\"hire_date\" TO WEEK) FROM \"employee\"";
        String expected = "SELECT STR_TO_DATE(DATE_FORMAT(`hire_date` , '%x%v-1'), '%x%v-%w')\nFROM `foodmart`.`employee`";
        this.sql(query).dialect(SqlDialect.DatabaseProduct.MYSQL.getDialect()).ok(expected);
    }

    @Test
    public void testMatchRecognizePatternExpression() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    partition by \"product_class_id\", \"brand_name\" \n    order by \"product_class_id\" asc, \"brand_name\" desc \n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nPARTITION BY \"product_class_id\", \"brand_name\"\nORDER BY \"product_class_id\", \"brand_name\" DESC\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql(sql).ok(expected);
    }

    @Test
    public void testMatchRecognizePatternExpression2() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+$)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" + $)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+$)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" + $)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizePatternExpression3() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (^strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (^ \"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (^strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (^ \"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizePatternExpression4() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (^strt down+ up+$)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (^ \"STRT\" \"DOWN\" + \"UP\" + $)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (^strt down+ up+$)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (^ \"STRT\" \"DOWN\" + \"UP\" + $)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizePatternExpression5() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down* up?)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" * \"UP\" ?)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down* up?)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" * \"UP\" ?)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizePatternExpression6() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (strt {-down-} up?)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" {- \"DOWN\" -} \"UP\" ?)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (strt {-down-} up?)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" {- \"DOWN\" -} \"UP\" ?)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizePatternExpression7() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down{2} up{3,})\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" { 2 } \"UP\" { 3, })\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down{2} up{3,})\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" { 2 } \"UP\" { 3, })\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizePatternExpression8() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down{,2} up{3,5})\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" { , 2 } \"UP\" { 3, 5 })\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down{,2} up{3,5})\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" { , 2 } \"UP\" { 3, 5 })\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizePatternExpression9() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (strt {-down+-} {-up*-})\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" {- \"DOWN\" + -} {- \"UP\" * -})\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (strt {-down+-} {-up*-})\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" {- \"DOWN\" + -} {- \"UP\" * -})\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizePatternExpression10() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (A B C | A C B | B A C | B C A | C A B | C B A)\n    define\n      A as A.\"net_weight\" < PREV(A.\"net_weight\"),\n      B as B.\"net_weight\" > PREV(B.\"net_weight\"),\n      C as C.\"net_weight\" < PREV(C.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"A\" \"B\" \"C\" | \"A\" \"C\" \"B\" | \"B\" \"A\" \"C\" | \"B\" \"C\" \"A\" | \"C\" \"A\" \"B\" | \"C\" \"B\" \"A\")\nDEFINE \"A\" AS PREV(\"A\".\"net_weight\", 0) < PREV(\"A\".\"net_weight\", 1), \"B\" AS PREV(\"B\".\"net_weight\", 0) > PREV(\"B\".\"net_weight\", 1), \"C\" AS PREV(\"C\".\"net_weight\", 0) < PREV(\"C\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (A B C | A C B | B A C | B C A | C A B | C B A)\n    define\n      A as A.\"net_weight\" < PREV(A.\"net_weight\"),\n      B as B.\"net_weight\" > PREV(B.\"net_weight\"),\n      C as C.\"net_weight\" < PREV(C.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"A\" \"B\" \"C\" | \"A\" \"C\" \"B\" | \"B\" \"A\" \"C\" | \"B\" \"C\" \"A\" | \"C\" \"A\" \"B\" | \"C\" \"B\" \"A\")\nDEFINE \"A\" AS PREV(\"A\".\"net_weight\", 0) < PREV(\"A\".\"net_weight\", 1), \"B\" AS PREV(\"B\".\"net_weight\", 0) > PREV(\"B\".\"net_weight\", 1), \"C\" AS PREV(\"C\".\"net_weight\", 0) < PREV(\"C\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizePatternExpression11() {
        String sql = "select *\n  from (select * from \"product\") match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from (select * from \"product\") match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizePatternExpression12() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr order by MR.\"net_weight\"";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))\nORDER BY \"net_weight\"";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr order by MR.\"net_weight\"").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))\nORDER BY \"net_weight\"");
    }

    @Test
    public void testMatchRecognizePatternExpression13() {
        String sql = "select *\n  from (\nselect *\nfrom \"sales_fact_1997\" as s\njoin \"customer\" as c using (\"customer_id\")\njoin \"product\" as p using (\"product_id\")\njoin \"product_class\" as pc using (\"product_class_id\")\nwhere c.\"city\" = 'San Francisco'\nand pc.\"product_department\" = 'Snacks') match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr order by MR.\"net_weight\"";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"sales_fact_1997\"\nINNER JOIN \"foodmart\".\"customer\" ON \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\"\nINNER JOIN \"foodmart\".\"product\" ON \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\nINNER JOIN \"foodmart\".\"product_class\" ON \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\nWHERE \"customer\".\"city\" = 'San Francisco' AND \"product_class\".\"product_department\" = 'Snacks') MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))\nORDER BY \"net_weight\"";
        this.sql("select *\n  from (\nselect *\nfrom \"sales_fact_1997\" as s\njoin \"customer\" as c using (\"customer_id\")\njoin \"product\" as p using (\"product_id\")\njoin \"product_class\" as pc using (\"product_class_id\")\nwhere c.\"city\" = 'San Francisco'\nand pc.\"product_department\" = 'Snacks') match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr order by MR.\"net_weight\"").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"sales_fact_1997\"\nINNER JOIN \"foodmart\".\"customer\" ON \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\"\nINNER JOIN \"foodmart\".\"product\" ON \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\"\nINNER JOIN \"foodmart\".\"product_class\" ON \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\"\nWHERE \"customer\".\"city\" = 'San Francisco' AND \"product_class\".\"product_department\" = 'Snacks') MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))\nORDER BY \"net_weight\"");
    }

    @Test
    public void testMatchRecognizeDefineClause() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))");
    }

    @Test
    public void testMatchRecognizeDefineClause2() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < FIRST(down.\"net_weight\"),\n      up as up.\"net_weight\" > LAST(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < FIRST(\"DOWN\".\"net_weight\", 0), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > LAST(\"UP\".\"net_weight\", 0))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < FIRST(down.\"net_weight\"),\n      up as up.\"net_weight\" > LAST(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < FIRST(\"DOWN\".\"net_weight\", 0), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > LAST(\"UP\".\"net_weight\", 0))");
    }

    @Test
    public void testMatchRecognizeDefineClause3() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\",1),\n      up as up.\"net_weight\" > LAST(up.\"net_weight\" + up.\"gross_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > LAST(\"UP\".\"net_weight\", 0) + LAST(\"UP\".\"gross_weight\", 0))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\",1),\n      up as up.\"net_weight\" > LAST(up.\"net_weight\" + up.\"gross_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > LAST(\"UP\".\"net_weight\", 0) + LAST(\"UP\".\"gross_weight\", 0))");
    }

    @Test
    public void testMatchRecognizeDefineClause4() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\",1),\n      up as up.\"net_weight\" > PREV(LAST(up.\"net_weight\" + up.\"gross_weight\"),3)\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > LAST(\"UP\".\"net_weight\", 0) + LAST(\"UP\".\"gross_weight\", 0))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\",1),\n      up as up.\"net_weight\" > PREV(LAST(up.\"net_weight\" + up.\"gross_weight\"),3)\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > LAST(\"UP\".\"net_weight\", 0) + LAST(\"UP\".\"gross_weight\", 0))");
    }

    @Test
    public void testMatchRecognizeMeasures1() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures MATCH_NUMBER() as match_num,    CLASSIFIER() as var_match,    STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   LAST(up.\"net_weight\") as end_nw    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL MATCH_NUMBER () AS \"MATCH_NUM\", FINAL CLASSIFIER() AS \"VAR_MATCH\", FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL LAST(\"UP\".\"net_weight\", 0) AS \"END_NW\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures MATCH_NUMBER() as match_num,    CLASSIFIER() as var_match,    STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   LAST(up.\"net_weight\") as end_nw    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL MATCH_NUMBER () AS \"MATCH_NUM\", FINAL CLASSIFIER() AS \"VAR_MATCH\", FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL LAST(\"UP\".\"net_weight\", 0) AS \"END_NW\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizeMeasures2() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   FINAL LAST(DOWN.\"net_weight\") as bottom_nw,   LAST(up.\"net_weight\") as end_nw    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL LAST(\"UP\".\"net_weight\", 0) AS \"END_NW\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   FINAL LAST(DOWN.\"net_weight\") as bottom_nw,   LAST(up.\"net_weight\") as end_nw    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL LAST(\"UP\".\"net_weight\", 0) AS \"END_NW\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizeMeasures3() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   RUNNING LAST(DOWN.\"net_weight\") as bottom_nw,   LAST(up.\"net_weight\") as end_nw    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL (RUNNING LAST(\"DOWN\".\"net_weight\", 0)) AS \"BOTTOM_NW\", FINAL LAST(\"UP\".\"net_weight\", 0) AS \"END_NW\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   RUNNING LAST(DOWN.\"net_weight\") as bottom_nw,   LAST(up.\"net_weight\") as end_nw    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL (RUNNING LAST(\"DOWN\".\"net_weight\", 0)) AS \"BOTTOM_NW\", FINAL LAST(\"UP\".\"net_weight\", 0) AS \"END_NW\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizeMeasures4() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   FINAL COUNT(up.\"net_weight\") as up_cnt,   FINAL COUNT(\"net_weight\") as down_cnt,   RUNNING COUNT(\"net_weight\") as running_cnt    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL COUNT(\"UP\".\"net_weight\") AS \"UP_CNT\", FINAL COUNT(\"*\".\"net_weight\") AS \"DOWN_CNT\", FINAL (RUNNING COUNT(\"*\".\"net_weight\")) AS \"RUNNING_CNT\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   FINAL COUNT(up.\"net_weight\") as up_cnt,   FINAL COUNT(\"net_weight\") as down_cnt,   RUNNING COUNT(\"net_weight\") as running_cnt    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL COUNT(\"UP\".\"net_weight\") AS \"UP_CNT\", FINAL COUNT(\"*\".\"net_weight\") AS \"DOWN_CNT\", FINAL (RUNNING COUNT(\"*\".\"net_weight\")) AS \"RUNNING_CNT\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizeMeasures5() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures    FIRST(STRT.\"net_weight\") as start_nw,   LAST(UP.\"net_weight\") as up_cnt,   AVG(DOWN.\"net_weight\") as down_cnt    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL FIRST(\"STRT\".\"net_weight\", 0) AS \"START_NW\", FINAL LAST(\"UP\".\"net_weight\", 0) AS \"UP_CNT\", FINAL (SUM(\"DOWN\".\"net_weight\") / COUNT(\"DOWN\".\"net_weight\")) AS \"DOWN_CNT\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures    FIRST(STRT.\"net_weight\") as start_nw,   LAST(UP.\"net_weight\") as up_cnt,   AVG(DOWN.\"net_weight\") as down_cnt    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL FIRST(\"STRT\".\"net_weight\", 0) AS \"START_NW\", FINAL LAST(\"UP\".\"net_weight\", 0) AS \"UP_CNT\", FINAL (SUM(\"DOWN\".\"net_weight\") / COUNT(\"DOWN\".\"net_weight\")) AS \"DOWN_CNT\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizeMeasures6() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures    FIRST(STRT.\"net_weight\") as start_nw,   LAST(DOWN.\"net_weight\") as up_cnt,   FINAL SUM(DOWN.\"net_weight\") as down_cnt    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL FIRST(\"STRT\".\"net_weight\", 0) AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"UP_CNT\", FINAL SUM(\"DOWN\".\"net_weight\") AS \"DOWN_CNT\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures    FIRST(STRT.\"net_weight\") as start_nw,   LAST(DOWN.\"net_weight\") as up_cnt,   FINAL SUM(DOWN.\"net_weight\") as down_cnt    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL FIRST(\"STRT\".\"net_weight\", 0) AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"UP_CNT\", FINAL SUM(\"DOWN\".\"net_weight\") AS \"DOWN_CNT\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizeMeasures7() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures    FIRST(STRT.\"net_weight\") as start_nw,   LAST(DOWN.\"net_weight\") as up_cnt,   FINAL SUM(DOWN.\"net_weight\") as down_cnt    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr order by start_nw, up_cnt";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL FIRST(\"STRT\".\"net_weight\", 0) AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"UP_CNT\", FINAL SUM(\"DOWN\".\"net_weight\") AS \"DOWN_CNT\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))\nORDER BY \"START_NW\", \"UP_CNT\"";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures    FIRST(STRT.\"net_weight\") as start_nw,   LAST(DOWN.\"net_weight\") as up_cnt,   FINAL SUM(DOWN.\"net_weight\") as down_cnt    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr order by start_nw, up_cnt").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL FIRST(\"STRT\".\"net_weight\", 0) AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"UP_CNT\", FINAL SUM(\"DOWN\".\"net_weight\") AS \"DOWN_CNT\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))\nORDER BY \"START_NW\", \"UP_CNT\"");
    }

    @Test
    public void testMatchRecognizePatternSkip1() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    after match skip to next row\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    after match skip to next row\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))");
    }

    @Test
    public void testMatchRecognizePatternSkip2() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    after match skip past last row\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP PAST LAST ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    after match skip past last row\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP PAST LAST ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))");
    }

    @Test
    public void testMatchRecognizePatternSkip3() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    after match skip to FIRST down\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO FIRST \"DOWN\"\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    after match skip to FIRST down\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO FIRST \"DOWN\"\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))");
    }

    @Test
    public void testMatchRecognizePatternSkip4() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    after match skip to last down\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO LAST \"DOWN\"\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    after match skip to last down\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO LAST \"DOWN\"\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))");
    }

    @Test
    public void testMatchRecognizePatternSkip5() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    after match skip to down\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO LAST \"DOWN\"\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    after match skip to down\n    pattern (strt down+ up+)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO LAST \"DOWN\"\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))");
    }

    @Test
    public void testMatchRecognizeSubset1() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n    after match skip to down\n    pattern (strt down+ up+)\n    subset stdn = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO LAST \"DOWN\"\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n    after match skip to down\n    pattern (strt down+ up+)\n    subset stdn = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > NEXT(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nONE ROW PER MATCH\nAFTER MATCH SKIP TO LAST \"DOWN\"\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > NEXT(PREV(\"UP\".\"net_weight\", 0), 1))");
    }

    @Test
    public void testMatchRecognizeSubset2() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   AVG(STDN.\"net_weight\") as avg_stdn    pattern (strt down+ up+)\n    subset stdn = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL (SUM(\"STDN\".\"net_weight\") / COUNT(\"STDN\".\"net_weight\")) AS \"AVG_STDN\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   AVG(STDN.\"net_weight\") as avg_stdn    pattern (strt down+ up+)\n    subset stdn = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL (SUM(\"STDN\".\"net_weight\") / COUNT(\"STDN\".\"net_weight\")) AS \"AVG_STDN\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizeSubset3() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   SUM(STDN.\"net_weight\") as avg_stdn    pattern (strt down+ up+)\n    subset stdn = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL SUM(\"STDN\".\"net_weight\") AS \"AVG_STDN\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   SUM(STDN.\"net_weight\") as avg_stdn    pattern (strt down+ up+)\n    subset stdn = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL SUM(\"STDN\".\"net_weight\") AS \"AVG_STDN\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizeSubset4() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   SUM(STDN.\"net_weight\") as avg_stdn    pattern (strt down+ up+)\n    subset stdn = (strt, down), stdn2 = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL SUM(\"STDN\".\"net_weight\") AS \"AVG_STDN\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\"), \"STDN2\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   SUM(STDN.\"net_weight\") as avg_stdn    pattern (strt down+ up+)\n    subset stdn = (strt, down), stdn2 = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL SUM(\"STDN\".\"net_weight\") AS \"AVG_STDN\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\"), \"STDN2\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizeRowsPerMatch1() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   SUM(STDN.\"net_weight\") as avg_stdn    ONE ROW PER MATCH\n    pattern (strt down+ up+)\n    subset stdn = (strt, down), stdn2 = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL SUM(\"STDN\".\"net_weight\") AS \"AVG_STDN\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\"), \"STDN2\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   SUM(STDN.\"net_weight\") as avg_stdn    ONE ROW PER MATCH\n    pattern (strt down+ up+)\n    subset stdn = (strt, down), stdn2 = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES FINAL \"STRT\".\"net_weight\" AS \"START_NW\", FINAL LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", FINAL SUM(\"STDN\".\"net_weight\") AS \"AVG_STDN\"\nONE ROW PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\"), \"STDN2\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    @Test
    public void testMatchRecognizeRowsPerMatch2() {
        String sql = "select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   SUM(STDN.\"net_weight\") as avg_stdn    ALL ROWS PER MATCH\n    pattern (strt down+ up+)\n    subset stdn = (strt, down), stdn2 = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES RUNNING \"STRT\".\"net_weight\" AS \"START_NW\", RUNNING LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", RUNNING SUM(\"STDN\".\"net_weight\") AS \"AVG_STDN\"\nALL ROWS PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\"), \"STDN2\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))";
        this.sql("select *\n  from \"product\" match_recognize\n  (\n   measures STRT.\"net_weight\" as start_nw,   LAST(DOWN.\"net_weight\") as bottom_nw,   SUM(STDN.\"net_weight\") as avg_stdn    ALL ROWS PER MATCH\n    pattern (strt down+ up+)\n    subset stdn = (strt, down), stdn2 = (strt, down)\n    define\n      down as down.\"net_weight\" < PREV(down.\"net_weight\"),\n      up as up.\"net_weight\" > prev(up.\"net_weight\")\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM \"foodmart\".\"product\") MATCH_RECOGNIZE(\nMEASURES RUNNING \"STRT\".\"net_weight\" AS \"START_NW\", RUNNING LAST(\"DOWN\".\"net_weight\", 0) AS \"BOTTOM_NW\", RUNNING SUM(\"STDN\".\"net_weight\") AS \"AVG_STDN\"\nALL ROWS PER MATCH\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (\"STRT\" \"DOWN\" + \"UP\" +)\nSUBSET \"STDN\" = (\"DOWN\", \"STRT\"), \"STDN2\" = (\"DOWN\", \"STRT\")\nDEFINE \"DOWN\" AS PREV(\"DOWN\".\"net_weight\", 0) < PREV(\"DOWN\".\"net_weight\", 1), \"UP\" AS PREV(\"UP\".\"net_weight\", 0) > PREV(\"UP\".\"net_weight\", 1))");
    }

    private static class Sql {
        private CalciteAssert.SchemaSpec schemaSpec;
        private final String sql;
        private final SqlDialect dialect;
        private final List<Function<RelNode, RelNode>> transforms;

        Sql(CalciteAssert.SchemaSpec schemaSpec, String sql, SqlDialect dialect, List<Function<RelNode, RelNode>> transforms) {
            this.schemaSpec = schemaSpec;
            this.sql = sql;
            this.dialect = dialect;
            this.transforms = ImmutableList.copyOf(transforms);
        }

        Sql dialect(SqlDialect dialect) {
            return new Sql(this.schemaSpec, this.sql, dialect, this.transforms);
        }

        Sql optimize(final RuleSet ruleSet, final RelOptPlanner relOptPlanner) {
            return new Sql(this.schemaSpec, this.sql, this.dialect, FlatLists.append(this.transforms, (Object)new Function<RelNode, RelNode>(){

                public RelNode apply(RelNode r) {
                    Program program = Programs.of((RuleSet)ruleSet);
                    return program.run(relOptPlanner, r, r.getTraitSet(), (List)ImmutableList.of(), (List)ImmutableList.of());
                }
            }));
        }

        Sql ok(String expectedQuery) {
            Planner planner = RelToSqlConverterTest.getPlanner(null, SqlParser.Config.DEFAULT, this.schemaSpec, new Program[0]);
            try {
                SqlNode parse = planner.parse(this.sql);
                SqlNode validate = planner.validate(parse);
                RelNode rel = planner.rel((SqlNode)validate).rel;
                for (Function<RelNode, RelNode> transform : this.transforms) {
                    rel = (RelNode)transform.apply((Object)rel);
                }
                RelToSqlConverter converter = new RelToSqlConverter(this.dialect);
                SqlNode sqlNode = converter.visitChild(0, rel).asStatement();
                Assert.assertThat((Object)Util.toLinux((String)sqlNode.toSqlString(this.dialect).getSql()), (Matcher)CoreMatchers.is((Object)expectedQuery));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Sql schema(CalciteAssert.SchemaSpec schemaSpec) {
            return new Sql(schemaSpec, this.sql, this.dialect, this.transforms);
        }
    }
}

