/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSetOption;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SqlSetOptionOperatorTest {
    @Test
    public void testSqlSetOptionOperatorScopeSet() throws SqlParseException {
        SqlNode node = this.parse("alter system set optionA.optionB.optionC = true");
        SqlSetOptionOperatorTest.checkSqlSetOptionSame(node);
    }

    public SqlNode parse(String s) throws SqlParseException {
        return SqlParser.create((String)s).parseStmt();
    }

    @Test
    public void testSqlSetOptionOperatorSet() throws SqlParseException {
        SqlNode node = this.parse("set optionA.optionB.optionC = true");
        SqlSetOptionOperatorTest.checkSqlSetOptionSame(node);
    }

    @Test
    public void testSqlSetOptionOperatorScopeReset() throws SqlParseException {
        SqlNode node = this.parse("alter session reset param1.param2.param3");
        SqlSetOptionOperatorTest.checkSqlSetOptionSame(node);
    }

    @Test
    public void testSqlSetOptionOperatorReset() throws SqlParseException {
        SqlNode node = this.parse("reset param1.param2.param3");
        SqlSetOptionOperatorTest.checkSqlSetOptionSame(node);
    }

    private static void checkSqlSetOptionSame(SqlNode node) {
        SqlSetOption opt = (SqlSetOption)node;
        SqlNode[] sqlNodes = new SqlNode[opt.getOperandList().size()];
        SqlCall returned = opt.getOperator().createCall(opt.getFunctionQuantifier(), opt.getParserPosition(), opt.getOperandList().toArray(sqlNodes));
        Assert.assertThat(opt.getClass(), (Matcher)CoreMatchers.equalTo(returned.getClass()));
        SqlSetOption optRet = (SqlSetOption)returned;
        Assert.assertThat((Object)optRet.getScope(), (Matcher)CoreMatchers.is((Object)opt.getScope()));
        Assert.assertThat((Object)optRet.getName(), (Matcher)CoreMatchers.is((Object)opt.getName()));
        Assert.assertThat((Object)optRet.getFunctionQuantifier(), (Matcher)CoreMatchers.is((Object)opt.getFunctionQuantifier()));
        Assert.assertThat((Object)optRet.getParserPosition(), (Matcher)CoreMatchers.is((Object)opt.getParserPosition()));
        Assert.assertThat((Object)optRet.getValue(), (Matcher)CoreMatchers.is((Object)opt.getValue()));
        Assert.assertThat((Object)optRet.toString(), (Matcher)CoreMatchers.is((Object)opt.toString()));
    }
}

