/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.rules.CalcMergeRule;
import org.apache.calcite.rel.rules.CoerceInputsRule;
import org.apache.calcite.rel.rules.FilterToCalcRule;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.rules.ProjectToCalcRule;
import org.apache.calcite.rel.rules.UnionToDistinctRule;
import org.apache.calcite.test.DiffRepository;
import org.apache.calcite.test.RelOptTestBase;
import org.junit.Test;

public class HepPlannerTest
extends RelOptTestBase {
    private static final String UNION_TREE = "(select name from dept union select ename from emp) union (select ename from bonus)";

    @Override
    protected DiffRepository getDiffRepos() {
        return DiffRepository.lookup(HepPlannerTest.class);
    }

    @Test
    public void testRuleClass() throws Exception {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addRuleClass(CoerceInputsRule.class);
        HepPlanner planner = new HepPlanner(programBuilder.build());
        planner.addRule((RelOptRule)new CoerceInputsRule(LogicalUnion.class, false));
        planner.addRule((RelOptRule)new CoerceInputsRule(LogicalIntersect.class, false));
        this.checkPlanning((RelOptPlanner)planner, "(select name from dept union select ename from emp) intersect (select fname from customer.contact)");
    }

    @Test
    public void testRuleDescription() throws Exception {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addRuleByDescription("FilterToCalcRule");
        HepPlanner planner = new HepPlanner(programBuilder.build());
        planner.addRule((RelOptRule)FilterToCalcRule.INSTANCE);
        this.checkPlanning((RelOptPlanner)planner, "select name from sales.dept where deptno=12");
    }

    @Test
    public void testMatchLimitOneTopDown() throws Exception {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addMatchOrder(HepMatchOrder.TOP_DOWN);
        programBuilder.addMatchLimit(1);
        programBuilder.addRuleInstance((RelOptRule)UnionToDistinctRule.INSTANCE);
        this.checkPlanning(programBuilder.build(), UNION_TREE);
    }

    @Test
    public void testMatchLimitOneBottomUp() throws Exception {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addMatchLimit(1);
        programBuilder.addMatchOrder(HepMatchOrder.BOTTOM_UP);
        programBuilder.addRuleInstance((RelOptRule)UnionToDistinctRule.INSTANCE);
        this.checkPlanning(programBuilder.build(), UNION_TREE);
    }

    @Test
    public void testMatchUntilFixpoint() throws Exception {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addMatchLimit(Integer.MAX_VALUE);
        programBuilder.addRuleInstance((RelOptRule)UnionToDistinctRule.INSTANCE);
        this.checkPlanning(programBuilder.build(), UNION_TREE);
    }

    @Test
    public void testReplaceCommonSubexpression() throws Exception {
        this.checkPlanning((RelOptRule)ProjectRemoveRule.INSTANCE, "select d1.deptno from (select * from dept) d1, (select * from dept) d2");
    }

    @Test
    public void testSubprogram() throws Exception {
        HepProgramBuilder subprogramBuilder = HepProgram.builder();
        subprogramBuilder.addMatchOrder(HepMatchOrder.TOP_DOWN);
        subprogramBuilder.addMatchLimit(1);
        subprogramBuilder.addRuleInstance((RelOptRule)ProjectToCalcRule.INSTANCE);
        subprogramBuilder.addRuleInstance((RelOptRule)CalcMergeRule.INSTANCE);
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addSubprogram(subprogramBuilder.build());
        this.checkPlanning(programBuilder.build(), "select upper(ename) from (select lower(ename) as ename from emp)");
    }

    @Test
    public void testGroup() throws Exception {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addGroupBegin();
        programBuilder.addRuleInstance((RelOptRule)CalcMergeRule.INSTANCE);
        programBuilder.addRuleInstance((RelOptRule)ProjectToCalcRule.INSTANCE);
        programBuilder.addRuleInstance((RelOptRule)FilterToCalcRule.INSTANCE);
        programBuilder.addGroupEnd();
        this.checkPlanning(programBuilder.build(), "select upper(name) from dept where deptno=20");
    }
}

