/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.util.ImmutableBitSet;
import org.junit.Assert;
import org.junit.Test;

public class InduceGroupingTypeTest {
    @Test
    public void testInduceGroupingType() {
        ImmutableBitSet groupSet = ImmutableBitSet.of((int[])new int[]{1, 2, 4, 5});
        List<ImmutableBitSet> groupSets = Lists.newArrayList();
        groupSets.add(groupSet);
        Assert.assertEquals((Object)Aggregate.Group.SIMPLE, (Object)Aggregate.Group.induce((ImmutableBitSet)groupSet, (List)groupSets));
        groupSets = ImmutableBitSet.ORDERING.sortedCopy(groupSet.powerSet());
        Assert.assertEquals((Object)Aggregate.Group.CUBE, (Object)Aggregate.Group.induce((ImmutableBitSet)groupSet, (List)groupSets));
        groupSets = Lists.newArrayList();
        groupSets.add(ImmutableBitSet.of((int[])new int[]{1, 2, 4, 5}));
        groupSets.add(ImmutableBitSet.of((int[])new int[]{1, 2, 4}));
        groupSets.add(ImmutableBitSet.of((int[])new int[]{1, 2}));
        groupSets.add(ImmutableBitSet.of((int[])new int[]{1}));
        groupSets.add(ImmutableBitSet.of());
        Assert.assertEquals((Object)Aggregate.Group.ROLLUP, (Object)Aggregate.Group.induce((ImmutableBitSet)groupSet, groupSets));
        groupSets = Lists.newArrayList();
        groupSets.add(ImmutableBitSet.of((int[])new int[]{1, 2, 4, 5}));
        groupSets.add(ImmutableBitSet.of((int[])new int[]{1, 2, 4}));
        groupSets.add(ImmutableBitSet.of((int[])new int[]{1, 2}));
        groupSets.add(ImmutableBitSet.of());
        Assert.assertEquals((Object)Aggregate.Group.OTHER, (Object)Aggregate.Group.induce((ImmutableBitSet)groupSet, groupSets));
        groupSets = Lists.newArrayList();
        groupSets.add(ImmutableBitSet.of((int[])new int[]{1, 2, 4, 5}));
        groupSets.add(ImmutableBitSet.of((int[])new int[]{1, 2, 4}));
        groupSets.add(ImmutableBitSet.of((int[])new int[]{1, 2}));
        groupSets.add(ImmutableBitSet.of((int[])new int[]{1}));
        Assert.assertEquals((Object)Aggregate.Group.OTHER, (Object)Aggregate.Group.induce((ImmutableBitSet)groupSet, groupSets));
        groupSets = Lists.newArrayList();
        groupSets.add(ImmutableBitSet.of((int[])new int[]{1, 2, 5}));
        groupSets.add(ImmutableBitSet.of((int[])new int[]{1, 2, 4}));
        groupSets.add(ImmutableBitSet.of((int[])new int[]{1, 2}));
        groupSets.add(ImmutableBitSet.of((int[])new int[]{1}));
        groupSets.add(ImmutableBitSet.of());
        try {
            Aggregate.Group x = Aggregate.Group.induce((ImmutableBitSet)groupSet, groupSets);
            Assert.fail((String)("expected error, got " + x));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        groupSets = ImmutableBitSet.ORDERING.sortedCopy(groupSets);
        Assert.assertEquals((Object)Aggregate.Group.OTHER, (Object)Aggregate.Group.induce((ImmutableBitSet)groupSet, groupSets));
        groupSets = Lists.newArrayList();
        Assert.assertEquals((Object)Aggregate.Group.OTHER, (Object)Aggregate.Group.induce((ImmutableBitSet)groupSet, groupSets));
        groupSets = Lists.newArrayList();
        groupSets.add(ImmutableBitSet.of());
        Assert.assertEquals((Object)Aggregate.Group.OTHER, (Object)Aggregate.Group.induce((ImmutableBitSet)groupSet, groupSets));
    }

    @Test
    public void testInduceGroupingType1() {
        ImmutableBitSet groupSet = ImmutableBitSet.of((int[])new int[]{2});
        ArrayList groupSets = Lists.newArrayList();
        groupSets.add(groupSet);
        groupSets.add(ImmutableBitSet.of());
        Assert.assertEquals((Object)Aggregate.Group.CUBE, (Object)Aggregate.Group.induce((ImmutableBitSet)groupSet, (List)groupSets));
        groupSets = Lists.newArrayList();
        groupSets.add(ImmutableBitSet.of());
        Assert.assertEquals((Object)Aggregate.Group.OTHER, (Object)Aggregate.Group.induce((ImmutableBitSet)groupSet, (List)groupSets));
        groupSets = Lists.newArrayList();
        groupSets.add(groupSet);
        Assert.assertEquals((Object)Aggregate.Group.SIMPLE, (Object)Aggregate.Group.induce((ImmutableBitSet)groupSet, (List)groupSets));
        groupSets = Lists.newArrayList();
        Assert.assertEquals((Object)Aggregate.Group.OTHER, (Object)Aggregate.Group.induce((ImmutableBitSet)groupSet, (List)groupSets));
    }

    @Test
    public void testInduceGroupingType0() {
        ImmutableBitSet groupSet = ImmutableBitSet.of();
        ArrayList groupSets = Lists.newArrayList();
        groupSets.add(groupSet);
        Assert.assertEquals((Object)Aggregate.Group.SIMPLE, (Object)Aggregate.Group.induce((ImmutableBitSet)groupSet, (List)groupSets));
        groupSets = Lists.newArrayList();
        Assert.assertEquals((Object)Aggregate.Group.OTHER, (Object)Aggregate.Group.induce((ImmutableBitSet)groupSet, (List)groupSets));
    }
}

