/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.interpreter.Interpreter;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.ScannableTableTest;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InterpreterTest {
    private SchemaPlus rootSchema;
    private Planner planner;
    private MyDataContext dataContext;

    @Before
    public void setUp() {
        this.rootSchema = Frameworks.createRootSchema((boolean)true);
        FrameworkConfig config = Frameworks.newConfigBuilder().parserConfig(SqlParser.Config.DEFAULT).defaultSchema(CalciteAssert.addSchema(this.rootSchema, CalciteAssert.SchemaSpec.HR)).build();
        this.planner = Frameworks.getPlanner((FrameworkConfig)config);
        this.dataContext = new MyDataContext(this.planner);
    }

    @After
    public void tearDown() {
        this.rootSchema = null;
        this.planner = null;
        this.dataContext = null;
    }

    @Test
    public void testInterpretProjectFilterValues() throws Exception {
        SqlNode parse = this.planner.parse("select y, x\nfrom (values (1, 'a'), (2, 'b'), (3, 'c')) as t(x, y)\nwhere x > 1");
        SqlNode validate = this.planner.validate(parse);
        RelNode convert = this.planner.rel((SqlNode)validate).rel;
        Interpreter interpreter = new Interpreter((DataContext)this.dataContext, convert);
        InterpreterTest.assertRows(interpreter, "[b, 2]", "[c, 3]");
    }

    @Test
    public void testInterpretOrder() throws Exception {
        String sql = "select y\nfrom (values (1, 'a'), (2, 'b'), (3, 'c')) as t(x, y)\norder by -x";
        SqlNode parse = this.planner.parse("select y\nfrom (values (1, 'a'), (2, 'b'), (3, 'c')) as t(x, y)\norder by -x");
        SqlNode validate = this.planner.validate(parse);
        RelNode convert = this.planner.rel(validate).project();
        Interpreter interpreter = new Interpreter((DataContext)this.dataContext, convert);
        InterpreterTest.assertRows(interpreter, "[c]", "[b]", "[a]");
    }

    private static void assertRows(Interpreter interpreter, String ... rows) {
        InterpreterTest.assertRows(interpreter, false, rows);
    }

    private static void assertRowsUnordered(Interpreter interpreter, String ... rows) {
        InterpreterTest.assertRows(interpreter, true, rows);
    }

    private static void assertRows(Interpreter interpreter, boolean unordered, String ... rows) {
        ArrayList list = Lists.newArrayList();
        for (Object[] row : interpreter) {
            list.add(Arrays.toString(row));
        }
        List<String> expected = Arrays.asList(rows);
        if (unordered) {
            Collections.sort(list);
            Collections.sort(expected);
        }
        Assert.assertThat((Object)list, (Matcher)CoreMatchers.equalTo(expected));
    }

    @Test
    public void testInterpretTable() throws Exception {
        SqlNode parse = this.planner.parse("select * from \"hr\".\"emps\" order by \"empid\"");
        SqlNode validate = this.planner.validate(parse);
        RelNode convert = this.planner.rel((SqlNode)validate).rel;
        Interpreter interpreter = new Interpreter((DataContext)this.dataContext, convert);
        InterpreterTest.assertRows(interpreter, "[100, 10, Bill, 10000.0, 1000]", "[110, 10, Theodore, 11500.0, 250]", "[150, 10, Sebastian, 7000.0, null]", "[200, 20, Eric, 8000.0, 500]");
    }

    @Test
    public void testInterpretScannableTable() throws Exception {
        this.rootSchema.add("beatles", (Table)new ScannableTableTest.BeatlesTable());
        SqlNode parse = this.planner.parse("select * from \"beatles\" order by \"i\"");
        SqlNode validate = this.planner.validate(parse);
        RelNode convert = this.planner.rel((SqlNode)validate).rel;
        Interpreter interpreter = new Interpreter((DataContext)this.dataContext, convert);
        InterpreterTest.assertRows(interpreter, "[4, John]", "[4, Paul]", "[5, Ringo]", "[6, George]");
    }

    @Test
    public void testAggregate() throws Exception {
        this.rootSchema.add("beatles", (Table)new ScannableTableTest.BeatlesTable());
        SqlNode parse = this.planner.parse("select  count(*) from \"beatles\"");
        SqlNode validate = this.planner.validate(parse);
        RelNode convert = this.planner.rel((SqlNode)validate).rel;
        Interpreter interpreter = new Interpreter((DataContext)this.dataContext, convert);
        InterpreterTest.assertRows(interpreter, "[4]");
    }

    @Test
    public void testAggregateGroup() throws Exception {
        this.rootSchema.add("beatles", (Table)new ScannableTableTest.BeatlesTable());
        SqlNode parse = this.planner.parse("select \"j\", count(*) from \"beatles\" group by \"j\"");
        SqlNode validate = this.planner.validate(parse);
        RelNode convert = this.planner.rel((SqlNode)validate).rel;
        Interpreter interpreter = new Interpreter((DataContext)this.dataContext, convert);
        InterpreterTest.assertRowsUnordered(interpreter, "[George, 1]", "[Paul, 1]", "[John, 1]", "[Ringo, 1]");
    }

    @Test
    public void testAggregateGroupFilter() throws Exception {
        this.rootSchema.add("beatles", (Table)new ScannableTableTest.BeatlesTable());
        String sql = "select \"j\",\n  count(*) filter (where char_length(\"j\") > 4)\nfrom \"beatles\" group by \"j\"";
        SqlNode parse = this.planner.parse("select \"j\",\n  count(*) filter (where char_length(\"j\") > 4)\nfrom \"beatles\" group by \"j\"");
        SqlNode validate = this.planner.validate(parse);
        RelNode convert = this.planner.rel((SqlNode)validate).rel;
        Interpreter interpreter = new Interpreter((DataContext)this.dataContext, convert);
        InterpreterTest.assertRowsUnordered(interpreter, "[George, 1]", "[Paul, 0]", "[John, 0]", "[Ringo, 1]");
    }

    @Test
    public void testInterpretSimpleScannableTable() throws Exception {
        this.rootSchema.add("simple", (Table)new ScannableTableTest.SimpleTable());
        SqlNode parse = this.planner.parse("select * from \"simple\" limit 2");
        SqlNode validate = this.planner.validate(parse);
        RelNode convert = this.planner.rel((SqlNode)validate).rel;
        Interpreter interpreter = new Interpreter((DataContext)this.dataContext, convert);
        InterpreterTest.assertRows(interpreter, "[0]", "[10]");
    }

    @Test
    public void testInterpretUnionAll() throws Exception {
        this.rootSchema.add("simple", (Table)new ScannableTableTest.SimpleTable());
        SqlNode parse = this.planner.parse("select * from \"simple\"\nunion all\nselect * from \"simple\"\n");
        SqlNode validate = this.planner.validate(parse);
        RelNode convert = this.planner.rel((SqlNode)validate).rel;
        Interpreter interpreter = new Interpreter((DataContext)this.dataContext, convert);
        InterpreterTest.assertRows(interpreter, "[0]", "[10]", "[20]", "[30]", "[0]", "[10]", "[20]", "[30]");
    }

    @Test
    public void testInterpretUnion() throws Exception {
        this.rootSchema.add("simple", (Table)new ScannableTableTest.SimpleTable());
        SqlNode parse = this.planner.parse("select * from \"simple\"\nunion\nselect * from \"simple\"\n");
        SqlNode validate = this.planner.validate(parse);
        RelNode convert = this.planner.rel((SqlNode)validate).rel;
        Interpreter interpreter = new Interpreter((DataContext)this.dataContext, convert);
        InterpreterTest.assertRows(interpreter, "[0]", "[10]", "[20]", "[30]");
    }

    private class MyDataContext
    implements DataContext {
        private final Planner planner;

        public MyDataContext(Planner planner) {
            this.planner = planner;
        }

        public SchemaPlus getRootSchema() {
            return InterpreterTest.this.rootSchema;
        }

        public JavaTypeFactory getTypeFactory() {
            return (JavaTypeFactory)this.planner.getTypeFactory();
        }

        public QueryProvider getQueryProvider() {
            return null;
        }

        public Object get(String name) {
            return null;
        }
    }
}

