/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.calcite.test.CalciteAssert;
import org.hamcrest.CustomTypeSafeMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class Matchers {
    private static final ThreadLocal<Object> THREAD_ACTUAL = new ThreadLocal();

    private Matchers() {
    }

    public static Matcher<? super ResultSet> returnsUnordered(String ... lines) {
        final ArrayList expectedList = Lists.newArrayList((Object[])lines);
        Collections.sort(expectedList);
        return new CustomTypeSafeMatcher<ResultSet>(Arrays.toString(lines)){

            protected void describeMismatchSafely(ResultSet item, Description description) {
                Object value = THREAD_ACTUAL.get();
                THREAD_ACTUAL.remove();
                description.appendText("was ").appendValue(value);
            }

            protected boolean matchesSafely(ResultSet resultSet) {
                ArrayList actualList = Lists.newArrayList();
                try {
                    CalciteAssert.toStringList(resultSet, actualList);
                    resultSet.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                Collections.sort(actualList);
                THREAD_ACTUAL.set(actualList);
                boolean equals = actualList.equals(expectedList);
                if (!equals) {
                    THREAD_ACTUAL.set(actualList);
                }
                return equals;
            }
        };
    }
}

