/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.FilterableTable;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.JdbcTest;
import org.apache.calcite.test.Matchers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ScannableTableTest {
    private static final Object[][] BEATLES = new Object[][]{{4, "John", 1940}, {4, "Paul", 1942}, {6, "George", 1943}, {5, "Ringo", 1940}};

    @Test
    public void testTens() throws SQLException {
        Enumerator<Object[]> cursor = ScannableTableTest.tens();
        Assert.assertTrue((boolean)cursor.moveNext());
        Assert.assertThat((Object)((Object[])cursor.current())[0], (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)((Object[])cursor.current()).length, (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertTrue((boolean)cursor.moveNext());
        Assert.assertThat((Object)((Object[])cursor.current())[0], (Matcher)CoreMatchers.equalTo((Object)10));
        Assert.assertTrue((boolean)cursor.moveNext());
        Assert.assertThat((Object)((Object[])cursor.current())[0], (Matcher)CoreMatchers.equalTo((Object)20));
        Assert.assertTrue((boolean)cursor.moveNext());
        Assert.assertThat((Object)((Object[])cursor.current())[0], (Matcher)CoreMatchers.equalTo((Object)30));
        Assert.assertFalse((boolean)cursor.moveNext());
    }

    @Test
    public void testSimple() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        schema.add("simple", (Table)new SimpleTable());
        rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
        ResultSet resultSet = connection.createStatement().executeQuery("select * from \"s\".\"simple\"");
        Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.equalTo((Object)"i=0\ni=10\ni=20\ni=30\n"));
    }

    @Test
    public void testSimple2() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        schema.add("beatles", (Table)new BeatlesTable());
        rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
        ResultSet resultSet = connection.createStatement().executeQuery("select * from \"s\".\"beatles\"");
        Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.equalTo((Object)"i=4; j=John\ni=4; j=Paul\ni=6; j=George\ni=5; j=Ringo\n"));
    }

    @Test
    public void testSimpleFilter2() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        StringBuilder buf = new StringBuilder();
        schema.add("beatles", (Table)new BeatlesFilterableTable(buf, true));
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from \"s\".\"beatles\" where \"i\" = 4");
        Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.equalTo((Object)"i=4; j=John; k=1940\ni=4; j=Paul; k=1942\n"));
        resultSet.close();
        Assert.assertThat((Object)buf.toString(), (Matcher)CoreMatchers.equalTo((Object)"returnCount=2, filter=4"));
        buf.setLength(0);
        schema.add("beatles2", (Table)new BeatlesFilterableTable(buf, false));
        resultSet = statement.executeQuery("select * from \"s\".\"beatles2\" where \"i\" = 4");
        Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.equalTo((Object)"i=4; j=John; k=1940\ni=4; j=Paul; k=1942\n"));
        resultSet.close();
        Assert.assertThat((Object)buf.toString(), (Matcher)CoreMatchers.equalTo((Object)"returnCount=4"));
        buf.setLength(0);
    }

    @Test
    public void testProjectableFilterable2() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        StringBuilder buf = new StringBuilder();
        schema.add("beatles", (Table)new BeatlesProjectableFilterableTable(buf, true));
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from \"s\".\"beatles\" where \"i\" = 4");
        Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.equalTo((Object)"i=4; j=John; k=1940\ni=4; j=Paul; k=1942\n"));
        resultSet.close();
        Assert.assertThat((Object)buf.toString(), (Matcher)CoreMatchers.equalTo((Object)"returnCount=2, filter=4"));
        buf.setLength(0);
        schema.add("beatles2", (Table)new BeatlesProjectableFilterableTable(buf, false));
        resultSet = statement.executeQuery("select * from \"s\".\"beatles2\" where \"i\" = 4");
        Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.equalTo((Object)"i=4; j=John; k=1940\ni=4; j=Paul; k=1942\n"));
        resultSet.close();
        Assert.assertThat((Object)buf.toString(), (Matcher)CoreMatchers.equalTo((Object)"returnCount=4"));
        buf.setLength(0);
    }

    @Test
    public void testProjectableFilterable2WithProject() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        StringBuilder buf = new StringBuilder();
        schema.add("beatles", (Table)new BeatlesProjectableFilterableTable(buf, true));
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select \"k\",\"j\" from \"s\".\"beatles\" where \"i\" = 4");
        Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.equalTo((Object)"k=1940; j=John\nk=1942; j=Paul\n"));
        resultSet.close();
        Assert.assertThat((Object)buf.toString(), (Matcher)CoreMatchers.equalTo((Object)"returnCount=2, filter=4, projects=[2, 1]"));
        buf.setLength(0);
        resultSet = statement.executeQuery("select \"i\",\"k\" from\n\"s\".\"beatles\" where \"k\" > 1941");
        Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.equalTo((Object)"i=4; k=1942\ni=6; k=1943\n"));
        resultSet.close();
        Assert.assertThat((Object)buf.toString(), (Matcher)CoreMatchers.equalTo((Object)"returnCount=4, projects=[0, 2]"));
        buf.setLength(0);
    }

    @Test
    public void testPFTableRefusesFilter() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        StringBuilder buf = new StringBuilder();
        schema.add("beatles2", (Table)new BeatlesProjectableFilterableTable(buf, false));
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select \"k\" from \"s\".\"beatles2\" where \"i\" = 4");
        Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.equalTo((Object)"k=1940\nk=1942\n"));
        resultSet.close();
        Assert.assertThat((Object)buf.toString(), (Matcher)CoreMatchers.equalTo((Object)"returnCount=4, projects=[2, 0]"));
        buf.setLength(0);
    }

    private static Integer getFilter(boolean cooperative, List<RexNode> filters) {
        Iterator<RexNode> filterIter = filters.iterator();
        while (filterIter.hasNext()) {
            RexNode node = filterIter.next();
            if (!cooperative || !(node instanceof RexCall) || ((RexCall)node).getOperator() != SqlStdOperatorTable.EQUALS || !(((RexCall)node).getOperands().get(0) instanceof RexInputRef) || ((RexInputRef)((RexCall)node).getOperands().get(0)).getIndex() != 0 || !(((RexCall)node).getOperands().get(1) instanceof RexLiteral)) continue;
            RexNode op1 = (RexNode)((RexCall)node).getOperands().get(1);
            filterIter.remove();
            return ((BigDecimal)((RexLiteral)op1).getValue()).intValue();
        }
        return null;
    }

    @Test
    public void testPFTableRefusesFilterSingleColumn() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        StringBuilder buf = new StringBuilder();
        schema.add("beatles2", (Table)new BeatlesProjectableFilterableTable(buf, false));
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select \"k\" from \"s\".\"beatles2\" where \"k\" > 1941");
        Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.equalTo((Object)"k=1942\nk=1943\n"));
        resultSet.close();
        Assert.assertThat((Object)buf.toString(), (Matcher)CoreMatchers.equalTo((Object)"returnCount=4, projects=[2]"));
    }

    @Test
    public void testPrepared2() throws SQLException {
        Properties properties = new Properties();
        properties.setProperty("caseSensitive", "true");
        try (Connection connection = DriverManager.getConnection("jdbc:calcite:", properties);){
            CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
            final AtomicInteger scanCount = new AtomicInteger();
            final AtomicInteger enumerateCount = new AtomicInteger();
            AbstractSchema schema = new AbstractSchema(){

                protected Map<String, Table> getTableMap() {
                    return ImmutableMap.of((Object)"TENS", (Object)new SimpleTable(){

                        private Enumerable<Object[]> superScan(DataContext root) {
                            return super.scan(root);
                        }

                        @Override
                        public Enumerable<Object[]> scan(final DataContext root) {
                            scanCount.incrementAndGet();
                            return new AbstractEnumerable<Object[]>(){

                                public Enumerator<Object[]> enumerator() {
                                    enumerateCount.incrementAndGet();
                                    return this.superScan(root).enumerator();
                                }
                            };
                        }
                    });
                }
            };
            calciteConnection.getRootSchema().add("TEST", (Schema)schema);
            String sql = "select * from \"TEST\".\"TENS\" where \"i\" < ?";
            PreparedStatement statement = calciteConnection.prepareStatement("select * from \"TEST\".\"TENS\" where \"i\" < ?");
            Assert.assertThat((Object)scanCount.get(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)enumerateCount.get(), (Matcher)CoreMatchers.is((Object)0));
            statement.setInt(1, 20);
            Assert.assertThat((Object)scanCount.get(), (Matcher)CoreMatchers.is((Object)0));
            ResultSet resultSet = statement.executeQuery();
            Assert.assertThat((Object)scanCount.get(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)enumerateCount.get(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)resultSet, Matchers.returnsUnordered("i=0", "i=10"));
            Assert.assertThat((Object)scanCount.get(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)enumerateCount.get(), (Matcher)CoreMatchers.is((Object)1));
            resultSet = statement.executeQuery();
            Assert.assertThat((Object)scanCount.get(), (Matcher)CoreMatchers.is((Object)2));
            Assert.assertThat((Object)resultSet, Matchers.returnsUnordered("i=0", "i=10"));
            Assert.assertThat((Object)scanCount.get(), (Matcher)CoreMatchers.is((Object)2));
            statement.setInt(1, 30);
            resultSet = statement.executeQuery();
            Assert.assertThat((Object)scanCount.get(), (Matcher)CoreMatchers.is((Object)3));
            Assert.assertThat((Object)resultSet, Matchers.returnsUnordered("i=0", "i=10", "i=20"));
            Assert.assertThat((Object)scanCount.get(), (Matcher)CoreMatchers.is((Object)3));
        }
    }

    private static Enumerator<Object[]> tens() {
        return new Enumerator<Object[]>(){
            int row = -1;
            Object[] current;

            public Object[] current() {
                return this.current;
            }

            public boolean moveNext() {
                if (++this.row < 4) {
                    this.current = new Object[]{this.row * 10};
                    return true;
                }
                return false;
            }

            public void reset() {
                this.row = -1;
            }

            public void close() {
                this.current = null;
            }
        };
    }

    private static Enumerator<Object[]> beatles(final StringBuilder buf, final Integer filter, final int[] projects) {
        return new Enumerator<Object[]>(){
            int row = -1;
            int returnCount = 0;
            Object[] current;

            public Object[] current() {
                return this.current;
            }

            public boolean moveNext() {
                while (++this.row < 4) {
                    Object[] current = BEATLES[this.row % 4];
                    if (filter != null && !filter.equals(current[0])) continue;
                    if (projects == null) {
                        this.current = current;
                    } else {
                        Object[] newCurrent = new Object[projects.length];
                        for (int i = 0; i < projects.length; ++i) {
                            newCurrent[i] = current[projects[i]];
                        }
                        this.current = newCurrent;
                    }
                    ++this.returnCount;
                    return true;
                }
                return false;
            }

            public void reset() {
                this.row = -1;
            }

            public void close() {
                this.current = null;
                buf.append("returnCount=").append(this.returnCount);
                if (filter != null) {
                    buf.append(", filter=").append(filter);
                }
                if (projects != null) {
                    buf.append(", projects=").append(Arrays.toString(projects));
                }
            }
        };
    }

    public static class BeatlesProjectableFilterableTable
    extends AbstractTable
    implements ProjectableFilterableTable {
        private final StringBuilder buf;
        private final boolean cooperative;

        public BeatlesProjectableFilterableTable(StringBuilder buf, boolean cooperative) {
            this.buf = buf;
            this.cooperative = cooperative;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return typeFactory.builder().add("i", SqlTypeName.INTEGER).add("j", SqlTypeName.VARCHAR).add("k", SqlTypeName.INTEGER).build();
        }

        public Enumerable<Object[]> scan(DataContext root, List<RexNode> filters, final int[] projects) {
            final Integer filter = ScannableTableTest.getFilter(this.cooperative, filters);
            return new AbstractEnumerable<Object[]>(){

                public Enumerator<Object[]> enumerator() {
                    return ScannableTableTest.beatles(BeatlesProjectableFilterableTable.this.buf, filter, projects);
                }
            };
        }
    }

    public static class BeatlesFilterableTable
    extends AbstractTable
    implements FilterableTable {
        private final StringBuilder buf;
        private final boolean cooperative;

        public BeatlesFilterableTable(StringBuilder buf, boolean cooperative) {
            this.buf = buf;
            this.cooperative = cooperative;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return typeFactory.builder().add("i", SqlTypeName.INTEGER).add("j", SqlTypeName.VARCHAR).add("k", SqlTypeName.INTEGER).build();
        }

        public Enumerable<Object[]> scan(DataContext root, List<RexNode> filters) {
            final Integer filter = ScannableTableTest.getFilter(this.cooperative, filters);
            return new AbstractEnumerable<Object[]>(){

                public Enumerator<Object[]> enumerator() {
                    return ScannableTableTest.beatles(BeatlesFilterableTable.this.buf, filter, null);
                }
            };
        }
    }

    public static class BeatlesTable
    implements ScannableTable {
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return typeFactory.builder().add("i", SqlTypeName.INTEGER).add("j", SqlTypeName.VARCHAR).build();
        }

        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.TABLE;
        }

        public Enumerable<Object[]> scan(DataContext root) {
            return new AbstractEnumerable<Object[]>(){

                public Enumerator<Object[]> enumerator() {
                    return ScannableTableTest.beatles(new StringBuilder(), null, null);
                }
            };
        }
    }

    public static class SimpleTable
    implements ScannableTable {
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return typeFactory.builder().add("i", SqlTypeName.INTEGER).build();
        }

        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.TABLE;
        }

        public Enumerable<Object[]> scan(DataContext root) {
            return new AbstractEnumerable<Object[]>(){

                public Enumerator<Object[]> enumerator() {
                    return ScannableTableTest.tens();
                }
            };
        }
    }
}

