/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.test.DefaultSqlTestFactory;
import org.apache.calcite.sql.test.SqlTester;
import org.apache.calcite.sql.test.SqlTesterImpl;
import org.apache.calcite.sql.test.SqlTests;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.TestUtil;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class SqlValidatorTestCase {
    private static final Pattern LINE_COL_PATTERN = Pattern.compile("At line ([0-9]+), column ([0-9]+)");
    private static final Pattern LINE_COL_TWICE_PATTERN = Pattern.compile("(?s)From line ([0-9]+), column ([0-9]+) to line ([0-9]+), column ([0-9]+): (.*)");
    protected SqlTester tester = this.getTester();

    public SqlTester getTester() {
        return new SqlTesterImpl(DefaultSqlTestFactory.INSTANCE);
    }

    public final Sql sql(String sql) {
        return new Sql(this.tester, sql);
    }

    public final Sql winSql(String sql) {
        return this.sql(sql);
    }

    public final Sql win(String sql) {
        return this.sql("select * from emp " + sql);
    }

    public Sql winExp(String sql) {
        return this.winSql("select " + sql + " from emp window w as (order by deptno)");
    }

    public Sql winExp2(String sql) {
        return this.winSql("select " + sql + " from emp");
    }

    public void check(String sql) {
        this.sql(sql).ok();
    }

    public void checkExp(String sql) {
        this.tester.assertExceptionIsThrown(SqlTesterImpl.buildQuery(sql), null);
    }

    public final void checkFails(String sql, String expected) {
        this.sql(sql).fails(expected);
    }

    public final void checkExpFails(String sql, String expected) {
        this.tester.assertExceptionIsThrown(SqlTesterImpl.buildQuery(sql), expected);
    }

    public final void checkWholeExpFails(String sql, String expected) {
        assert (sql.indexOf(94) < 0);
        this.checkExpFails("^" + sql + "^", expected);
    }

    public final void checkExpType(String sql, String expected) {
        this.checkColumnType(SqlTesterImpl.buildQuery(sql), expected);
    }

    public final void checkColumnType(String sql, String expected) {
        this.tester.checkColumnType(sql, expected);
    }

    public final void checkResultType(String sql, String expected) {
        this.tester.checkResultType(sql, expected);
    }

    public final void checkIntervalConv(String sql, String expected) {
        this.tester.checkIntervalConv(SqlTesterImpl.buildQuery(sql), expected);
    }

    protected final void assertExceptionIsThrown(String sql, String expectedMsgPattern) {
        assert (expectedMsgPattern != null);
        this.tester.assertExceptionIsThrown(sql, expectedMsgPattern);
    }

    public void checkCharset(String sql, Charset expectedCharset) {
        this.tester.checkCharset(sql, expectedCharset);
    }

    public void checkCollation(String sql, String expectedCollationName, SqlCollation.Coercibility expectedCoercibility) {
        this.tester.checkCollation(sql, expectedCollationName, expectedCoercibility);
    }

    public static void checkEx(Throwable ex, String expectedMsgPattern, SqlParserUtil.StringAndPos sap) {
        String sqlWithCarets;
        if (null == ex) {
            if (expectedMsgPattern == null) {
                return;
            }
            throw new AssertionError((Object)("Expected query to throw exception, but it did not; query [" + sap.sql + "]; expected [" + expectedMsgPattern + "]"));
        }
        Throwable actualException = ex;
        String actualMessage = actualException.getMessage();
        int actualLine = -1;
        int actualColumn = -1;
        int actualEndLine = 100;
        int actualEndColumn = 99;
        CalciteContextException ece = null;
        for (Throwable x = ex; x != null; x = x.getCause()) {
            if (x instanceof CalciteContextException) {
                ece = (CalciteContextException)x;
                break;
            }
            if (x.getCause() == x) break;
        }
        SqlParseException spe = null;
        for (Throwable x = ex; x != null; x = x.getCause()) {
            if (x instanceof SqlParseException && ((SqlParseException)x).getPos() != null) {
                spe = (SqlParseException)x;
                break;
            }
            if (x.getCause() == x) break;
        }
        if (ece != null) {
            actualLine = ece.getPosLine();
            actualColumn = ece.getPosColumn();
            actualEndLine = ece.getEndPosLine();
            actualEndColumn = ece.getEndPosColumn();
            if (ece.getCause() != null) {
                actualException = ece.getCause();
                actualMessage = actualException.getMessage();
            }
        } else if (spe != null) {
            actualLine = spe.getPos().getLineNum();
            actualColumn = spe.getPos().getColumnNum();
            actualEndLine = spe.getPos().getEndLineNum();
            actualEndColumn = spe.getPos().getEndColumnNum();
            if (spe.getCause() != null) {
                actualException = spe.getCause();
                actualMessage = actualException.getMessage();
            }
        } else {
            String message = ex.getMessage();
            if (message != null) {
                java.util.regex.Matcher matcher = LINE_COL_TWICE_PATTERN.matcher(message);
                if (matcher.matches()) {
                    actualLine = Integer.parseInt(matcher.group(1));
                    actualColumn = Integer.parseInt(matcher.group(2));
                    actualEndLine = Integer.parseInt(matcher.group(3));
                    actualEndColumn = Integer.parseInt(matcher.group(4));
                    actualMessage = matcher.group(5);
                } else {
                    matcher = LINE_COL_PATTERN.matcher(message);
                    if (matcher.matches()) {
                        actualLine = Integer.parseInt(matcher.group(1));
                        actualColumn = Integer.parseInt(matcher.group(2));
                    }
                }
            }
        }
        if (null == expectedMsgPattern) {
            actualException.printStackTrace();
            Assert.fail((String)("Validator threw unexpected exception; query [" + sap.sql + "]; exception [" + actualMessage + "]; class [" + actualException.getClass() + "]; pos [line " + actualLine + " col " + actualColumn + " thru line " + actualLine + " col " + actualColumn + "]"));
        }
        if (actualColumn <= 0 || actualLine <= 0 || actualEndColumn <= 0 || actualEndLine <= 0) {
            if (sap.pos != null) {
                AssertionError e = new AssertionError((Object)("Expected error to have position, but actual error did not:  actual pos [line " + actualLine + " col " + actualColumn + " thru line " + actualEndLine + " col " + actualEndColumn + "]"));
                ((Throwable)((Object)e)).initCause(actualException);
                throw e;
            }
            sqlWithCarets = sap.sql;
        } else {
            sqlWithCarets = SqlParserUtil.addCarets((String)sap.sql, (int)actualLine, (int)actualColumn, (int)actualEndLine, (int)(actualEndColumn + 1));
            if (sap.pos == null) {
                throw new AssertionError((Object)("Actual error had a position, but expected error did not. Add error position carets to sql:\n" + sqlWithCarets));
            }
        }
        if (actualMessage != null) {
            actualMessage = Util.toLinux((String)actualMessage);
        }
        if (actualMessage == null || !actualMessage.matches(expectedMsgPattern)) {
            actualException.printStackTrace();
            String actualJavaRegexp = actualMessage == null ? "null" : TestUtil.quoteForJava(TestUtil.quotePattern(actualMessage));
            Assert.fail((String)("Validator threw different exception than expected; query [" + sap.sql + "];\n expected pattern [" + expectedMsgPattern + "];\n actual [" + actualMessage + "];\n actual as java regexp [" + actualJavaRegexp + "]; pos [" + actualLine + " col " + actualColumn + " thru line " + actualEndLine + " col " + actualEndColumn + "]; sql [" + sqlWithCarets + "]"));
        } else if (sap.pos != null && (actualLine != sap.pos.getLineNum() || actualColumn != sap.pos.getColumnNum() || actualEndLine != sap.pos.getEndLineNum() || actualEndColumn != sap.pos.getEndColumnNum())) {
            Assert.fail((String)("Validator threw expected exception [" + actualMessage + "];\nbut at pos [line " + actualLine + " col " + actualColumn + " thru line " + actualEndLine + " col " + actualEndColumn + "];\nsql [" + sqlWithCarets + "]"));
        }
    }

    static class Sql {
        private final SqlTester tester;
        private final String sql;

        Sql(SqlTester tester, String sql) {
            this.tester = tester;
            this.sql = sql;
        }

        Sql tester(SqlTester tester) {
            return new Sql(tester, this.sql);
        }

        Sql ok() {
            this.tester.assertExceptionIsThrown(this.sql, null);
            return this;
        }

        Sql fails(String expected) {
            this.tester.assertExceptionIsThrown(this.sql, expected);
            return this;
        }

        Sql failsIf(boolean b, String expected) {
            if (b) {
                this.fails(expected);
            } else {
                this.ok();
            }
            return this;
        }

        public Sql type(String expectedType) {
            this.tester.checkResultType(this.sql, expectedType);
            return this;
        }

        public Sql columnType(String expectedType) {
            this.tester.checkColumnType(this.sql, expectedType);
            return this;
        }

        public Sql monotonic(SqlMonotonicity expectedMonotonicity) {
            this.tester.checkMonotonic(this.sql, expectedMonotonicity);
            return this;
        }

        public Sql bindType(final String bindType) {
            this.tester.check(this.sql, null, new SqlTester.ParameterChecker(){

                @Override
                public void checkParameters(RelDataType parameterRowType) {
                    Assert.assertThat((Object)parameterRowType.toString(), (Matcher)CoreMatchers.is((Object)bindType));
                }
            }, SqlTests.ANY_RESULT_CHECKER);
            return this;
        }

        public Sql sansCarets() {
            return new Sql(this.tester, this.sql.replace("^", ""));
        }
    }

    public static interface Tester {
        public SqlNode parseQuery(String var1) throws SqlParseException;

        public SqlNode parseAndValidate(SqlValidator var1, String var2);

        public SqlValidator getValidator();

        public void assertExceptionIsThrown(String var1, String var2);

        public RelDataType getColumnType(String var1);

        public RelDataType getResultType(String var1);

        public void checkCollation(String var1, String var2, SqlCollation.Coercibility var3);

        public void checkCharset(String var1, Charset var2);

        public void checkColumnType(String var1, String var2);

        public void checkFieldOrigin(String var1, String var2);

        public void checkRewrite(SqlValidator var1, String var2, String var3);

        public void checkResultType(String var1, String var2);

        public void checkIntervalConv(String var1, String var2);

        public SqlMonotonicity getMonotonicity(String var1);

        public SqlConformance getConformance();
    }
}

