/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test.concurrent;

import com.google.common.collect.ImmutableList;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.calcite.test.concurrent.ConcurrentTestCommand;
import org.apache.calcite.test.concurrent.ConcurrentTestCommandGenerator;

public class ConcurrentTestTimedCommandGenerator
extends ConcurrentTestCommandGenerator {
    private int runTimeSeconds;
    private long endTimeMillis;

    public ConcurrentTestTimedCommandGenerator(int runTimeSeconds) {
        this.runTimeSeconds = runTimeSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Iterable<ConcurrentTestCommand> getCommandIterable(final int threadId) {
        ConcurrentTestTimedCommandGenerator concurrentTestTimedCommandGenerator = this;
        synchronized (concurrentTestTimedCommandGenerator) {
            if (this.endTimeMillis == 0L) {
                this.endTimeMillis = System.currentTimeMillis() + (long)(this.runTimeSeconds * 1000);
            }
        }
        return new Iterable<ConcurrentTestCommand>(){

            @Override
            public Iterator<ConcurrentTestCommand> iterator() {
                return new TimedIterator<ConcurrentTestCommand>(ConcurrentTestTimedCommandGenerator.this.getCommands(threadId), ConcurrentTestTimedCommandGenerator.this.endTimeMillis);
            }
        };
    }

    @Override
    void printCommands(PrintStream out, Integer threadId) {
        super.printCommands(out, threadId);
        out.println("Repeat sequence for " + this.runTimeSeconds + " seconds");
    }

    private class TimedIterator<E>
    implements Iterator<E> {
        private final List<E> commands;
        private long endTimeMillis;
        private int commandIndex;

        private TimedIterator(Collection<E> commands, long endTimeMillis) {
            this.commands = ImmutableList.copyOf(commands);
            this.endTimeMillis = endTimeMillis;
            this.commandIndex = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.commandIndex < this.commands.size()) {
                return true;
            }
            if (System.currentTimeMillis() < this.endTimeMillis) {
                this.commandIndex = 0;
                return this.commands.size() > 0;
            }
            return false;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.commands.get(this.commandIndex++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

