/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.util.PartiallyOrderedSet;
import org.apache.calcite.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class PartiallyOrderedSetTest {
    private static final boolean DEBUG = false;
    private static final int SCALE = CalciteAssert.ENABLE_SLOW ? 250 : 50;
    final long seed = new Random().nextLong();
    final Random random = new Random(this.seed);
    static final PartiallyOrderedSet.Ordering<String> STRING_SUBSET_ORDERING = new PartiallyOrderedSet.Ordering<String>(){

        public boolean lessThan(String e1, String e2) {
            for (int i = 0; i < e1.length(); ++i) {
                if (e2.indexOf(e1.charAt(i)) >= 0) continue;
                return false;
            }
            return true;
        }
    };
    static final PartiallyOrderedSet.Ordering<Integer> IS_DIVISOR = new PartiallyOrderedSet.Ordering<Integer>(){

        public boolean lessThan(Integer e1, Integer e2) {
            return e2 % e1 == 0;
        }
    };
    static final PartiallyOrderedSet.Ordering<Integer> IS_DIVISOR_INVERSE = new PartiallyOrderedSet.Ordering<Integer>(){

        public boolean lessThan(Integer e1, Integer e2) {
            return e1 % e2 == 0;
        }
    };
    static final PartiallyOrderedSet.Ordering<Integer> IS_BIT_SUBSET = new PartiallyOrderedSet.Ordering<Integer>(){

        public boolean lessThan(Integer e1, Integer e2) {
            return (e2 & e1) == e2;
        }
    };
    static final PartiallyOrderedSet.Ordering<Integer> IS_BIT_SUPERSET = new PartiallyOrderedSet.Ordering<Integer>(){

        public boolean lessThan(Integer e1, Integer e2) {
            return (e2 & e1) == e1;
        }
    };

    @Test
    public void testPoset() {
        String empty = "''";
        String abcd = "'abcd'";
        PartiallyOrderedSet poset = new PartiallyOrderedSet(STRING_SUBSET_ORDERING);
        Assert.assertEquals((long)0L, (long)poset.size());
        StringBuilder buf = new StringBuilder();
        poset.out(buf);
        TestUtil.assertEqualsVerbose("PartiallyOrderedSet size: 0 elements: {\n}", buf.toString());
        poset.add((Object)"a");
        this.printValidate(poset);
        poset.add((Object)"b");
        this.printValidate(poset);
        poset.clear();
        Assert.assertEquals((long)0L, (long)poset.size());
        poset.add((Object)empty);
        this.printValidate(poset);
        poset.add((Object)abcd);
        this.printValidate(poset);
        Assert.assertEquals((long)2L, (long)poset.size());
        Assert.assertEquals((Object)"['abcd']", (Object)poset.getNonChildren().toString());
        Assert.assertEquals((Object)"['']", (Object)poset.getNonParents().toString());
        String ab = "'ab'";
        poset.add((Object)"'ab'");
        this.printValidate(poset);
        Assert.assertEquals((long)3L, (long)poset.size());
        Assert.assertEquals((Object)"[]", (Object)poset.getChildren((Object)empty).toString());
        Assert.assertEquals((Object)"['ab']", (Object)poset.getParents((Object)empty).toString());
        Assert.assertEquals((Object)"['ab']", (Object)poset.getChildren((Object)abcd).toString());
        Assert.assertEquals((Object)"[]", (Object)poset.getParents((Object)abcd).toString());
        Assert.assertEquals((Object)"['']", (Object)poset.getChildren((Object)"'ab'").toString());
        Assert.assertEquals((Object)"['abcd']", (Object)poset.getParents((Object)"'ab'").toString());
        String bcd = "'bcd'";
        poset.add((Object)"'bcd'");
        this.printValidate(poset);
        Assert.assertTrue((boolean)poset.isValid(false));
        Assert.assertEquals((Object)"['']", (Object)poset.getChildren((Object)"'bcd'").toString());
        Assert.assertEquals((Object)"['abcd']", (Object)poset.getParents((Object)"'bcd'").toString());
        Assert.assertEquals((Object)"['ab', 'bcd']", (Object)poset.getChildren((Object)abcd).toString());
        buf.setLength(0);
        poset.out(buf);
        TestUtil.assertEqualsVerbose("PartiallyOrderedSet size: 4 elements: {\n  'abcd' parents: [] children: ['ab', 'bcd']\n  'ab' parents: ['abcd'] children: ['']\n  'bcd' parents: ['abcd'] children: ['']\n  '' parents: ['ab', 'bcd'] children: []\n}", buf.toString());
        String b = "'b'";
        PartiallyOrderedSetTest.assertEqualsList("['ab', 'abcd', 'bcd']", poset.getAncestors((Object)"'b'"));
        poset.add((Object)"'b'");
        this.printValidate(poset);
        Assert.assertEquals((Object)"['abcd']", (Object)poset.getNonChildren().toString());
        Assert.assertEquals((Object)"['']", (Object)poset.getNonParents().toString());
        Assert.assertEquals((Object)"['']", (Object)poset.getChildren((Object)"'b'").toString());
        PartiallyOrderedSetTest.assertEqualsList("['ab', 'bcd']", poset.getParents((Object)"'b'"));
        Assert.assertEquals((Object)"['']", (Object)poset.getChildren((Object)"'b'").toString());
        Assert.assertEquals((Object)"['ab', 'bcd']", (Object)poset.getChildren((Object)abcd).toString());
        Assert.assertEquals((Object)"['b']", (Object)poset.getChildren((Object)"'bcd'").toString());
        Assert.assertEquals((Object)"['b']", (Object)poset.getChildren((Object)"'ab'").toString());
        PartiallyOrderedSetTest.assertEqualsList("['ab', 'abcd', 'bcd']", poset.getAncestors((Object)"'b'"));
        Assert.assertEquals((Object)"[]", (Object)poset.getDescendants((Object)empty).toString());
        PartiallyOrderedSetTest.assertEqualsList("['ab', 'abcd', 'b', 'bcd']", poset.getAncestors((Object)empty));
        PartiallyOrderedSetTest.assertEqualsList("['abcd']", poset.getAncestors((Object)"'ac'"));
        PartiallyOrderedSetTest.assertEqualsList("[]", poset.getAncestors((Object)"'z'"));
        PartiallyOrderedSetTest.assertEqualsList("['ab', 'abcd']", poset.getAncestors((Object)"'a'"));
    }

    @Test
    public void testPosetTricky() {
        PartiallyOrderedSet poset = new PartiallyOrderedSet(STRING_SUBSET_ORDERING);
        poset.clear();
        poset.add((Object)"'a'");
        this.printValidate(poset);
        poset.add((Object)"'b'");
        this.printValidate(poset);
        poset.add((Object)"'ac'");
        this.printValidate(poset);
        poset.add((Object)"'ab'");
        this.printValidate(poset);
    }

    @Test
    public void testPosetBits() {
        PartiallyOrderedSet poset = new PartiallyOrderedSet(IS_BIT_SUPERSET);
        poset.add((Object)2112);
        poset.add((Object)2240);
        poset.add((Object)2496);
        this.printValidate(poset);
        poset.remove((Object)2240);
        this.printValidate(poset);
        poset.add((Object)2240);
        this.printValidate(poset);
    }

    @Test
    public void testPosetBitsRemoveParent() {
        PartiallyOrderedSet poset = new PartiallyOrderedSet(IS_BIT_SUPERSET);
        poset.add((Object)66);
        poset.add((Object)68);
        poset.add((Object)72);
        poset.add((Object)64);
        this.printValidate(poset);
        poset.remove((Object)64);
        this.printValidate(poset);
    }

    @Test
    public void testDivisorPoset() {
        if (!CalciteAssert.ENABLE_SLOW) {
            return;
        }
        PartiallyOrderedSet integers = new PartiallyOrderedSet(IS_DIVISOR, PartiallyOrderedSetTest.range(1, 1000));
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5, 6, 8, 10, 12, 15, 20, 24, 30, 40, 60]", (Object)new TreeSet(integers.getDescendants((Object)120)).toString());
        Assert.assertEquals((Object)"[240, 360, 480, 600, 720, 840, 960]", (Object)new TreeSet(integers.getAncestors((Object)120)).toString());
        Assert.assertTrue((boolean)integers.getDescendants((Object)1).isEmpty());
        Assert.assertEquals((long)998L, (long)integers.getAncestors((Object)1).size());
        Assert.assertTrue((boolean)integers.isValid(true));
    }

    @Test
    public void testDivisorSeries() {
        this.checkPoset(IS_DIVISOR, false, PartiallyOrderedSetTest.range(1, SCALE * 3), false);
    }

    @Test
    public void testDivisorRandom() {
        boolean ok = false;
        try {
            this.checkPoset(IS_DIVISOR, false, PartiallyOrderedSetTest.random(this.random, SCALE, SCALE * 3), false);
            ok = true;
        }
        finally {
            if (!ok) {
                System.out.println("Random seed: " + this.seed);
            }
        }
    }

    @Test
    public void testDivisorRandomWithRemoval() {
        boolean ok = false;
        try {
            this.checkPoset(IS_DIVISOR, false, PartiallyOrderedSetTest.random(this.random, SCALE, SCALE * 3), true);
            ok = true;
        }
        finally {
            if (!ok) {
                System.out.println("Random seed: " + this.seed);
            }
        }
    }

    @Test
    public void testDivisorInverseSeries() {
        this.checkPoset(IS_DIVISOR_INVERSE, false, PartiallyOrderedSetTest.range(1, SCALE * 3), false);
    }

    @Test
    public void testDivisorInverseRandom() {
        boolean ok = false;
        try {
            this.checkPoset(IS_DIVISOR_INVERSE, false, PartiallyOrderedSetTest.random(this.random, SCALE, SCALE * 3), false);
            ok = true;
        }
        finally {
            if (!ok) {
                System.out.println("Random seed: " + this.seed);
            }
        }
    }

    @Test
    public void testDivisorInverseRandomWithRemoval() {
        boolean ok = false;
        try {
            this.checkPoset(IS_DIVISOR_INVERSE, false, PartiallyOrderedSetTest.random(this.random, SCALE, SCALE * 3), true);
            ok = true;
        }
        finally {
            if (!ok) {
                System.out.println("Random seed: " + this.seed);
            }
        }
    }

    @Test
    public void testSubsetSeries() {
        this.checkPoset(IS_BIT_SUBSET, false, PartiallyOrderedSetTest.range(1, SCALE / 2), false);
    }

    @Test
    public void testSubsetRandom() {
        boolean ok = false;
        try {
            this.checkPoset(IS_BIT_SUBSET, false, PartiallyOrderedSetTest.random(this.random, SCALE / 4, SCALE), false);
            ok = true;
        }
        finally {
            if (!ok) {
                System.out.println("Random seed: " + this.seed);
            }
        }
    }

    private <E> void printValidate(PartiallyOrderedSet<E> poset) {
        Assert.assertTrue((boolean)poset.isValid(false));
    }

    public void checkPoset(PartiallyOrderedSet.Ordering<Integer> ordering, boolean debug, Iterable<Integer> generator, boolean remove) {
        PartiallyOrderedSet poset = new PartiallyOrderedSet(ordering);
        int n = 0;
        int z = 0;
        if (debug) {
            this.dump(poset);
        }
        for (int i : generator) {
            if (remove && z++ % 2 == 0) {
                if (debug) {
                    System.out.println("remove " + i);
                }
                poset.remove((Object)i);
                if (!debug) continue;
                this.dump(poset);
                continue;
            }
            if (debug) {
                System.out.println("add " + i);
            }
            poset.add((Object)i);
            if (debug) {
                this.dump(poset);
            }
            Assert.assertEquals((long)(++n), (long)poset.size());
            if (i >= 100) continue;
            if (!poset.isValid(false)) {
                this.dump(poset);
            }
            Assert.assertTrue((boolean)poset.isValid(true));
        }
        Assert.assertTrue((boolean)poset.isValid(true));
        StringBuilder buf = new StringBuilder();
        poset.out(buf);
        Assert.assertTrue((buf.length() > 0 ? 1 : 0) != 0);
    }

    private <E> void dump(PartiallyOrderedSet<E> poset) {
        StringBuilder buf = new StringBuilder();
        poset.out(buf);
        System.out.println(buf);
    }

    private static Collection<Integer> range(final int start, final int end) {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return start + index;
            }

            @Override
            public int size() {
                return end - start;
            }
        };
    }

    private static Iterable<Integer> random(Random random, int size, int max) {
        LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
        while (set.size() < size) {
            set.add(random.nextInt(max) + 1);
        }
        return set;
    }

    private static void assertEqualsList(String expected, List<String> ss) {
        Assert.assertEquals((Object)expected, (Object)new TreeSet<String>(ss).toString());
    }
}

