/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.google.common.collect.ImmutableList;
import org.apache.calcite.util.PrecedenceClimbingParser;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class PrecedenceClimbingParserTest {
    @Test
    public void testBasic() {
        PrecedenceClimbingParser p = new PrecedenceClimbingParser.Builder().atom((Object)"a").infix((Object)"+", 1, true).prefix((Object)"-", 3).atom((Object)"b").infix((Object)"*", 2, true).atom((Object)"c").postfix((Object)"!", 4).build();
        PrecedenceClimbingParser.Token token = p.parse();
        Assert.assertThat((Object)p.print(token), (Matcher)CoreMatchers.is((Object)"(a + ((- b) * (c !)))"));
    }

    @Test
    public void testRepeatedPrefixPostfix() {
        PrecedenceClimbingParser p = new PrecedenceClimbingParser.Builder().prefix((Object)"+", 3).prefix((Object)"-", 3).prefix((Object)"+", 3).prefix((Object)"+", 3).atom((Object)"a").postfix((Object)"!", 4).infix((Object)"+", 1, true).prefix((Object)"-", 3).prefix((Object)"-", 3).atom((Object)"b").postfix((Object)"!", 4).postfix((Object)"!", 4).build();
        PrecedenceClimbingParser.Token token = p.parse();
        Assert.assertThat((Object)p.print(token), (Matcher)CoreMatchers.is((Object)"((+ (- (+ (+ (a !))))) + (- (- ((b !) !))))"));
    }

    @Test
    public void testAtom() {
        PrecedenceClimbingParser p = new PrecedenceClimbingParser.Builder().atom((Object)"a").build();
        PrecedenceClimbingParser.Token token = p.parse();
        Assert.assertThat((Object)p.print(token), (Matcher)CoreMatchers.is((Object)"a"));
    }

    @Test
    public void testOnlyPrefix() {
        PrecedenceClimbingParser p = new PrecedenceClimbingParser.Builder().prefix((Object)"-", 3).prefix((Object)"-", 3).atom((Object)1).build();
        PrecedenceClimbingParser.Token token = p.parse();
        Assert.assertThat((Object)p.print(token), (Matcher)CoreMatchers.is((Object)"(- (- 1))"));
    }

    @Test
    public void testOnlyPostfix() {
        PrecedenceClimbingParser p = new PrecedenceClimbingParser.Builder().atom((Object)1).postfix((Object)"!", 33333).postfix((Object)"!", 33333).build();
        PrecedenceClimbingParser.Token token = p.parse();
        Assert.assertThat((Object)p.print(token), (Matcher)CoreMatchers.is((Object)"((1 !) !)"));
    }

    @Test
    public void testLeftAssociative() {
        PrecedenceClimbingParser p = new PrecedenceClimbingParser.Builder().atom((Object)"a").infix((Object)"*", 2, true).atom((Object)"b").infix((Object)"+", 1, true).atom((Object)"c").infix((Object)"+", 1, true).atom((Object)"d").infix((Object)"+", 1, true).atom((Object)"e").infix((Object)"*", 2, true).atom((Object)"f").build();
        PrecedenceClimbingParser.Token token = p.parse();
        Assert.assertThat((Object)p.print(token), (Matcher)CoreMatchers.is((Object)"((((a * b) + c) + d) + (e * f))"));
    }

    @Test
    public void testRightAssociative() {
        PrecedenceClimbingParser p = new PrecedenceClimbingParser.Builder().atom((Object)"a").infix((Object)"^", 3, false).atom((Object)"b").infix((Object)"^", 3, false).atom((Object)"c").infix((Object)"^", 3, false).atom((Object)"d").infix((Object)"+", 1, true).atom((Object)"e").infix((Object)"*", 2, true).atom((Object)"f").build();
        PrecedenceClimbingParser.Token token = p.parse();
        Assert.assertThat((Object)p.print(token), (Matcher)CoreMatchers.is((Object)"((a ^ (b ^ (c ^ d))) + (e * f))"));
    }

    @Test
    public void testSpecial() {
        PrecedenceClimbingParser p = new PrecedenceClimbingParser.Builder().atom((Object)"price").infix((Object)">", 4, true).atom((Object)"5").infix((Object)"and", 2, true).atom((Object)"price").special((Object)"between", 3, 3, new PrecedenceClimbingParser.Special(){

            public PrecedenceClimbingParser.Result apply(PrecedenceClimbingParser parser, PrecedenceClimbingParser.SpecialOp op) {
                return new PrecedenceClimbingParser.Result(op.previous, op.next.next.next, (PrecedenceClimbingParser.Token)parser.call((PrecedenceClimbingParser.Op)op, ImmutableList.of((Object)op.previous, (Object)op.next, (Object)op.next.next.next)));
            }
        }).atom((Object)"1").infix((Object)"+", 5, true).atom((Object)"2").infix((Object)"and", 2, true).atom((Object)"3").infix((Object)"*", 6, true).atom((Object)"4").infix((Object)"and", 2, true).atom((Object)"price").postfix((Object)"is null", 4).build();
        PrecedenceClimbingParser.Token token = p.parse();
        Assert.assertThat((Object)p.print(token), (Matcher)CoreMatchers.is((Object)"(((price > 5) and between(price, (1 + 2), (3 * 4))) and (price is null))"));
    }

    @Test
    public void testEqualPrecedence() {
        PrecedenceClimbingParser p = new PrecedenceClimbingParser.Builder().atom((Object)"a").infix((Object)"=", 3, true).atom((Object)"b").infix((Object)"like", 3, false).atom((Object)"c").infix((Object)"=", 3, true).atom((Object)"d").build();
        PrecedenceClimbingParser.Token token = p.parse();
        Assert.assertThat((Object)p.print(token), (Matcher)CoreMatchers.is((Object)"(((a = b) like c) = d)"));
    }
}

