/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.graph;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.util.graph.BreadthFirstIterator;
import org.apache.calcite.util.graph.CycleDetector;
import org.apache.calcite.util.graph.DefaultDirectedGraph;
import org.apache.calcite.util.graph.DefaultEdge;
import org.apache.calcite.util.graph.DepthFirstIterator;
import org.apache.calcite.util.graph.DirectedGraph;
import org.apache.calcite.util.graph.Graphs;
import org.apache.calcite.util.graph.TopologicalOrderIterator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DirectedGraphTest {
    @Test
    public void testOne() {
        DefaultDirectedGraph g = DefaultDirectedGraph.create();
        g.addVertex((Object)"A");
        g.addVertex((Object)"B");
        g.addVertex((Object)"C");
        g.addVertex((Object)"D");
        g.addVertex((Object)"E");
        g.addVertex((Object)"F");
        g.addEdge((Object)"A", (Object)"B");
        g.addEdge((Object)"B", (Object)"C");
        g.addEdge((Object)"D", (Object)"C");
        g.addEdge((Object)"C", (Object)"D");
        g.addEdge((Object)"E", (Object)"F");
        g.addEdge((Object)"C", (Object)"C");
        Assert.assertEquals((Object)"[A, B, C, D]", (Object)this.shortestPath((DirectedGraph)g, (Object)"A", (Object)"D").toString());
        g.addEdge((Object)"B", (Object)"D");
        Assert.assertEquals((Object)"[A, B, D]", (Object)this.shortestPath((DirectedGraph)g, (Object)"A", (Object)"D").toString());
        Assert.assertNull((String)"There is no path from A to E", this.shortestPath((DirectedGraph)g, (Object)"A", (Object)"E"));
        Assert.assertEquals((Object)"[]", (Object)this.shortestPath((DirectedGraph)g, (Object)"D", (Object)"D").toString());
        Assert.assertNull((String)"Node X is not in the graph", this.shortestPath((DirectedGraph)g, (Object)"X", (Object)"A"));
        Assert.assertEquals((Object)"[[A, B, C, D], [A, B, D]]", (Object)this.paths((DirectedGraph)g, (Object)"A", (Object)"D").toString());
    }

    private <V> List<V> shortestPath(DirectedGraph<V, DefaultEdge> g, V source, V target) {
        return Graphs.makeImmutable(g).getShortestPath(source, target);
    }

    private <V> List<List<V>> paths(DirectedGraph<V, DefaultEdge> g, V source, V target) {
        return Graphs.makeImmutable(g).getPaths(source, target);
    }

    @Test
    public void testVertexMustExist() {
        DefaultEdge x32;
        DefaultEdge x2;
        DefaultDirectedGraph g = DefaultDirectedGraph.create();
        boolean b = g.addVertex((Object)"A");
        Assert.assertTrue((boolean)b);
        boolean b2 = g.addVertex((Object)"A");
        Assert.assertFalse((boolean)b2);
        try {
            x2 = (DefaultEdge)g.addEdge((Object)"A", (Object)"B");
            Assert.fail((String)("expected exception, got " + x2));
        }
        catch (IllegalArgumentException x2) {
            // empty catch block
        }
        g.addVertex((Object)"B");
        x2 = (DefaultEdge)g.addEdge((Object)"A", (Object)"B");
        Assert.assertNotNull((Object)x2);
        DefaultEdge x2 = (DefaultEdge)g.addEdge((Object)"A", (Object)"B");
        Assert.assertNull((Object)x2);
        try {
            x32 = (DefaultEdge)g.addEdge((Object)"Z", (Object)"A");
            Assert.fail((String)("expected exception, got " + x32));
        }
        catch (IllegalArgumentException x32) {
            // empty catch block
        }
        g.addVertex((Object)"Z");
        x32 = (DefaultEdge)g.addEdge((Object)"Z", (Object)"A");
        Assert.assertNotNull((Object)x32);
        DefaultEdge x4 = (DefaultEdge)g.addEdge((Object)"Z", (Object)"A");
        Assert.assertNull((Object)x4);
        List in1 = g.getInwardEdges((Object)"A");
        List out1 = g.getOutwardEdges((Object)"A");
        boolean b3 = g.addVertex((Object)"A");
        Assert.assertFalse((boolean)b3);
        List in2 = g.getInwardEdges((Object)"A");
        List out2 = g.getOutwardEdges((Object)"A");
        Assert.assertEquals((Object)in1, (Object)in2);
        Assert.assertEquals((Object)out1, (Object)out2);
    }

    @Test
    public void testDepthFirst() {
        DefaultDirectedGraph<String, DefaultEdge> graph = this.createDag();
        ArrayList<String> list = new ArrayList<String>();
        for (String s : DepthFirstIterator.of(graph, (Object)"A")) {
            list.add(s);
        }
        Assert.assertThat((Object)((Object)list).toString(), (Matcher)CoreMatchers.equalTo((Object)"[A, B, C, D, E, C, D, F]"));
        list.clear();
        DepthFirstIterator.reachable(list, graph, (Object)"A");
        Assert.assertThat((Object)((Object)list).toString(), (Matcher)CoreMatchers.equalTo((Object)"[A, B, C, D, E, C, D, F]"));
    }

    @Test
    public void testPredecessorList() {
        DefaultDirectedGraph<String, DefaultEdge> graph = this.createDag();
        List list = Graphs.predecessorListOf(graph, (Object)"C");
        Assert.assertEquals((Object)"[B, E]", (Object)list.toString());
    }

    @Test
    public void testRemoveAllVertices() {
        DefaultDirectedGraph<String, DefaultEdge> graph = this.createDag();
        graph.removeAllVertices(Arrays.asList("B", "E"));
        Assert.assertEquals((Object)"[A, C, D, F]", (Object)graph.vertexSet().toString());
    }

    @Test
    public void testTopologicalOrderIterator() {
        DefaultDirectedGraph<String, DefaultEdge> graph = this.createDag();
        ArrayList<String> list = new ArrayList<String>();
        for (String s : TopologicalOrderIterator.of(graph)) {
            list.add(s);
        }
        Assert.assertEquals((Object)"[A, B, E, C, F, D]", (Object)((Object)list).toString());
    }

    private DefaultDirectedGraph<String, DefaultEdge> createDag() {
        DefaultDirectedGraph graph = DefaultDirectedGraph.create();
        graph.addVertex((Object)"A");
        graph.addVertex((Object)"B");
        graph.addVertex((Object)"C");
        graph.addVertex((Object)"D");
        graph.addVertex((Object)"E");
        graph.addVertex((Object)"F");
        graph.addEdge((Object)"A", (Object)"B");
        graph.addEdge((Object)"B", (Object)"C");
        graph.addEdge((Object)"C", (Object)"D");
        graph.addEdge((Object)"A", (Object)"E");
        graph.addEdge((Object)"E", (Object)"C");
        graph.addEdge((Object)"E", (Object)"F");
        return graph;
    }

    @Test
    public void testPaths() {
        DefaultDirectedGraph graph = DefaultDirectedGraph.create();
        graph.addVertex((Object)"A");
        graph.addVertex((Object)"B");
        graph.addVertex((Object)"C");
        graph.addVertex((Object)"D");
        graph.addVertex((Object)"E");
        graph.addVertex((Object)"F");
        graph.addEdge((Object)"A", (Object)"B");
        graph.addEdge((Object)"B", (Object)"C");
        graph.addEdge((Object)"A", (Object)"D");
        graph.addEdge((Object)"D", (Object)"E");
        graph.addEdge((Object)"C", (Object)"E");
        Graphs.FrozenGraph frozenGraph = Graphs.makeImmutable((DirectedGraph)graph);
        Assert.assertEquals((Object)"[A, B]", (Object)frozenGraph.getShortestPath((Object)"A", (Object)"B").toString());
        Assert.assertEquals((Object)"[[A, B]]", (Object)frozenGraph.getPaths((Object)"A", (Object)"B").toString());
        Assert.assertEquals((Object)"[A, D, E]", (Object)frozenGraph.getShortestPath((Object)"A", (Object)"E").toString());
        Assert.assertEquals((Object)"[[A, B, C, E], [A, D, E]]", (Object)frozenGraph.getPaths((Object)"A", (Object)"E").toString());
        Assert.assertNull((Object)frozenGraph.getShortestPath((Object)"B", (Object)"A"));
        Assert.assertNull((Object)frozenGraph.getShortestPath((Object)"D", (Object)"C"));
        Assert.assertEquals((Object)"[[D, E]]", (Object)frozenGraph.getPaths((Object)"D", (Object)"E").toString());
        Assert.assertEquals((Object)"[D, E]", (Object)frozenGraph.getShortestPath((Object)"D", (Object)"E").toString());
    }

    @Test
    public void testCycleDetection() {
        DefaultDirectedGraph<String, DefaultEdge> graph = this.createDag();
        Assert.assertThat((Object)new CycleDetector(graph).findCycles(), (Matcher)CoreMatchers.equalTo((Object)ImmutableSet.of()));
        graph.addEdge((Object)"D", (Object)"E");
        Assert.assertThat((Object)new CycleDetector(graph).findCycles(), (Matcher)CoreMatchers.equalTo((Object)ImmutableSet.of((Object)"C", (Object)"D", (Object)"E", (Object)"F")));
        graph.addEdge((Object)"D", (Object)"C");
        Assert.assertThat((Object)new CycleDetector(graph).findCycles(), (Matcher)CoreMatchers.equalTo((Object)ImmutableSet.of((Object)"C", (Object)"D", (Object)"E", (Object)"F")));
        graph.removeEdge((Object)"D", (Object)"E");
        graph.removeEdge((Object)"D", (Object)"C");
        graph.addEdge((Object)"C", (Object)"B");
        Assert.assertThat((Object)new CycleDetector(graph).findCycles(), (Matcher)CoreMatchers.equalTo((Object)ImmutableSet.of((Object)"B", (Object)"C", (Object)"D")));
        graph.removeEdge((Object)"C", (Object)"B");
        graph.addEdge((Object)"C", (Object)"C");
        Assert.assertThat((Object)new CycleDetector(graph).findCycles(), (Matcher)CoreMatchers.equalTo((Object)ImmutableSet.of((Object)"C", (Object)"D")));
        graph.removeAllVertices((Collection)graph.vertexSet());
        Assert.assertThat((Object)new CycleDetector(graph).findCycles(), (Matcher)CoreMatchers.equalTo((Object)ImmutableSet.of()));
    }

    @Test
    public void testBreadthFirstIterator() {
        DefaultDirectedGraph<String, DefaultEdge> graph = this.createDag();
        ImmutableList expected = ImmutableList.of((Object)"A", (Object)"B", (Object)"E", (Object)"C", (Object)"F", (Object)"D");
        Assert.assertThat(this.getA(graph, "A"), (Matcher)CoreMatchers.equalTo((Object)expected));
        Assert.assertThat((Object)Lists.newArrayList(this.getB(graph, "A")), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    private List<String> getA(DefaultDirectedGraph<String, DefaultEdge> graph, String root) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : BreadthFirstIterator.of(graph, (Object)root)) {
            list.add(s);
        }
        return list;
    }

    private Set<String> getB(DefaultDirectedGraph<String, DefaultEdge> graph, String root) {
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        BreadthFirstIterator.reachable(list, graph, (Object)root);
        return list;
    }
}

