/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.mapping;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class MappingTest {
    @Test
    public void testMappings() {
        Assert.assertTrue((boolean)Mappings.isIdentity((Mappings.TargetMapping)Mappings.createIdentity((int)0)));
        Assert.assertTrue((boolean)Mappings.isIdentity((Mappings.TargetMapping)Mappings.createIdentity((int)5)));
        Assert.assertFalse((boolean)Mappings.isIdentity((Mappings.TargetMapping)Mappings.create((MappingType)MappingType.PARTIAL_SURJECTION, (int)3, (int)4)));
        Assert.assertFalse((boolean)Mappings.isIdentity((Mappings.TargetMapping)Mappings.create((MappingType)MappingType.PARTIAL_SURJECTION, (int)3, (int)3)));
        Assert.assertFalse((boolean)Mappings.isIdentity((Mappings.TargetMapping)Mappings.create((MappingType)MappingType.PARTIAL_SURJECTION, (int)4, (int)4)));
    }

    @Test
    public void testMappingsCreateShiftMapping() {
        Assert.assertEquals((Object)"[size=5, sourceCount=20, targetCount=13, elements=[6:3, 7:4, 15:10, 16:11, 17:12]]", (Object)Mappings.createShiftMapping((int)20, (int[])new int[]{3, 6, 2, 10, 15, 3}).toString());
        Mappings.TargetMapping mapping = Mappings.createShiftMapping((int)20, (int[])new int[0]);
        Assert.assertEquals((Object)"[size=0, sourceCount=20, targetCount=0, elements=[]]", (Object)mapping.toString());
        Assert.assertEquals((long)20L, (long)mapping.getSourceCount());
        Assert.assertEquals((long)0L, (long)mapping.getTargetCount());
    }

    @Test
    public void testMappingsAppend() {
        Assert.assertTrue((boolean)Mappings.isIdentity((Mappings.TargetMapping)Mappings.append((Mappings.TargetMapping)Mappings.createIdentity((int)3), (Mappings.TargetMapping)Mappings.createIdentity((int)2))));
        Mapping mapping0 = Mappings.create((MappingType)MappingType.PARTIAL_SURJECTION, (int)5, (int)3);
        mapping0.set(0, 2);
        mapping0.set(3, 1);
        mapping0.set(4, 0);
        Assert.assertEquals((Object)"[size=5, sourceCount=7, targetCount=5, elements=[0:2, 3:1, 4:0, 5:3, 6:4]]", (Object)Mappings.append((Mappings.TargetMapping)mapping0, (Mappings.TargetMapping)Mappings.createIdentity((int)2)).toString());
    }

    @Test
    public void testMappingsOffsetSource() {
        Mappings.TargetMapping mapping = Mappings.target((Map)ImmutableMap.of((Object)0, (Object)5, (Object)1, (Object)7), (int)2, (int)8);
        Assert.assertEquals((Object)"[size=2, sourceCount=2, targetCount=8, elements=[0:5, 1:7]]", (Object)mapping.toString());
        Assert.assertEquals((long)2L, (long)mapping.getSourceCount());
        Assert.assertEquals((long)8L, (long)mapping.getTargetCount());
        Mappings.TargetMapping mapping1 = Mappings.offsetSource((Mappings.TargetMapping)mapping, (int)3, (int)5);
        Assert.assertEquals((Object)"[size=2, sourceCount=5, targetCount=8, elements=[3:5, 4:7]]", (Object)mapping1.toString());
        Assert.assertEquals((long)5L, (long)mapping1.getSourceCount());
        Assert.assertEquals((long)8L, (long)mapping1.getTargetCount());
        Mappings.TargetMapping mapping2 = Mappings.offsetSource((Mappings.TargetMapping)mapping, (int)3, (int)15);
        Assert.assertEquals((Object)"[size=2, sourceCount=15, targetCount=8, elements=[3:5, 4:7]]", (Object)mapping2.toString());
        Assert.assertEquals((long)15L, (long)mapping2.getSourceCount());
        Assert.assertEquals((long)8L, (long)mapping2.getTargetCount());
        try {
            Mappings.TargetMapping mapping3 = Mappings.offsetSource((Mappings.TargetMapping)mapping, (int)3, (int)4);
            Assert.fail((String)("expected exception, got " + mapping3));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSource() {
        List<Integer> targets = Arrays.asList(3, 1, 4, 5, 8);
        Mapping mapping = Mappings.source(targets, (int)10);
        Assert.assertThat((Object)mapping.getTarget(0), (Matcher)CoreMatchers.equalTo((Object)3));
        Assert.assertThat((Object)mapping.getTarget(1), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)mapping.getTarget(2), (Matcher)CoreMatchers.equalTo((Object)4));
        Assert.assertThat((Object)mapping.getTargetCount(), (Matcher)CoreMatchers.equalTo((Object)10));
        Assert.assertThat((Object)mapping.getSourceCount(), (Matcher)CoreMatchers.equalTo((Object)5));
        List integers = Mappings.asList((Mappings.TargetMapping)mapping);
        Assert.assertThat((Object)integers, (Matcher)CoreMatchers.equalTo(targets));
        Mapping inverse = mapping.inverse();
        Assert.assertThat((Object)inverse.toString(), (Matcher)CoreMatchers.equalTo((Object)"[size=5, sourceCount=10, targetCount=5, elements=[1:1, 3:0, 4:2, 5:3, 8:4]]"));
    }

    @Test
    public void testTarget() {
        List<Integer> sources = Arrays.asList(3, 1, 4, 5, 8);
        Mapping mapping = Mappings.target(sources, (int)10);
        Assert.assertThat((Object)mapping.getTarget(3), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)mapping.getTarget(1), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)mapping.getTarget(4), (Matcher)CoreMatchers.equalTo((Object)2));
        try {
            int target = mapping.getTarget(0);
            Assert.fail((String)("expected error, got " + target));
        }
        catch (Mappings.NoElementException target) {
            // empty catch block
        }
        Assert.assertThat((Object)mapping.getTargetCount(), (Matcher)CoreMatchers.equalTo((Object)5));
        Assert.assertThat((Object)mapping.getSourceCount(), (Matcher)CoreMatchers.equalTo((Object)10));
        List integers = Mappings.asList((Mappings.TargetMapping)mapping);
        Assert.assertThat((Object)integers, (Matcher)CoreMatchers.equalTo(Arrays.asList(null, 1, null, 0, 2, 3, null, null, 4, null)));
    }

    @Test
    public void testBijection() {
        Mapping x;
        List<Integer> targets = Arrays.asList(3, 0, 1, 2);
        Mapping mapping = Mappings.bijection(targets);
        Assert.assertThat((Object)mapping.size(), (Matcher)CoreMatchers.equalTo((Object)4));
        Assert.assertThat((Object)mapping.getTarget(0), (Matcher)CoreMatchers.equalTo((Object)3));
        Assert.assertThat((Object)mapping.getTarget(1), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)mapping.getTarget(2), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)mapping.getTarget(3), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)mapping.getTargetOpt(3), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)mapping.getSource(3), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)mapping.getSourceOpt(3), (Matcher)CoreMatchers.equalTo((Object)0));
        try {
            int target = mapping.getTarget(4);
            Assert.fail((String)("expected error, got " + target));
        }
        catch (Mappings.NoElementException target) {
            // empty catch block
        }
        try {
            int source = mapping.getSource(4);
            Assert.fail((String)("expected error, got " + source));
        }
        catch (Mappings.NoElementException source) {
            // empty catch block
        }
        Assert.assertThat((Object)mapping.getTargetCount(), (Matcher)CoreMatchers.equalTo((Object)4));
        Assert.assertThat((Object)mapping.getSourceCount(), (Matcher)CoreMatchers.equalTo((Object)4));
        Assert.assertThat((Object)mapping.toString(), (Matcher)CoreMatchers.equalTo((Object)"[3, 0, 1, 2]"));
        Assert.assertThat((Object)mapping.inverse().toString(), (Matcher)CoreMatchers.equalTo((Object)"[1, 2, 3, 0]"));
        Mapping empty = Mappings.bijection(Collections.emptyList());
        Assert.assertThat((Object)empty.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)empty.iterator().hasNext(), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)empty.toString(), (Matcher)CoreMatchers.equalTo((Object)"[]"));
        try {
            x = Mappings.bijection(Arrays.asList(0, 5, 1));
            Assert.fail((String)("expected error, got " + x));
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"target out of range"));
        }
        try {
            x = Mappings.bijection(Arrays.asList(1, 0, 1));
            Assert.fail((String)("expected error, got " + x));
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"more than one permutation element maps to position 1"));
        }
    }
}

