/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.jee.sessions.jetty;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;
import org.openspaces.core.GigaSpace;
import org.openspaces.jee.sessions.jetty.AbstractSessionIdManager;
import org.openspaces.jee.sessions.jetty.SessionData;

public class GigaSessionIdManager
extends AbstractSessionIdManager {
    protected final Server _server;
    protected GigaSpace gigaSpace;

    public GigaSessionIdManager(Server server) {
        this._server = server;
    }

    public void setSpace(GigaSpace gigaSpace) {
        this.gigaSpace = gigaSpace;
    }

    public GigaSpace getSpace() {
        return this.gigaSpace;
    }

    @Override
    public void doStart() {
        try {
            if (this.gigaSpace == null) {
                this.initSpace();
            }
            super.doStart();
        }
        catch (Exception e) {
            Log.getLog().warn("Problem initialising session ids", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    protected void initSpace() throws Exception {
        if (this.gigaSpace == null) {
            throw new IllegalStateException("No space configured");
        }
    }

    public void addSession(HttpSession session) {
    }

    public void removeSession(HttpSession session) {
    }

    public void renewSessionId(String oldClusterId, String oldNodeId, HttpServletRequest request) {
        try {
            SessionData sessionData = (SessionData)this.gigaSpace.takeById(SessionData.newIdQuery(oldClusterId));
            if (sessionData == null) {
                if (Log.getLog().isDebugEnabled()) {
                    Log.getLog().debug("Cannot renew session Id [" + oldClusterId + "] - does not exist in space", new Object[0]);
                }
            } else {
                String newClusterId = this.getClusterId(request.getRequestedSessionId());
                sessionData.setId(newClusterId);
                this.gigaSpace.write((Object)sessionData);
                if (Log.getLog().isDebugEnabled()) {
                    Log.getLog().debug("Renewed session Id [" + oldClusterId + "] to [" + newClusterId + "]", new Object[0]);
                }
            }
        }
        catch (Exception e) {
            Log.getLog().warn("Failed to renew [oldClusterId=" + oldClusterId + ", oldNodeId=" + oldNodeId + "]", (Throwable)e);
        }
    }

    public String getClusterId(String nodeId) {
        int dot = nodeId.lastIndexOf(46);
        return dot > 0 ? nodeId.substring(0, dot) : nodeId;
    }

    public String getNodeId(String clusterId, HttpServletRequest request) {
        return this._workerName != null ? clusterId + '.' + this._workerName : clusterId;
    }

    public boolean idInUse(String id) {
        if (id == null) {
            return false;
        }
        String sessionId = this.getClusterId(id);
        try {
            boolean exists;
            int count = this.gigaSpace.count(SessionData.newIdQuery(sessionId));
            boolean bl = exists = count > 0;
            if (Log.getLog().isDebugEnabled()) {
                Log.getLog().debug("Id [" + id + "] " + (exists ? "exists" : "does not exist") + " in space", new Object[0]);
            }
            return exists;
        }
        catch (Exception e) {
            Log.getLog().warn("Problem checking inUse for id=" + sessionId, (Throwable)e);
            return false;
        }
    }

    public void invalidateAll(String id) {
        Handler[] contexts = this._server.getChildHandlersByClass(WebAppContext.class);
        for (int i = 0; contexts != null && i < contexts.length; ++i) {
            AbstractSessionManager manager = (AbstractSessionManager)((WebAppContext)contexts[i]).getSessionHandler().getSessionManager();
            AbstractSession session = manager.getSession(id);
            if (session == null) continue;
            session.invalidate();
        }
    }
}

