/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.jee.sessions.jetty;

import com.gigaspaces.client.ClearModifiers;
import com.gigaspaces.query.ISpaceQuery;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.SQLQuery;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.MemSession;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.GigaSpaceConfigurer;
import org.openspaces.core.space.SpaceConfigurer;
import org.openspaces.core.space.UrlSpaceConfigurer;
import org.openspaces.jee.sessions.jetty.GigaSessionIdManager;
import org.openspaces.jee.sessions.jetty.SessionData;

public class GigaSessionManager
extends AbstractSessionManager {
    private GigaSpace gigaSpace;
    private UrlSpaceConfigurer urlSpaceConfigurer;
    private long lease = Long.MAX_VALUE;
    protected long _scavengePeriodMs = TimeUnit.MINUTES.toMillis(5L);
    protected int _scavengeCount = 0;
    protected long _savePeriodMs = TimeUnit.MINUTES.toMillis(1L);
    private static volatile ScheduledExecutorService executorService;
    private static volatile int totalNumberOfScavangers;
    private volatile ScheduledFuture scavengerFuture;
    private static final Object executorMonitor;
    private volatile int lastSessionCount = -1;
    private volatile long lastCountSessionsTime = System.currentTimeMillis();
    private long countSessionPeriod = TimeUnit.MINUTES.toMillis(5L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        if (this.gigaSpace == null) {
            this.gigaSpace = new GigaSpaceConfigurer((SpaceConfigurer)this.urlSpaceConfigurer).create();
        }
        if (this._sessionIdManager == null) {
            this._sessionIdManager = new GigaSessionIdManager(this.getSessionHandler().getServer());
            ((GigaSessionIdManager)this._sessionIdManager).setSpace(this.gigaSpace);
        }
        if (this._sessionIdManager instanceof GigaSessionIdManager && ((GigaSessionIdManager)this._sessionIdManager).getSpace() == null) {
            ((GigaSessionIdManager)this._sessionIdManager).setSpace(this.gigaSpace);
        }
        Object object = executorMonitor;
        synchronized (object) {
            if (totalNumberOfScavangers == 0) {
                if (Log.getLog().isDebugEnabled()) {
                    Log.getLog().debug("Starting scavenger with period [" + this._scavengePeriodMs + "ms]", new Object[0]);
                }
                executorService = Executors.newScheduledThreadPool(1);
            }
            ++totalNumberOfScavangers;
            this.scavengerFuture = executorService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    GigaSessionManager.this.scavenge();
                }
            }, this._scavengePeriodMs, this._scavengePeriodMs, TimeUnit.MILLISECONDS);
        }
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() throws Exception {
        Object object = executorMonitor;
        synchronized (object) {
            if (this.scavengerFuture != null) {
                this.scavengerFuture.cancel(true);
                if (--totalNumberOfScavangers == 0) {
                    if (Log.getLog().isDebugEnabled()) {
                        Log.getLog().debug("Stopping scavenger", new Object[0]);
                    }
                    executorService.shutdown();
                }
            }
        }
        this.gigaSpace = null;
        if (this.urlSpaceConfigurer != null) {
            this.urlSpaceConfigurer.close();
        }
        super.doStop();
    }

    public int getSavePeriod() {
        return (int)TimeUnit.MILLISECONDS.toSeconds(this._savePeriodMs);
    }

    public void setSavePeriod(int seconds) {
        if (seconds <= 0) {
            seconds = 60;
        }
        this._savePeriodMs = TimeUnit.SECONDS.toMillis(seconds);
    }

    public int getScavengePeriod() {
        return (int)TimeUnit.MILLISECONDS.toSeconds(this._scavengePeriodMs);
    }

    public void setScavengePeriod(int seconds) {
        if (seconds <= 0) {
            seconds = 60;
        }
        this._scavengePeriodMs = TimeUnit.SECONDS.toMillis(seconds);
    }

    public void setCountSessionPeriod(int seconds) {
        this.countSessionPeriod = TimeUnit.SECONDS.toMillis(seconds);
    }

    public void setUrlSpaceConfigurer(UrlSpaceConfigurer urlSpaceConfigurer) {
        this.urlSpaceConfigurer = urlSpaceConfigurer;
    }

    public void setSpace(GigaSpace gigaSpace) {
        this.gigaSpace = gigaSpace;
    }

    public void setSpace(IJSpace space) {
        this.gigaSpace = new GigaSpaceConfigurer(space).create();
    }

    public GigaSpace getSpace() {
        return this.gigaSpace;
    }

    public void setLease(long lease) {
        this.lease = TimeUnit.SECONDS.toMillis(lease);
    }

    public AbstractSession getSession(String idInCluster) {
        try {
            SessionData data = (SessionData)this.gigaSpace.readById(SessionData.newIdQuery(idInCluster));
            if (data == null) {
                if (Log.getLog().isDebugEnabled()) {
                    Log.getLog().debug("No session matching id [" + idInCluster + "]", new Object[0]);
                }
                return null;
            }
            if (Log.getLog().isDebugEnabled()) {
                Log.getLog().debug("Found matching session [" + idInCluster + "]", new Object[0]);
            }
            return new Session(data);
        }
        catch (Exception e) {
            Log.getLog().warn("Unable to load session", (Throwable)e);
            return null;
        }
    }

    public int getSessions() {
        long now = System.currentTimeMillis();
        if (this.lastSessionCount == -1 || now - this.lastCountSessionsTime > this.countSessionPeriod) {
            try {
                this.lastSessionCount = this.gigaSpace.count((Object)new SessionData());
            }
            catch (Exception e) {
                Log.getLog().warn("Failed to execute count of sessions", (Throwable)e);
            }
            this.lastCountSessionsTime = now;
        }
        return this.lastSessionCount;
    }

    public void statsReset() {
        this.lastSessionCount = -1;
        super.statsReset();
    }

    protected void shutdownSessions() throws Exception {
    }

    protected AbstractSession newSession(HttpServletRequest request) {
        return new Session(request);
    }

    protected boolean removeSession(String idInCluster) {
        try {
            return this.gigaSpace.clear(SessionData.newIdQuery(idInCluster), ClearModifiers.NONE) != 0;
        }
        catch (Exception e) {
            Log.getLog().warn("Failed to remove session with id [" + idInCluster + "]", (Throwable)e);
            return false;
        }
    }

    public boolean removeSession(AbstractSession abstractSession, boolean invalidate) {
        if (!(abstractSession instanceof Session)) {
            throw new IllegalStateException("Session is not a GigaspacesSessionManager.Session " + abstractSession);
        }
        String sessionId = this.getClusterId((HttpSession)abstractSession);
        boolean removed = this.removeSession(sessionId);
        if (removed) {
            this._sessionIdManager.removeSession((HttpSession)abstractSession);
            if (invalidate) {
                this._sessionIdManager.invalidateAll(sessionId);
            }
        }
        if (invalidate && this._sessionListeners != null) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)abstractSession);
            int i = LazyList.size((Object)this._sessionListeners);
            while (i-- > 0) {
                ((HttpSessionListener)LazyList.get((Object)this._sessionListeners, (int)i)).sessionDestroyed(event);
            }
        }
        if (!invalidate) {
            abstractSession.willPassivate();
        }
        return removed;
    }

    protected void addSession(AbstractSession abstractSession) {
        if (abstractSession == null) {
            return;
        }
        if (!(abstractSession instanceof Session)) {
            throw new IllegalStateException("Not a GigaspacesSessionManager.Session " + abstractSession);
        }
        Session session = (Session)abstractSession;
        try {
            this.gigaSpace.write((Object)session._data, this.lease);
        }
        catch (Exception e) {
            Log.getLog().warn("Problem writing new SessionData to space ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scavenge() {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader origClassLoader = thread.getContextClassLoader();
        ++this._scavengeCount;
        try {
            Object[] expiredSessions;
            if (this._loader != null) {
                thread.setContextClassLoader(this._loader);
            }
            long now = System.currentTimeMillis();
            if (Log.getLog().isDebugEnabled()) {
                Log.getLog().debug("Scavenging old sessions, expiring before: " + now, new Object[0]);
            }
            do {
                expiredSessions = this.gigaSpace.readMultiple((ISpaceQuery)new SQLQuery(SessionData.class, "expiryTime < ?", new Object[]{now}), 100);
                for (int i = 0; i < expiredSessions.length; ++i) {
                    if (Log.getLog().isDebugEnabled()) {
                        Log.getLog().debug("Timing out expired session " + expiredSessions[i], new Object[0]);
                    }
                    Session expiredSession = new Session((SessionData)expiredSessions[i]);
                    expiredSession.timeout();
                    if (!Log.getLog().isDebugEnabled()) continue;
                    Log.getLog().debug("Expiring old session " + expiredSession._data, new Object[0]);
                }
            } while (expiredSessions.length > 0);
            this.lastSessionCount = -1;
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            Log.getLog().warn("Problem scavenging sessions", t);
        }
        finally {
            thread.setContextClassLoader(origClassLoader);
        }
    }

    static {
        totalNumberOfScavangers = 0;
        executorMonitor = new Object();
    }

    public class Session
    extends MemSession {
        private final SessionData _data;
        private volatile boolean _dirty;

        protected Session(HttpServletRequest request) {
            super((AbstractSessionManager)GigaSessionManager.this, request);
            this._dirty = false;
            this._data = new SessionData(this.getClusterId());
            this._data.setMaxIdleMs(TimeUnit.SECONDS.toMillis(GigaSessionManager.this._dftMaxIdleSecs));
            this._data.setExpiryTime(this.getMaxInactiveInterval() < 0 ? Long.MAX_VALUE : System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.getMaxInactiveInterval()));
            this._data.setCookieSet(0L);
            Enumeration attributeNames = this.getAttributeNames();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            while (attributeNames.hasMoreElements()) {
                String nextAttribute = (String)attributeNames.nextElement();
                attributes.put(nextAttribute, request.getAttribute(nextAttribute));
            }
            this._data.setAttributeMap(attributes);
            if (Log.getLog().isDebugEnabled()) {
                Log.getLog().debug("New Session from request, " + this._data.toStringExtended(), new Object[0]);
            }
        }

        protected Session(SessionData data) {
            super((AbstractSessionManager)GigaSessionManager.this, data.getCreated(), data.getAccessed(), data.getId());
            this._dirty = false;
            this._data = data;
            for (Map.Entry<String, Object> attribute : data.getAttributeMap().entrySet()) {
                super.setAttribute(attribute.getKey(), attribute.getValue());
            }
            Enumeration attributeNames = this.getAttributeNames();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            while (attributeNames.hasMoreElements()) {
                String nextAttribute = (String)attributeNames.nextElement();
                attributes.put(nextAttribute, super.getAttribute(nextAttribute));
            }
            this._data.setAttributeMap(attributes);
            if (Log.getLog().isDebugEnabled()) {
                Log.getLog().debug("New Session from existing session data " + this._data.toStringExtended(), new Object[0]);
            }
        }

        protected void cookieSet() {
            this._data.setCookieSet(this._data.getAccessed());
        }

        public void setAttribute(String name, Object value) {
            super.setAttribute(name, value);
            if (value == null) {
                this._data.getAttributeMap().remove(name);
            } else {
                this._data.getAttributeMap().put(name, value);
            }
            this._dirty = true;
        }

        public void removeAttribute(String name) {
            super.removeAttribute(name);
            this._data.getAttributeMap().remove(name);
            this._dirty = true;
        }

        protected boolean access(long time) {
            boolean access = super.access(time);
            this._data.setLastAccessed(this._data.getAccessed());
            this._data.setAccessed(time);
            this._data.setExpiryTime(this.getMaxInactiveInterval() < 0 ? Long.MAX_VALUE : time + TimeUnit.SECONDS.toMillis(this.getMaxInactiveInterval()));
            return access;
        }

        public void setMaxInactiveInterval(int seconds) {
            super.setMaxInactiveInterval(seconds);
            this._data.setExpiryTime(this.getMaxInactiveInterval() < 0 ? Long.MAX_VALUE : System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.getMaxInactiveInterval()));
        }

        protected void complete() {
            super.complete();
            try {
                if (this._dirty || this._data.getAccessed() - this._data.getLastSaved() >= GigaSessionManager.this._savePeriodMs) {
                    this._data.setLastSaved(System.currentTimeMillis());
                    this.willPassivate();
                    GigaSessionManager.this.gigaSpace.write((Object)this._data, GigaSessionManager.this.lease);
                    if (Log.getLog().isDebugEnabled()) {
                        Log.getLog().debug("Wrote session " + this._data.toStringExtended(), new Object[0]);
                    }
                    this.didActivate();
                    if (Log.getLog().isDebugEnabled()) {
                        Log.getLog().debug("Dirty=" + this._dirty + ", accessed-saved=" + this._data.getAccessed() + "-" + this._data.getLastSaved() + ", savePeriodMs=" + GigaSessionManager.this._savePeriodMs, new Object[0]);
                    }
                }
            }
            catch (Exception e) {
                Log.getLog().warn("Problem persisting changed session data id=" + this.getId(), (Throwable)e);
            }
            finally {
                this._dirty = false;
            }
        }

        protected void timeout() throws IllegalStateException {
            if (Log.getLog().isDebugEnabled()) {
                Log.getLog().debug("Timing out session id=" + this.getClusterId(), new Object[0]);
            }
            super.timeout();
        }
    }
}

