/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.jee.sessions.jetty;

import com.gigaspaces.annotation.pojo.SpaceClass;
import com.gigaspaces.annotation.pojo.SpaceId;
import com.gigaspaces.annotation.pojo.SpaceProperty;
import com.gigaspaces.annotation.pojo.SpaceRouting;
import com.gigaspaces.query.IdQuery;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@SpaceClass
public class SessionData
implements Externalizable {
    private static final long serialVersionUID = 3104738310898353395L;
    private String _id;
    private long _accessed = -1L;
    private volatile long _lastAccessed = -1L;
    private volatile long _lastSaved = -1L;
    private long _maxIdleMs = -1L;
    private volatile long _cookieSet = -1L;
    private long _created = -1L;
    private volatile long _expiryTime = -1L;
    private volatile Map<String, Object> _attributes = null;

    public SessionData() {
    }

    public SessionData(String sessionId) {
        this._id = sessionId;
        this._accessed = this._created = System.currentTimeMillis();
        this._lastAccessed = 0L;
        this._lastSaved = 0L;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this._id == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this._id);
        }
        out.writeLong(this._accessed);
        out.writeLong(this._lastAccessed);
        out.writeLong(this._lastSaved);
        out.writeLong(this._maxIdleMs);
        out.writeLong(this._cookieSet);
        out.writeLong(this._created);
        out.writeLong(this._expiryTime);
        if (this._attributes == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this._attributes.size());
            for (Map.Entry<String, Object> entry : this._attributes.entrySet()) {
                out.writeObject(entry.getKey());
                out.writeObject(entry.getValue());
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            this._id = in.readUTF();
        }
        this._accessed = in.readLong();
        this._lastAccessed = in.readLong();
        this._lastSaved = in.readLong();
        this._maxIdleMs = in.readLong();
        this._cookieSet = in.readLong();
        this._created = in.readLong();
        this._expiryTime = in.readLong();
        int size = in.readInt();
        if (size > -1) {
            this._attributes = new ConcurrentHashMap<String, Object>();
            for (int i = 0; i < size; ++i) {
                this._attributes.put((String)in.readObject(), in.readObject());
            }
        }
    }

    @SpaceId(autoGenerate=false)
    @SpaceRouting
    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    @SpaceProperty(nullValue="-1")
    public long getCreated() {
        return this._created;
    }

    public void setCreated(long ms) {
        this._created = ms;
    }

    @SpaceProperty(nullValue="-1")
    public long getAccessed() {
        return this._accessed;
    }

    public void setAccessed(long ms) {
        this._accessed = ms;
    }

    public void setLastSaved(long ms) {
        this._lastSaved = ms;
    }

    @SpaceProperty(nullValue="-1")
    public long getLastSaved() {
        return this._lastSaved;
    }

    public void setMaxIdleMs(long ms) {
        this._maxIdleMs = ms;
    }

    @SpaceProperty(nullValue="-1")
    public long getMaxIdleMs() {
        return this._maxIdleMs;
    }

    public void setLastAccessed(long ms) {
        this._lastAccessed = ms;
    }

    @SpaceProperty(nullValue="-1")
    public long getLastAccessed() {
        return this._lastAccessed;
    }

    public void setCookieSet(long ms) {
        this._cookieSet = ms;
    }

    @SpaceProperty(nullValue="-1")
    public long getCookieSet() {
        return this._cookieSet;
    }

    @SpaceProperty
    protected Map<String, Object> getAttributeMap() {
        return this._attributes;
    }

    protected void setAttributeMap(Map<String, Object> map) {
        this._attributes = map;
    }

    public void setExpiryTime(long time) {
        this._expiryTime = time;
    }

    @SpaceProperty(nullValue="-1")
    public long getExpiryTime() {
        return this._expiryTime;
    }

    public String toString() {
        return "Session id=" + this._id + ",created=" + this._created + ",accessed=" + this._accessed + ",lastAccessed=" + this._lastAccessed + ",cookieSet=" + this._cookieSet + ",expiryTime=" + this._expiryTime;
    }

    public String toStringExtended() {
        return this.toString() + "values=" + this._attributes;
    }

    public static IdQuery<SessionData> newIdQuery(String id) {
        return new IdQuery(SessionData.class, (Object)id);
    }
}

